/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.ProcurationSyntax;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralName;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralNames;
import edu.illinois.ncsa.bouncycastle.asn1.x509.IssuerSerial;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Name;
import java.io.IOException;

public class ProcurationSyntaxUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "ProcurationSyntax";
    }

    public void performTest() throws Exception {
        String string = "AU";
        DirectoryString directoryString = new DirectoryString("substitution");
        GeneralName generalName = new GeneralName(new X509Name("CN=thirdPerson"));
        IssuerSerial issuerSerial = new IssuerSerial(new GeneralNames(new GeneralName(new X509Name("CN=test"))), new DERInteger(1));
        ProcurationSyntax procurationSyntax = new ProcurationSyntax(string, directoryString, generalName);
        this.checkConstruction(procurationSyntax, string, directoryString, generalName, null);
        procurationSyntax = new ProcurationSyntax(string, directoryString, issuerSerial);
        this.checkConstruction(procurationSyntax, string, directoryString, null, issuerSerial);
        procurationSyntax = new ProcurationSyntax(null, directoryString, issuerSerial);
        this.checkConstruction(procurationSyntax, null, directoryString, null, issuerSerial);
        procurationSyntax = new ProcurationSyntax(string, null, issuerSerial);
        this.checkConstruction(procurationSyntax, string, null, null, issuerSerial);
        procurationSyntax = ProcurationSyntax.getInstance(null);
        if (procurationSyntax != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            ProcurationSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(ProcurationSyntax procurationSyntax, String string, DirectoryString directoryString, GeneralName generalName, IssuerSerial issuerSerial) throws IOException {
        this.checkValues(procurationSyntax, string, directoryString, generalName, issuerSerial);
        procurationSyntax = ProcurationSyntax.getInstance(procurationSyntax);
        this.checkValues(procurationSyntax, string, directoryString, generalName, issuerSerial);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(procurationSyntax.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        procurationSyntax = ProcurationSyntax.getInstance(aSN1Sequence);
        this.checkValues(procurationSyntax, string, directoryString, generalName, issuerSerial);
    }

    private void checkValues(ProcurationSyntax procurationSyntax, String string, DirectoryString directoryString, GeneralName generalName, IssuerSerial issuerSerial) {
        this.checkOptionalField("country", string, procurationSyntax.getCountry());
        this.checkOptionalField("typeOfSubstitution", directoryString, procurationSyntax.getTypeOfSubstitution());
        this.checkOptionalField("thirdPerson", generalName, procurationSyntax.getThirdPerson());
        this.checkOptionalField("certRef", issuerSerial, procurationSyntax.getCertRef());
    }

    public static void main(String[] stringArray) {
        ProcurationSyntaxUnitTest.runTest(new ProcurationSyntaxUnitTest());
    }
}

