/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERString;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.Restriction;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import java.io.IOException;

public class RestrictionUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "Restriction";
    }

    public void performTest() throws Exception {
        DirectoryString directoryString = new DirectoryString("test");
        Restriction restriction = new Restriction(directoryString.getString());
        this.checkConstruction(restriction, directoryString);
        try {
            Restriction.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(Restriction restriction, DirectoryString directoryString) throws IOException {
        this.checkValues(restriction, directoryString);
        restriction = Restriction.getInstance(restriction);
        this.checkValues(restriction, directoryString);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(restriction.toASN1Object().getEncoded());
        DERString dERString = (DERString)((Object)aSN1InputStream.readObject());
        restriction = Restriction.getInstance(dERString);
        this.checkValues(restriction, directoryString);
    }

    private void checkValues(Restriction restriction, DirectoryString directoryString) {
        this.checkMandatoryField("restriction", directoryString, restriction.getRestriction());
    }

    public static void main(String[] stringArray) {
        RestrictionUnitTest.runTest(new RestrictionUnitTest());
    }
}

