/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralName;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Name;
import edu.illinois.ncsa.bouncycastle.asn1.x509.qualified.SemanticsInformation;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class SemanticsInformationUnitTest
extends SimpleTest {
    public String getName() {
        return "SemanticsInformation";
    }

    public void performTest() throws Exception {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("1.1");
        SemanticsInformation semanticsInformation = new SemanticsInformation(dERObjectIdentifier);
        this.checkConstruction(semanticsInformation, dERObjectIdentifier, null);
        GeneralName[] generalNameArray = new GeneralName[]{new GeneralName(1, "test@test.org"), new GeneralName(new X509Name("cn=test"))};
        semanticsInformation = new SemanticsInformation(dERObjectIdentifier, generalNameArray);
        this.checkConstruction(semanticsInformation, dERObjectIdentifier, generalNameArray);
        semanticsInformation = new SemanticsInformation(generalNameArray);
        this.checkConstruction(semanticsInformation, null, generalNameArray);
        semanticsInformation = SemanticsInformation.getInstance(null);
        if (semanticsInformation != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            SemanticsInformation.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            new SemanticsInformation(new DERSequence(aSN1EncodableVector));
            this.fail("constructor failed to detect empty sequence.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(SemanticsInformation semanticsInformation, DERObjectIdentifier dERObjectIdentifier, GeneralName[] generalNameArray) throws Exception {
        this.checkStatement(semanticsInformation, dERObjectIdentifier, generalNameArray);
        semanticsInformation = SemanticsInformation.getInstance(semanticsInformation);
        this.checkStatement(semanticsInformation, dERObjectIdentifier, generalNameArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(semanticsInformation.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        semanticsInformation = SemanticsInformation.getInstance(aSN1Sequence);
        this.checkStatement(semanticsInformation, dERObjectIdentifier, generalNameArray);
    }

    private void checkStatement(SemanticsInformation semanticsInformation, DERObjectIdentifier dERObjectIdentifier, GeneralName[] generalNameArray) {
        if (dERObjectIdentifier != null) {
            if (!semanticsInformation.getSemanticsIdentifier().equals(dERObjectIdentifier)) {
                this.fail("ids don't match.");
            }
        } else if (semanticsInformation.getSemanticsIdentifier() != null) {
            this.fail("statementId found when none expected.");
        }
        if (generalNameArray != null) {
            GeneralName[] generalNameArray2 = semanticsInformation.getNameRegistrationAuthorities();
            for (int i = 0; i != generalNameArray2.length; ++i) {
                if (generalNameArray[i].equals(generalNameArray2[i])) continue;
                this.fail("name registration authorities don't match.");
            }
        } else if (semanticsInformation.getNameRegistrationAuthorities() != null) {
            this.fail("name registration authorities found when none expected.");
        }
    }

    public static void main(String[] stringArray) {
        SemanticsInformationUnitTest.runTest(new SemanticsInformationUnitTest());
    }
}

