/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.DERT61String;
import edu.illinois.ncsa.bouncycastle.asn1.DERUniversalString;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class StringTest
extends SimpleTest {
    public String getName() {
        return "String";
    }

    public void performTest() throws IOException {
        DERUniversalString dERUniversalString;
        DERBitString dERBitString = new DERBitString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17});
        if (!dERBitString.getString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!dERBitString.toString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(dERBitString = new DERBitString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!dERBitString.toString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(dERUniversalString = new DERUniversalString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17})).getString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!dERUniversalString.toString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        if (!(dERUniversalString = new DERUniversalString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!dERUniversalString.toString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        byte[] byArray = new byte[]{-1, -2, -3, -4, -5, -6, -7, -8};
        String string = new String(byArray, "iso-8859-1");
        DERT61String dERT61String = new DERT61String(byArray);
        if (!dERT61String.getString().equals(string)) {
            this.fail("DERT61String.getString() result incorrect");
        }
        if (!dERT61String.toString().equals(string)) {
            this.fail("DERT61String.toString() result incorrect");
        }
    }

    public static void main(String[] stringArray) {
        StringTest.runTest(new StringTest());
    }
}

