/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.DERUTCTime;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;

public class UTCTimeTest
extends SimpleTest {
    String[] input = new String[]{"020122122220Z", "020122122220-1000", "020122122220+1000", "020122122220+00", "0201221222Z", "0201221222-1000", "0201221222+1000", "0201221222+00", "550122122220Z", "5501221222Z"};
    String[] output = new String[]{"20020122122220GMT+00:00", "20020122122220GMT-10:00", "20020122122220GMT+10:00", "20020122122220GMT+00:00", "20020122122200GMT+00:00", "20020122122200GMT-10:00", "20020122122200GMT+10:00", "20020122122200GMT+00:00", "19550122122220GMT+00:00", "19550122122200GMT+00:00"};
    String[] zOutput1 = new String[]{"20020122122220Z", "20020122222220Z", "20020122022220Z", "20020122122220Z", "20020122122200Z", "20020122222200Z", "20020122022200Z", "20020122122200Z", "19550122122220Z", "19550122122200Z"};
    String[] zOutput2 = new String[]{"20020122122220Z", "20020122222220Z", "20020122022220Z", "20020122122220Z", "20020122122200Z", "20020122222200Z", "20020122022200Z", "20020122122200Z", "19550122122220Z", "19550122122200Z"};

    public String getName() {
        return "UTCTime";
    }

    public void performTest() throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        simpleDateFormat2.setTimeZone(new SimpleTimeZone(0, "Z"));
        for (int i = 0; i != this.input.length; ++i) {
            DERUTCTime dERUTCTime = new DERUTCTime(this.input[i]);
            if (!dERUTCTime.getAdjustedTime().equals(this.output[i])) {
                this.fail("failed conversion test " + i);
            }
            if (!simpleDateFormat.format(dERUTCTime.getAdjustedDate()).equals(this.zOutput1[i])) {
                this.fail("failed date conversion test " + i);
            }
            if (simpleDateFormat2.format(dERUTCTime.getDate()).equals(this.zOutput2[i])) continue;
            this.fail("failed date shortened conversion test " + i);
        }
    }

    public static void main(String[] stringArray) {
        UTCTimeTest.runTest(new UTCTimeTest());
    }
}

