/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Extensions;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class X509ExtensionsTest
extends SimpleTest {
    private static final DERObjectIdentifier OID_2 = new DERObjectIdentifier("1.2.2");
    private static final DERObjectIdentifier OID_3 = new DERObjectIdentifier("1.2.3");
    private static final DERObjectIdentifier OID_1 = new DERObjectIdentifier("1.2.1");

    public String getName() {
        return "X509Extensions";
    }

    public void performTest() throws Exception {
        block9: {
            X509ExtensionsGenerator x509ExtensionsGenerator = new X509ExtensionsGenerator();
            x509ExtensionsGenerator.addExtension(OID_1, true, new byte[20]);
            x509ExtensionsGenerator.addExtension(OID_2, true, new byte[20]);
            X509Extensions x509Extensions = x509ExtensionsGenerator.generate();
            X509Extensions x509Extensions2 = x509ExtensionsGenerator.generate();
            if (!x509Extensions.equals(x509Extensions2)) {
                this.fail("equals test failed");
            }
            x509ExtensionsGenerator.reset();
            x509ExtensionsGenerator.addExtension(OID_2, true, new byte[20]);
            x509ExtensionsGenerator.addExtension(OID_1, true, new byte[20]);
            x509Extensions2 = x509ExtensionsGenerator.generate();
            if (x509Extensions.equals(x509Extensions2)) {
                this.fail("inequality test failed");
            }
            if (!x509Extensions.equivalent(x509Extensions2)) {
                this.fail("equivalence true failed");
            }
            x509ExtensionsGenerator.reset();
            x509ExtensionsGenerator.addExtension(OID_1, true, new byte[22]);
            x509ExtensionsGenerator.addExtension(OID_2, true, new byte[20]);
            x509Extensions2 = x509ExtensionsGenerator.generate();
            if (x509Extensions.equals(x509Extensions2)) {
                this.fail("inequality 1 failed");
            }
            if (x509Extensions.equivalent(x509Extensions2)) {
                this.fail("non-equivalence 1 failed");
            }
            x509ExtensionsGenerator.reset();
            x509ExtensionsGenerator.addExtension(OID_3, true, new byte[20]);
            x509ExtensionsGenerator.addExtension(OID_2, true, new byte[20]);
            x509Extensions2 = x509ExtensionsGenerator.generate();
            if (x509Extensions.equals(x509Extensions2)) {
                this.fail("inequality 2 failed");
            }
            if (x509Extensions.equivalent(x509Extensions2)) {
                this.fail("non-equivalence 2 failed");
            }
            try {
                x509ExtensionsGenerator.addExtension(OID_2, true, new byte[20]);
                this.fail("repeated oid");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getMessage().equals("extension 1.2.2 already added")) break block9;
                this.fail("wrong exception on repeated oid: " + illegalArgumentException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        X509ExtensionsTest.runTest(new X509ExtensionsTest());
    }
}

