/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.x509.qualified;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Choice;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.DEREncodable;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERPrintableString;

public class Iso4217CurrencyCode
extends ASN1Encodable
implements ASN1Choice {
    final int ALPHABETIC_MAXSIZE = 3;
    final int NUMERIC_MINSIZE = 1;
    final int NUMERIC_MAXSIZE = 999;
    DEREncodable obj;
    int numeric;

    public static Iso4217CurrencyCode getInstance(Object object) {
        if (object == null || object instanceof Iso4217CurrencyCode) {
            return (Iso4217CurrencyCode)object;
        }
        if (object instanceof DERInteger) {
            DERInteger dERInteger = DERInteger.getInstance(object);
            int n = dERInteger.getValue().intValue();
            return new Iso4217CurrencyCode(n);
        }
        if (object instanceof DERPrintableString) {
            DERPrintableString dERPrintableString = DERPrintableString.getInstance(object);
            return new Iso4217CurrencyCode(dERPrintableString.getString());
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public Iso4217CurrencyCode(int n) {
        if (n > 999 || n < 1) {
            throw new IllegalArgumentException("wrong size in numeric code : not in (1..999)");
        }
        this.obj = new DERInteger(n);
    }

    public Iso4217CurrencyCode(String string) {
        if (string.length() > 3) {
            throw new IllegalArgumentException("wrong size in alphabetic code : max size is 3");
        }
        this.obj = new DERPrintableString(string);
    }

    public boolean isAlphabetic() {
        return this.obj instanceof DERPrintableString;
    }

    public String getAlphabetic() {
        return ((DERPrintableString)this.obj).getString();
    }

    public int getNumeric() {
        return ((DERInteger)this.obj).getValue().intValue();
    }

    public DERObject toASN1Object() {
        return this.obj.getDERObject();
    }
}

