/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.bcpg;

import edu.illinois.ncsa.bouncycastle.bcpg.BCPGInputStream;
import edu.illinois.ncsa.bouncycastle.bcpg.BCPGKey;
import edu.illinois.ncsa.bouncycastle.bcpg.BCPGObject;
import edu.illinois.ncsa.bouncycastle.bcpg.BCPGOutputStream;
import edu.illinois.ncsa.bouncycastle.bcpg.MPInteger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DSASecretBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger x;

    public DSASecretBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        this.x = new MPInteger(bCPGInputStream);
    }

    public DSASecretBCPGKey(BigInteger bigInteger) {
        this.x = new MPInteger(bigInteger);
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            bCPGOutputStream.writeObject(this);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writeObject(this.x);
    }

    public BigInteger getX() {
        return this.x.getValue();
    }
}

