/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.macs;

import edu.illinois.ncsa.bouncycastle.crypto.CipherParameters;
import edu.illinois.ncsa.bouncycastle.crypto.Digest;
import edu.illinois.ncsa.bouncycastle.crypto.Mac;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import java.util.Arrays;

public class SSL3HMac
implements Mac {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    public static final byte[] MD5_pad1 = SSL3HMac.genPad(54, 48);
    public static final byte[] MD5_pad2 = SSL3HMac.genPad(92, 48);
    public static final byte[] SHA_pad1 = SSL3HMac.genPad(54, 40);
    public static final byte[] SHA_pad2 = SSL3HMac.genPad(92, 40);
    private Digest digest;
    private int digestSize;
    private byte[] secret;

    public SSL3HMac(Digest digest) {
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
    }

    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/SSL3HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    public void init(CipherParameters cipherParameters) {
        this.secret = ((KeyParameter)cipherParameters).getKey();
        this.init();
    }

    private void init() {
        this.digest.reset();
        this.digest.update(this.secret, 0, this.secret.length);
        if (this.digestSize == 16) {
            this.digest.update(MD5_pad1, 0, MD5_pad1.length);
        } else {
            this.digest.update(SHA_pad1, 0, SHA_pad1.length);
        }
    }

    public int getMacSize() {
        return this.digestSize;
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.digestSize];
        this.digest.doFinal(byArray2, 0);
        this.digest.update(this.secret, 0, this.secret.length);
        if (this.digestSize == 16) {
            this.digest.update(MD5_pad2, 0, MD5_pad2.length);
        } else {
            this.digest.update(SHA_pad2, 0, SHA_pad2.length);
        }
        this.digest.update(byArray2, 0, byArray2.length);
        int n2 = this.digest.doFinal(byArray, n);
        this.reset();
        return n2;
    }

    public void reset() {
        this.init();
    }

    private static byte[] genPad(int n, int n2) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)n);
        return byArray;
    }
}

