/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.DataLengthException;
import edu.illinois.ncsa.bouncycastle.crypto.InvalidCipherTextException;
import edu.illinois.ncsa.bouncycastle.crypto.engines.AESWrapEngine;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTestResult;
import edu.illinois.ncsa.bouncycastle.util.test.Test;
import edu.illinois.ncsa.bouncycastle.util.test.TestResult;

public class AESWrapTest
implements Test {
    public String getName() {
        return "AESWrap";
    }

    private TestResult wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4;
        AESWrapEngine aESWrapEngine = new AESWrapEngine();
        aESWrapEngine.init(true, new KeyParameter(byArray));
        try {
            byArray4 = aESWrapEngine.wrap(byArray2, 0, byArray2.length);
            if (!Arrays.areEqual(byArray4, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": failed wrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray4)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed wrap test exception " + exception.toString());
        }
        aESWrapEngine.init(false, new KeyParameter(byArray));
        try {
            byArray4 = aESWrapEngine.unwrap(byArray3, 0, byArray3.length);
            if (!Arrays.areEqual(byArray4, byArray2)) {
                return new SimpleTestResult(false, this.getName() + ": failed unwrap test " + n + " expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray4)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed unwrap test exception.", exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        byte[] byArray7;
        byte[] byArray8;
        byte[] byArray9;
        byte[] byArray10;
        byte[] byArray11;
        byte[] byArray12;
        byte[] byArray13 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        TestResult testResult = this.wrapTest(1, byArray13, byArray12 = Hex.decode("00112233445566778899aabbccddeeff"), byArray11 = Hex.decode("1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray14 = Hex.decode("000102030405060708090a0b0c0d0e0f1011121314151617");
        testResult = this.wrapTest(2, byArray14, byArray10 = Hex.decode("00112233445566778899aabbccddeeff"), byArray9 = Hex.decode("96778b25ae6ca435f92b5b97c050aed2468ab8a17ad84e5d"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray15 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        testResult = this.wrapTest(3, byArray15, byArray8 = Hex.decode("00112233445566778899aabbccddeeff"), byArray7 = Hex.decode("64e8c3f9ce0f5ba263e9777905818a2a93c8191e7d6e8ae7"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray16 = Hex.decode("000102030405060708090a0b0c0d0e0f1011121314151617");
        testResult = this.wrapTest(4, byArray16, byArray6 = Hex.decode("00112233445566778899aabbccddeeff0001020304050607"), byArray5 = Hex.decode("031d33264e15d33268f24ec260743edce1c6c7ddee725a936ba814915c6762d2"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray17 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        testResult = this.wrapTest(5, byArray17, byArray4 = Hex.decode("00112233445566778899aabbccddeeff0001020304050607"), byArray3 = Hex.decode("a8f9bc1612c68b3ff6e6f4fbe30e71e4769c8b80a32cb8958cd5d17d6b254da1"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray18 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        testResult = this.wrapTest(6, byArray18, byArray2 = Hex.decode("00112233445566778899aabbccddeeff000102030405060708090a0b0c0d0e0f"), byArray = Hex.decode("28c9f404c4b810f4cbccb35cfb87f8263f5786e2d80ed326cbc7f0e71a99f43bfb988b9b7a02dd21"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        AESWrapEngine aESWrapEngine = new AESWrapEngine();
        KeyParameter keyParameter = new KeyParameter(new byte[16]);
        byte[] byArray19 = new byte[16];
        try {
            aESWrapEngine.init(true, keyParameter);
            aESWrapEngine.unwrap(byArray19, 0, byArray19.length);
            return new SimpleTestResult(false, this.getName() + ": failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            return new SimpleTestResult(false, this.getName() + ": unexpected exception: " + invalidCipherTextException, invalidCipherTextException);
        }
        try {
            aESWrapEngine.init(false, keyParameter);
            aESWrapEngine.wrap(byArray19, 0, byArray19.length);
            return new SimpleTestResult(false, this.getName() + ": failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
            try {
                aESWrapEngine.init(false, keyParameter);
                aESWrapEngine.unwrap(byArray19, 0, byArray19.length / 2);
                return new SimpleTestResult(false, this.getName() + ": failed unwrap short test.");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                try {
                    aESWrapEngine.init(true, keyParameter);
                    aESWrapEngine.wrap(byArray19, 0, 15);
                    return new SimpleTestResult(false, this.getName() + ": failed wrap length test.");
                }
                catch (DataLengthException dataLengthException) {
                    return new SimpleTestResult(true, this.getName() + ": Okay");
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        AESWrapTest aESWrapTest = new AESWrapTest();
        TestResult testResult = aESWrapTest.perform();
        System.out.println(testResult);
    }
}

