/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.CipherParameters;
import edu.illinois.ncsa.bouncycastle.crypto.StreamCipher;
import edu.illinois.ncsa.bouncycastle.crypto.engines.HC128Engine;
import edu.illinois.ncsa.bouncycastle.crypto.engines.HC256Engine;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithIV;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class HCFamilyVecTest
extends SimpleTest {
    private static final String TEST_DATA_HOME = "bc.test.data.home";

    public String getName() {
        return "HC-128 and HC-256";
    }

    public void performTest() throws Exception {
        this.runTests(new HC128Engine(), "hc-128/ecrypt_HC-128.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_128K_128IV.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_256K_128IV.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_128K_256IV.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_256K_256IV.txt");
    }

    private void runTests(StreamCipher streamCipher, String string) throws IOException {
        FileReader fileReader = new FileReader(HCFamilyVecTest.getDataHome() + "/" + string);
        PeekableLineReader peekableLineReader = new PeekableLineReader(fileReader);
        this.runAllVectors(streamCipher, string, peekableLineReader);
    }

    private void runAllVectors(StreamCipher streamCipher, String string, PeekableLineReader peekableLineReader) throws IOException {
        String string2;
        while ((string2 = peekableLineReader.readLine()) != null) {
            if (!(string2 = string2.trim()).startsWith("Set ")) continue;
            this.runVector(streamCipher, string, peekableLineReader, this.dellChar(string2, ':'));
        }
    }

    private String dellChar(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i != string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private void runVector(StreamCipher streamCipher, String string, PeekableLineReader peekableLineReader, String string2) throws IOException {
        String string3 = HCFamilyVecTest.readBlock(peekableLineReader);
        String string4 = HCFamilyVecTest.readBlock(peekableLineReader);
        CipherParameters cipherParameters = new KeyParameter(Hex.decode(string3));
        cipherParameters = new ParametersWithIV(cipherParameters, Hex.decode(string4));
        streamCipher.init(true, cipherParameters);
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        byte[] byArray3 = new byte[64];
        int n = 0;
        while (true) {
            String string5 = peekableLineReader.peekLine().trim();
            int n2 = string5.indexOf(61);
            String string6 = string5.substring(0, n2 - 1);
            String string7 = HCFamilyVecTest.readBlock(peekableLineReader);
            byte[] byArray4 = Hex.decode(string7);
            if (string6.equals("xor-digest")) {
                if (Arrays.areEqual(byArray4, byArray3)) break;
                this.fail("Failed in " + string + " for test vector: " + string2 + " at " + string6);
                break;
            }
            int n3 = string6.indexOf(91);
            int n4 = string6.indexOf("..");
            int n5 = string6.indexOf(93);
            int n6 = Integer.parseInt(string6.substring(n3 + 1, n4));
            int n7 = Integer.parseInt(string6.substring(n4 + 2, n5));
            if (n6 % 64 != 0 || n7 - n6 != 63) {
                throw new IllegalStateException(string2 + ": " + string6 + " not on 64 byte boundaries");
            }
            while (n < n7) {
                streamCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
                HCFamilyVecTest.xor(byArray3, byArray2);
                n += 64;
            }
            if (Arrays.areEqual(byArray4, byArray2)) continue;
            this.fail("Failed in " + string + " for test vector: " + string2 + " at " + string6);
        }
    }

    private static String readBlock(PeekableLineReader peekableLineReader) throws IOException {
        String string;
        String string2 = peekableLineReader.readLine().trim();
        String string3 = string2.substring(string2.lastIndexOf(32) + 1);
        while ((string = peekableLineReader.peekLine().trim()).length() >= 1 && string.indexOf(61) < 0) {
            string3 = string3 + peekableLineReader.readLine().trim();
        }
        return string3;
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    private static String getDataHome() {
        String string = System.getProperty(TEST_DATA_HOME);
        if (string == null) {
            throw new IllegalStateException("bc.test.data.home property not set");
        }
        return string + "/hc-256";
    }

    public static void main(String[] stringArray) {
        HCFamilyVecTest.runTest(new HCFamilyVecTest());
    }

    private static class PeekableLineReader
    extends BufferedReader {
        private String peek = super.readLine();

        public PeekableLineReader(Reader reader) throws IOException {
            super(reader);
        }

        public String peekLine() {
            return this.peek;
        }

        public String readLine() throws IOException {
            String string = this.peek;
            this.peek = super.readLine();
            return string;
        }
    }
}

