/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.BlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.Mac;
import edu.illinois.ncsa.bouncycastle.crypto.engines.DESEngine;
import edu.illinois.ncsa.bouncycastle.crypto.macs.CBCBlockCipherMac;
import edu.illinois.ncsa.bouncycastle.crypto.macs.CFBBlockCipherMac;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.PKCS7Padding;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithIV;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode("0123456789abcdef");
    static byte[] ivBytes = Hex.decode("1234567890abcdef");
    static byte[] input1 = Hex.decode("37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode("f1d30f68");
    static byte[] output2 = Hex.decode("58d2e77e");
    static byte[] output3 = Hex.decode("cd647403");
    static byte[] input2 = Hex.decode("3736353433323120");
    static byte[] output4 = Hex.decode("3af549c9");
    static byte[] output5 = Hex.decode("188fbdd5");
    static byte[] output6 = Hex.decode("7045eecd");

    public void performTest() {
        KeyParameter keyParameter = new KeyParameter(keyBytes);
        DESEngine dESEngine = new DESEngine();
        Mac mac = new CBCBlockCipherMac(dESEngine);
        mac.init(keyParameter);
        mac.update(input1, 0, input1.length);
        byte[] byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(byArray)));
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, ivBytes);
        mac.init(parametersWithIV);
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output2)) {
            this.fail("Failed - expected " + new String(Hex.encode(output2)) + " got " + new String(Hex.encode(byArray)));
        }
        parametersWithIV = new ParametersWithIV(keyParameter, ivBytes);
        mac = new CFBBlockCipherMac(dESEngine);
        mac.init(parametersWithIV);
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output3)) {
            this.fail("Failed - expected " + new String(Hex.encode(output3)) + " got " + new String(Hex.encode(byArray)));
        }
        mac.init(keyParameter);
        mac.update(input2, 0, input2.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output4)) {
            this.fail("Failed - expected " + new String(Hex.encode(output4)) + " got " + new String(Hex.encode(byArray)));
        }
        mac = new CBCBlockCipherMac((BlockCipher)dESEngine, new PKCS7Padding());
        mac.init(keyParameter);
        mac.update(input2, 0, input2.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output5)) {
            this.fail("Failed - expected " + new String(Hex.encode(output5)) + " got " + new String(Hex.encode(byArray)));
        }
        mac.reset();
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output6)) {
            this.fail("Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(byArray)));
        }
        mac.init(keyParameter);
        mac.update(input1, 0, input1.length);
        byArray = new byte[4];
        mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output6)) {
            this.fail("Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(byArray)));
        }
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] stringArray) {
        MacTest.runTest(new MacTest());
    }
}

