/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.InvalidCipherTextException;
import edu.illinois.ncsa.bouncycastle.crypto.engines.DESEngine;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.BlockCipherPadding;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.ISO10126d2Padding;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.ISO7816d4Padding;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.PKCS7Padding;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.TBCPadding;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.X923Padding;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.ZeroBytePadding;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.security.SecureRandom;

public class PaddingTest
extends SimpleTest {
    private void blockCheck(PaddedBufferedBlockCipher paddedBufferedBlockCipher, BlockCipherPadding blockCipherPadding, KeyParameter keyParameter, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 8];
        byte[] byArray3 = new byte[byArray.length];
        try {
            paddedBufferedBlockCipher.init(true, keyParameter);
            int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray2, n);
            paddedBufferedBlockCipher.init(false, keyParameter);
            int n2 = paddedBufferedBlockCipher.processBytes(byArray2, 0, n, byArray3, 0);
            n2 += paddedBufferedBlockCipher.doFinal(byArray3, n2);
            if (!this.areEqual(byArray, byArray3)) {
                this.fail("failed to decrypt - i = " + byArray.length + ", padding = " + blockCipherPadding.getPaddingName());
            }
        }
        catch (Exception exception) {
            this.fail("Exception - " + exception.toString(), exception);
        }
    }

    public void testPadding(BlockCipherPadding blockCipherPadding, SecureRandom secureRandom, byte[] byArray, byte[] byArray2) {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new DESEngine(), blockCipherPadding);
        KeyParameter keyParameter = new KeyParameter(Hex.decode("0011223344556677"));
        byte[] byArray3 = new byte[]{-1, -1, -1, 0, 0, 0, 0, 0};
        if (byArray != null) {
            blockCipherPadding.addPadding(byArray3, 3);
            if (!this.areEqual(byArray3, byArray)) {
                this.fail("failed ff test for " + blockCipherPadding.getPaddingName());
            }
        }
        if (byArray2 != null) {
            byArray3 = new byte[8];
            blockCipherPadding.addPadding(byArray3, 4);
            if (!this.areEqual(byArray3, byArray2)) {
                this.fail("failed zero test for " + blockCipherPadding.getPaddingName());
            }
        }
        for (int i = 1; i != 200; ++i) {
            byArray3 = new byte[i];
            secureRandom.nextBytes(byArray3);
            this.blockCheck(paddedBufferedBlockCipher, blockCipherPadding, keyParameter, byArray3);
        }
    }

    public void performTest() {
        SecureRandom secureRandom;
        block2: {
            secureRandom = new SecureRandom(new byte[20]);
            secureRandom.setSeed(System.currentTimeMillis());
            this.testPadding(new PKCS7Padding(), secureRandom, Hex.decode("ffffff0505050505"), Hex.decode("0000000004040404"));
            PKCS7Padding pKCS7Padding = new PKCS7Padding();
            try {
                pKCS7Padding.padCount(new byte[8]);
                this.fail("invalid padding not detected");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if ("pad block corrupted".equals(invalidCipherTextException.getMessage())) break block2;
                this.fail("wrong exception for corrupt padding: " + invalidCipherTextException);
            }
        }
        this.testPadding(new ISO10126d2Padding(), secureRandom, null, null);
        this.testPadding(new X923Padding(), secureRandom, null, null);
        this.testPadding(new TBCPadding(), secureRandom, Hex.decode("ffffff0000000000"), Hex.decode("00000000ffffffff"));
        this.testPadding(new ZeroBytePadding(), secureRandom, Hex.decode("ffffff0000000000"), null);
        this.testPadding(new ISO7816d4Padding(), secureRandom, Hex.decode("ffffff8000000000"), Hex.decode("0000000080000000"));
    }

    public String getName() {
        return "PaddingTest";
    }

    public static void main(String[] stringArray) {
        PaddingTest.runTest(new PaddingTest());
    }
}

