/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.BlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.InvalidCipherTextException;
import edu.illinois.ncsa.bouncycastle.crypto.Wrapper;
import edu.illinois.ncsa.bouncycastle.crypto.engines.DESEngine;
import edu.illinois.ncsa.bouncycastle.crypto.engines.DESedeEngine;
import edu.illinois.ncsa.bouncycastle.crypto.engines.RFC3211WrapEngine;
import edu.illinois.ncsa.bouncycastle.crypto.modes.CBCBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithIV;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithRandom;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.security.SecureRandom;

public class RFC3211WrapTest
extends SimpleTest {
    SecureRandom r1 = new SecureRandom(){
        int[] ints = new int[]{196, 54, 245, 65};
        int count = 0;

        public int nextInt() {
            return this.ints[this.count++];
        }
    };
    SecureRandom r2 = new SecureRandom(){
        int[] ints = new int[]{250, 6, 10, 69};
        int count = 0;

        public int nextInt() {
            return this.ints[this.count++];
        }
    };

    public String getName() {
        return "RFC3211Wrap";
    }

    private void wrapTest(int n, BlockCipher blockCipher, byte[] byArray, byte[] byArray2, SecureRandom secureRandom, byte[] byArray3, byte[] byArray4) throws Exception {
        RFC3211WrapEngine rFC3211WrapEngine = new RFC3211WrapEngine(blockCipher);
        rFC3211WrapEngine.init(true, new ParametersWithRandom(new ParametersWithIV(new KeyParameter(byArray), byArray2), secureRandom));
        byte[] byArray5 = rFC3211WrapEngine.wrap(byArray3, 0, byArray3.length);
        if (!Arrays.areEqual(byArray5, byArray4)) {
            this.fail("failed wrap test " + n + " expected " + new String(Hex.encode(byArray4)) + " got " + new String(Hex.encode(byArray5)));
        }
        rFC3211WrapEngine.init(false, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        byte[] byArray6 = rFC3211WrapEngine.unwrap(byArray4, 0, byArray4.length);
        if (!Arrays.areEqual(byArray6, byArray3)) {
            this.fail("rfailed unwrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray6)));
        }
    }

    private void testCorruption() throws InvalidCipherTextException {
        byte[] byArray;
        RFC3211WrapEngine rFC3211WrapEngine;
        byte[] byArray2;
        byte[] byArray3;
        block2: {
            byArray3 = Hex.decode("D1DAA78615F287E6");
            byArray2 = Hex.decode("EFE598EF21B33D6D");
            rFC3211WrapEngine = new RFC3211WrapEngine(new DESEngine());
            rFC3211WrapEngine.init(false, new ParametersWithIV(new KeyParameter(byArray3), byArray2));
            byArray = Hex.decode("ff739D838C627C897323A2F8C436F541");
            this.encryptBlock(byArray3, byArray2, byArray);
            try {
                rFC3211WrapEngine.unwrap(byArray, 0, byArray.length);
                this.fail("bad length not detected");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (invalidCipherTextException.getMessage().equals("wrapped key corrupted")) break block2;
                this.fail("wrong exception on length");
            }
        }
        byArray = Hex.decode("08639D838C627C897323A2F8C436F541");
        this.testChecksum(byArray3, byArray2, byArray, rFC3211WrapEngine);
        byArray = Hex.decode("08736D838C627C897323A2F8C436F541");
        this.testChecksum(byArray3, byArray2, byArray, rFC3211WrapEngine);
        byArray = Hex.decode("08739D638C627C897323A2F8C436F541");
        this.testChecksum(byArray3, byArray2, byArray, rFC3211WrapEngine);
    }

    private void testChecksum(byte[] byArray, byte[] byArray2, byte[] byArray3, Wrapper wrapper) {
        block2: {
            this.encryptBlock(byArray, byArray2, byArray3);
            try {
                wrapper.unwrap(byArray3, 0, byArray3.length);
                this.fail("bad checksum not detected");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (invalidCipherTextException.getMessage().equals("wrapped key fails checksum")) break block2;
                this.fail("wrong exception");
            }
        }
    }

    private void encryptBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        CBCBlockCipher cBCBlockCipher = new CBCBlockCipher(new DESEngine());
        cBCBlockCipher.init(true, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        for (n = 0; n < byArray3.length; n += 8) {
            cBCBlockCipher.processBlock(byArray3, n, byArray3, n);
        }
        for (n = 0; n < byArray3.length; n += 8) {
            cBCBlockCipher.processBlock(byArray3, n, byArray3, n);
        }
    }

    public void performTest() throws Exception {
        this.wrapTest(1, new DESEngine(), Hex.decode("D1DAA78615F287E6"), Hex.decode("EFE598EF21B33D6D"), this.r1, Hex.decode("8C627C897323A2F8"), Hex.decode("B81B2565EE373CA6DEDCA26A178B0C10"));
        this.wrapTest(2, new DESedeEngine(), Hex.decode("6A8970BF68C92CAEA84A8DF28510858607126380CC47AB2D"), Hex.decode("BAF1CA7931213C4E"), this.r2, Hex.decode("8C637D887223A2F965B566EB014B0FA5D52300A3F7EA40FFFC577203C71BAF3B"), Hex.decode("C03C514ABDB9E2C5AAC038572B5E24553876B377AAFB82ECA5A9D73F8AB143D9EC74E6CAD7DB260C"));
        this.testCorruption();
        RFC3211WrapEngine rFC3211WrapEngine = new RFC3211WrapEngine(new DESEngine());
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]);
        byte[] byArray = new byte[16];
        try {
            rFC3211WrapEngine.init(true, parametersWithIV);
            rFC3211WrapEngine.unwrap(byArray, 0, byArray.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("unexpected exception: " + invalidCipherTextException, invalidCipherTextException);
        }
        try {
            rFC3211WrapEngine.init(false, parametersWithIV);
            rFC3211WrapEngine.wrap(byArray, 0, byArray.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            rFC3211WrapEngine.init(false, parametersWithIV);
            rFC3211WrapEngine.unwrap(byArray, 0, byArray.length / 2);
            this.fail("failed unwrap short test.");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        RFC3211WrapTest.runTest(new RFC3211WrapTest());
    }
}

