/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA1Digest;
import edu.illinois.ncsa.bouncycastle.crypto.params.RSAKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.signers.RSADigestSigner;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;

public class RSADigestSignerTest
extends SimpleTest {
    public String getName() {
        return "RSADigestSigner";
    }

    public void performTest() throws Exception {
        BigInteger bigInteger = new BigInteger(Base64.decode("AIASoe2PQb1IP7bTyC9usjHP7FvnUMVpKW49iuFtrw/dMpYlsMMoIU2jupfifDpdFxIktSB4P+6Ymg5WjvHKTIrvQ7SR4zV4jaPTu56Ys0pZ9EDA6gb3HLjtU+8Bb1mfWM+yjKxcPDuFjwEtjGlPHg1Vq+CA9HNcMSKNn2+tW6qt"));
        BigInteger bigInteger2 = new BigInteger(Base64.decode("EQ=="));
        BigInteger bigInteger3 = new BigInteger(Base64.decode("AIASoe2PQb1IP7bTyC9usjHP7FvnUMVpKW49iuFtrw/dMpYlsMMoIU2jupfifDpdFxIktSB4P+6Ymg5WjvHKTIrvQ7SR4zV4jaPTu56Ys0pZ9EDA6gb3HLjtU+8Bb1mfWM+yjKxcPDuFjwEtjGlPHg1Vq+CA9HNcMSKNn2+tW6qt"));
        BigInteger bigInteger4 = new BigInteger(Base64.decode("JXzfzG5v+HtLJIZqYMUefJfFLu8DPuJGaLD6lI3cZ0babWZ/oPGoJa5iHpX4Ul/7l3s1PFsuy1GhzCdOdlfRcQ=="));
        BigInteger bigInteger5 = new BigInteger(Base64.decode("YNdJhw3cn0gBoVmMIFRZzflPDNthBiWy/dUMSRfJCxoZjSnr1gysZHK01HteV1YYNGcwPdr3j4FbOfri5c6DUQ=="));
        BigInteger bigInteger6 = new BigInteger(Base64.decode("DxFAOhDajr00rBjqX+7nyZ/9sHWRCCp9WEN5wCsFiWVRPtdB+NeLcou7mWXwf1Y+8xNgmmh//fPV45G2dsyBeZbXeJwB7bzx9NMEAfedchyOwjR8PYdjK3NpTLKtZlEJ6Jkh4QihrXpZMO4fKZWUm9bid3+lmiq43FwW+Hof8/E="));
        BigInteger bigInteger7 = new BigInteger(Base64.decode("AJ9StyTVW+AL/1s7RBtFwZGFBgd3zctBqzzwKPda6LbtIFDznmwDCqAlIQH9X14X7UPLokCDhuAa76OnDXb1OiE="));
        BigInteger bigInteger8 = new BigInteger(Base64.decode("AM3JfD79dNJ5A3beScSzPtWxx/tSLi0QHFtkuhtSizeXdkv5FSba7lVzwEOGKHmW829bRoNxThDy4ds1IihW1w0="));
        BigInteger bigInteger9 = new BigInteger(Base64.decode("Lt0g7wrsNsQxuDdB8q/rH8fSFeBXMGLtCIqfOec1j7FEIuYA/ACiRDgXkHa0WgN7nLXSjHoy630wC5Toq8vvUg=="));
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, bigInteger, bigInteger2);
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(bigInteger3, bigInteger2, bigInteger6, bigInteger7, bigInteger8, bigInteger4, bigInteger5, bigInteger9);
        byte[] byArray = new byte[]{1, 6, 3, 32, 7, 43, 2, 5, 7, 78, 4, 23};
        RSADigestSigner rSADigestSigner = new RSADigestSigner(new SHA1Digest());
        rSADigestSigner.init(true, rSAPrivateCrtKeyParameters);
        rSADigestSigner.update(byArray, 0, byArray.length);
        byte[] byArray2 = rSADigestSigner.generateSignature();
        rSADigestSigner.init(false, rSAKeyParameters);
        rSADigestSigner.update(byArray, 0, byArray.length);
        if (!rSADigestSigner.verifySignature(byArray2)) {
            this.fail("RSA IDigest Signer failed.");
        }
    }

    public static void main(String[] stringArray) {
        RSADigestSignerTest.runTest(new RSADigestSignerTest());
    }
}

