/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.CryptoException;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.srp.SRP6Client;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.srp.SRP6Server;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.srp.SRP6Util;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA1Digest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA256Digest;
import edu.illinois.ncsa.bouncycastle.crypto.generators.DHParametersGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHParameters;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Test
extends SimpleTest {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger N_1024 = SRP6Test.fromHex("EEAF0AB9ADB38DD69C33F80AFA8FC5E86072618775FF3C0B9EA2314C9C256576D674DF7496EA81D3383B4813D692C6E0E0D5D8E250B98BE48E495C1D6089DAD15DC7D7B46154D6B6CE8EF4AD69B15D4982559B297BCF1885C529F566660E57EC68EDBC3C05726CC02FD4CBF4976EAA9AFD5138FE8376435B9FC61D2FC0EB06E3");
    private static final BigInteger g_1024 = BigInteger.valueOf(2L);
    private final SecureRandom random = new SecureRandom();

    private static BigInteger fromHex(String string) {
        return new BigInteger(1, Hex.decode(string));
    }

    public String getName() {
        return "SRP6";
    }

    public void performTest() throws Exception {
        this.rfc5054AppendixBTestVectors();
        this.testMutualVerification(N_1024, g_1024);
        this.testClientCatchesBadB(N_1024, g_1024);
        this.testServerCatchesBadA(N_1024, g_1024);
        this.testWithRandomParams(256);
        this.testWithRandomParams(384);
        this.testWithRandomParams(512);
    }

    private void rfc5054AppendixBTestVectors() throws Exception {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        byte[] byArray = "alice".getBytes("UTF8");
        byte[] byArray2 = "password123".getBytes("UTF8");
        byte[] byArray3 = Hex.decode("BEB25379D1A8581EB5A727673A2441EE");
        BigInteger bigInteger5 = N_1024;
        BigInteger bigInteger6 = g_1024;
        BigInteger bigInteger7 = SRP6Test.fromHex("60975527035CF2AD1989806F0407210BC81EDC04E2762A56AFD529DDDA2D4393");
        BigInteger bigInteger8 = SRP6Test.fromHex("E487CB59D31AC550471E81F00F6928E01DDA08E974A004F49E61F5D105284D20");
        BigInteger bigInteger9 = SRP6Test.fromHex("7556AA045AEF2CDD07ABAF0F665C3E818913186F");
        BigInteger bigInteger10 = SRP6Test.fromHex("94B7555AABE9127CC58CCF4993DB6CF84D16C124");
        BigInteger bigInteger11 = SRP6Test.fromHex("7E273DE8696FFC4F4E337D05B4B375BEB0DDE1569E8FA00A9886D8129BADA1F1822223CA1A605B530E379BA4729FDC59F105B4787E5186F5C671085A1447B52A48CF1970B4FB6F8400BBF4CEBFBB168152E08AB5EA53D15C1AFF87B2B9DA6E04E058AD51CC72BFC9033B564E26480D78E955A5E29E7AB245DB2BE315E2099AFB");
        BigInteger bigInteger12 = SRP6Test.fromHex("61D5E490F6F1B79547B0704C436F523DD0E560F0C64115BB72557EC44352E8903211C04692272D8B2D1A5358A2CF1B6E0BFCF99F921530EC8E39356179EAE45E42BA92AEACED825171E1E8B9AF6D9C03E1327F44BE087EF06530E69F66615261EEF54073CA11CF5858F0EDFDFE15EFEAB349EF5D76988A3672FAC47B0769447B");
        BigInteger bigInteger13 = SRP6Test.fromHex("BD0C61512C692C0CB6D041FA01BB152D4916A1E77AF46AE105393011BAF38964DC46A0670DD125B95A981652236F99D9B681CBF87837EC996C6DA04453728610D0C6DDB58B318885D7D82C7F8DEB75CE7BD4FBAA37089E6F9C6059F388838E7A00030B331EB76840910440B1B27AAEAEEB4012B7D7665238A8E3FB004B117B58");
        BigInteger bigInteger14 = SRP6Test.fromHex("CE38B9593487DA98554ED47D70A7AE5F462EF019");
        BigInteger bigInteger15 = SRP6Test.fromHex("B0DC82BABCF30674AE450C0287745E7990A3381F63B387AAF271A10D233861E359B48220F7C4693C9AE12B0A6F67809F0876E2D013800D6C41BB59B6D5979B5C00A172B4A2A5903A0BDCAF8A709585EB2AFAFA8F3499B200210DCC1F10EB33943CD67FC88A2F39A4BE5BEC4EC0A3212DC346D7E474B29EDE8A469FFECA686E5A");
        BigInteger bigInteger16 = SRP6Util.calculateK(new SHA1Digest(), bigInteger5, bigInteger6);
        if (!bigInteger16.equals(bigInteger9)) {
            this.fail("wrong value of 'k'");
        }
        if (!(bigInteger4 = SRP6Util.calculateX(new SHA1Digest(), bigInteger5, byArray3, byArray, byArray2)).equals(bigInteger10)) {
            this.fail("wrong value of 'x'");
        }
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigInteger5, bigInteger6, new SHA1Digest());
        BigInteger bigInteger17 = sRP6VerifierGenerator.generateVerifier(byArray3, byArray, byArray2);
        if (!bigInteger17.equals(bigInteger11)) {
            this.fail("wrong value of 'v'");
        }
        final BigInteger bigInteger18 = bigInteger7;
        SRP6Client sRP6Client = new SRP6Client(){

            protected BigInteger selectPrivateValue() {
                return bigInteger18;
            }
        };
        sRP6Client.init(bigInteger5, bigInteger6, new SHA1Digest(), this.random);
        BigInteger bigInteger19 = sRP6Client.generateClientCredentials(byArray3, byArray, byArray2);
        if (!bigInteger19.equals(bigInteger12)) {
            this.fail("wrong value of 'A'");
        }
        final BigInteger bigInteger20 = bigInteger8;
        SRP6Server sRP6Server = new SRP6Server(){

            protected BigInteger selectPrivateValue() {
                return bigInteger20;
            }
        };
        sRP6Server.init(bigInteger5, bigInteger6, bigInteger17, new SHA1Digest(), this.random);
        BigInteger bigInteger21 = sRP6Server.generateServerCredentials();
        if (!bigInteger21.equals(bigInteger13)) {
            this.fail("wrong value of 'B'");
        }
        if (!(bigInteger3 = SRP6Util.calculateU(new SHA1Digest(), bigInteger5, bigInteger19, bigInteger21)).equals(bigInteger14)) {
            this.fail("wrong value of 'u'");
        }
        if (!(bigInteger2 = sRP6Client.calculateSecret(bigInteger21)).equals(bigInteger15)) {
            this.fail("wrong value of 'S' (client)");
        }
        if (!(bigInteger = sRP6Server.calculateSecret(bigInteger19)).equals(bigInteger15)) {
            this.fail("wrong value of 'S' (server)");
        }
    }

    private void testWithRandomParams(int n) throws CryptoException {
        DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
        dHParametersGenerator.init(n, 25, this.random);
        DHParameters dHParameters = dHParametersGenerator.generateParameters();
        BigInteger bigInteger = dHParameters.getG();
        BigInteger bigInteger2 = dHParameters.getP();
        this.testMutualVerification(bigInteger2, bigInteger);
    }

    private void testMutualVerification(BigInteger bigInteger, BigInteger bigInteger2) throws CryptoException {
        byte[] byArray = "username".getBytes();
        byte[] byArray2 = "password".getBytes();
        byte[] byArray3 = new byte[16];
        this.random.nextBytes(byArray3);
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigInteger, bigInteger2, new SHA256Digest());
        BigInteger bigInteger3 = sRP6VerifierGenerator.generateVerifier(byArray3, byArray, byArray2);
        SRP6Client sRP6Client = new SRP6Client();
        sRP6Client.init(bigInteger, bigInteger2, new SHA256Digest(), this.random);
        SRP6Server sRP6Server = new SRP6Server();
        sRP6Server.init(bigInteger, bigInteger2, bigInteger3, new SHA256Digest(), this.random);
        BigInteger bigInteger4 = sRP6Client.generateClientCredentials(byArray3, byArray, byArray2);
        BigInteger bigInteger5 = sRP6Server.generateServerCredentials();
        BigInteger bigInteger6 = sRP6Client.calculateSecret(bigInteger5);
        BigInteger bigInteger7 = sRP6Server.calculateSecret(bigInteger4);
        if (!bigInteger6.equals(bigInteger7)) {
            this.fail("SRP agreement failed - client/server calculated different secrets");
        }
    }

    private void testClientCatchesBadB(BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray = "username".getBytes();
        byte[] byArray2 = "password".getBytes();
        byte[] byArray3 = new byte[16];
        this.random.nextBytes(byArray3);
        SRP6Client sRP6Client = new SRP6Client();
        sRP6Client.init(bigInteger, bigInteger2, new SHA256Digest(), this.random);
        sRP6Client.generateClientCredentials(byArray3, byArray, byArray2);
        try {
            sRP6Client.calculateSecret(ZERO);
            this.fail("Client failed to detect invalid value for 'B'");
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
        try {
            sRP6Client.calculateSecret(bigInteger);
            this.fail("Client failed to detect invalid value for 'B'");
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    private void testServerCatchesBadA(BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray = "username".getBytes();
        byte[] byArray2 = "password".getBytes();
        byte[] byArray3 = new byte[16];
        this.random.nextBytes(byArray3);
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigInteger, bigInteger2, new SHA256Digest());
        BigInteger bigInteger3 = sRP6VerifierGenerator.generateVerifier(byArray3, byArray, byArray2);
        SRP6Server sRP6Server = new SRP6Server();
        sRP6Server.init(bigInteger, bigInteger2, bigInteger3, new SHA256Digest(), this.random);
        sRP6Server.generateServerCredentials();
        try {
            sRP6Server.calculateSecret(ZERO);
            this.fail("Client failed to detect invalid value for 'A'");
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
        try {
            sRP6Server.calculateSecret(bigInteger);
            this.fail("Client failed to detect invalid value for 'A'");
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        SRP6Test.runTest(new SRP6Test());
    }
}

