/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.BasicAgreement;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.DHBasicAgreement;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import edu.illinois.ncsa.bouncycastle.crypto.params.AsymmetricKeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.tls.Certificate;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsAgreementCredentials;
import edu.illinois.ncsa.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DefaultTlsAgreementCredentials
implements TlsAgreementCredentials {
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected BasicAgreement basicAgreement;

    public DefaultTlsAgreementCredentials(Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (certificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.clientCert = certificate;
        this.clientPrivateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.clientCert;
    }

    public byte[] generateAgreement(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.basicAgreement.init(this.clientPrivateKey);
        BigInteger bigInteger = this.basicAgreement.calculateAgreement(asymmetricKeyParameter);
        return BigIntegers.asUnsignedByteArray(bigInteger);
    }
}

