/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.util.encoders.test;

import edu.illinois.ncsa.bouncycastle.util.encoders.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;

public abstract class AbstractCoderTest
extends TestCase {
    private static final int[] SIZES_TO_CHECK = new int[]{64, 128, 1024, 1025, 1026, 2048, 2049, 2050, 4096, 4097, 4098, 8192, 8193, 8194};
    protected Encoder enc;
    private Random r;

    AbstractCoderTest(String string) {
        super(string);
    }

    protected void setUp() {
        this.r = new Random();
    }

    private void checkArrayOfSize(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.r.nextBytes(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.encode(byArray, 0, byArray.length, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        AbstractCoderTest.assertTrue((byArray2.length > byArray.length ? 1 : 0) != 0);
        AbstractCoderTest.assertTrue((byArray2.length <= byArray.length * 2 ? 1 : 0) != 0);
        this.checkEncoding(byArray2);
        this.checkSimpleDecode(byArray, byArray2);
        this.checkStringDecode(byArray, byArray2);
        this.checkOutputStreamDecode(byArray, byArray2);
        int n2 = this.r.nextInt(20);
        byte[] byArray3 = new byte[n2 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        this.checkOffsetDecode(byArray, byArray3, n2, byArray2.length);
        n2 = this.r.nextInt(20);
        byte[] byArray4 = new byte[n2 + byArray.length];
        System.arraycopy(byArray, 0, byArray4, n2, byArray.length);
        this.checkOffsetEncode(byArray, byArray4, n2, byArray.length);
        byte[] byArray5 = this.addWhitespace(byArray2);
        this.checkSimpleDecode(byArray, byArray5);
        this.checkStringDecode(byArray, byArray5);
        this.checkOutputStreamDecode(byArray, byArray5);
    }

    public void testEncode() throws IOException {
        for (int i = 0; i < SIZES_TO_CHECK.length; ++i) {
            this.checkArrayOfSize(SIZES_TO_CHECK[i]);
        }
    }

    private void checkEncoding(byte[] byArray) {
        String string = this.convertBytesToString(byArray);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.paddingChar()) {
                AbstractCoderTest.assertTrue((i > string.length() - 3 ? 1 : 0) != 0);
                continue;
            }
            if (this.isEncodedChar(c)) continue;
            AbstractCoderTest.fail((String)("Unexpected encoded character " + c));
        }
    }

    private void checkOutputStreamDecode(byte[] byArray, byte[] byArray2) {
        String string = this.convertBytesToString(byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            AbstractCoderTest.assertEquals((int)byArray.length, (int)this.enc.decode(string, byteArrayOutputStream));
            AbstractCoderTest.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            AbstractCoderTest.fail((String)"This shouldn't happen");
        }
    }

    private void checkSimpleDecode(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.decode(byArray2, 0, byArray2.length, byteArrayOutputStream);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private void checkOffsetEncode(byte[] byArray, byte[] byArray2, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.encode(byArray2, n, n2, byteArrayOutputStream);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        this.enc.decode(byArray3, 0, byArray3.length, byteArrayOutputStream);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private void checkOffsetDecode(byte[] byArray, byte[] byArray2, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.decode(byArray2, n, n2, byteArrayOutputStream);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private void checkStringDecode(byte[] byArray, byte[] byArray2) throws IOException {
        String string = this.convertBytesToString(byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.decode(string, byteArrayOutputStream);
        AbstractCoderTest.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private byte[] addWhitespace(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.addSpace(byteArrayOutputStream);
        for (n = 0; n < byArray.length - 5; ++n) {
            byteArrayOutputStream.write(byArray, n, 1);
            if (this.r.nextInt(100) >= 5) continue;
            this.addSpace(byteArrayOutputStream);
        }
        for (n = byArray.length - 5; n < byArray.length; ++n) {
            byteArrayOutputStream.write(byArray, n, 1);
        }
        this.addSpace(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void addSpace(ByteArrayOutputStream byteArrayOutputStream) {
        do {
            switch (this.r.nextInt(3)) {
                case 0: {
                    byteArrayOutputStream.write(10);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(13);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(9);
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(32);
                }
            }
        } while (this.r.nextBoolean());
    }

    private String convertBytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i != byArray.length; ++i) {
            stringBuffer.append((char)(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    protected abstract char paddingChar();

    protected abstract boolean isEncodedChar(char var1);
}

