/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public class OpensslNamespacePolicyImpl
implements NamespacePolicy {
    private String issuer;
    private String subject;
    private String identification;
    private boolean permit;
    private Pattern pattern;

    public OpensslNamespacePolicyImpl(String issuer, String subject, boolean permit, String identification) throws IOException {
        this.issuer = issuer;
        this.identification = identification;
        this.subject = subject;
        this.permit = permit;
        try {
            this.pattern = Pattern.compile(this.subject, 2);
        }
        catch (Exception e) {
            throw new IOException("Problem parsing the regular expression in " + identification + ". Regular expression >>" + subject + "<< is invalid: " + e.getMessage(), e);
        }
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    public String getSuject() {
        return this.subject;
    }

    @Override
    public boolean isPermit() {
        return this.permit;
    }

    @Override
    public String getIdentification() {
        return this.identification;
    }

    @Override
    public boolean isSubjectMatching(X500Principal subject) {
        String opensslDn = OpensslNameUtils.convertFromRfc2253(subject.getName(), false);
        String normalized = OpensslNameUtils.normalize(opensslDn);
        return this.pattern.matcher(normalized).matches();
    }
}

