/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreferencesHandler {
    static final transient Logger logger;
    static final Properties p;
    static String sPrefsFile;

    public static synchronized void load() {
        FileInputStream is = null;
        try {
            File f = new File(sPrefsFile);
            if (!f.exists()) {
                return;
            }
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "Got exception " + e.getLocalizedMessage(), e);
        }
        try {
            p.load(is);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Got exception " + e.getLocalizedMessage(), e);
        }
    }

    public static synchronized void save() {
        try {
            File f = new File(sPrefsFile);
            try {
                f.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            FileOutputStream fos = new FileOutputStream(f);
            p.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Got exception " + e.getLocalizedMessage(), e);
        }
    }

    public static synchronized String get(String key, String def) {
        return p.getProperty(key, def);
    }

    public static synchronized void put(String key, String value) {
        p.setProperty(key, value);
    }

    public static synchronized boolean getBoolean(String key, boolean def) {
        try {
            return Boolean.valueOf(p.getProperty(key, "" + def));
        }
        catch (Exception e) {
            return def;
        }
    }

    public static synchronized void putBoolean(String key, boolean value) {
        p.setProperty(key, "" + value);
    }

    static {
        File file;
        logger = Logger.getLogger(PreferencesHandler.class.getCanonicalName());
        p = new Properties();
        sPrefsFile = System.getProperty("user.home", ".") + System.getProperty("file.separator") + ".fdt" + System.getProperty("file.separator") + "gui.props";
        try {
            file = new File(System.getProperty("user.home", ".") + System.getProperty("file.separator") + ".fdt");
            file.mkdirs();
        }
        catch (Throwable file2) {
            // empty catch block
        }
        try {
            file = new File(sPrefsFile);
            if (file.createNewFile()) {
                file.delete();
            }
        }
        catch (IOException e) {
            sPrefsFile = System.getProperty("user.home", ".") + System.getProperty("file.separator") + System.getProperty("user.name") + System.getProperty("file.separator") + ".fdt" + System.getProperty("file.separator") + "gui.props";
        }
        System.out.println("Using [" + sPrefsFile + "] as preferences file");
        PreferencesHandler.load();
    }
}

