/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.gui.ClientSessionManager;
import lia.util.net.copy.gui.FDTPropsDialog;
import lia.util.net.copy.gui.FolderTable;
import lia.util.net.copy.gui.GUISSHControlStream;
import lia.util.net.copy.gui.session.Session;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.FDTProcolException;
import lia.util.net.copy.transport.gui.FileHandler;
import lia.util.net.copy.transport.gui.GUIControlChannel;
import lia.util.net.copy.transport.gui.GUIControlChannelNotifier;
import lia.util.net.copy.transport.gui.GUIMessage;

public class RemoteSessionManager
implements GUIControlChannelNotifier,
Runnable {
    private static final Object lock = new Object();
    private static final long timeout = 3000L;
    final ClientSessionManager clientSessionManager = new ClientSessionManager();
    private final FDTPropsDialog props;
    String hostname;
    int port;
    ConnectMonitor connd;
    boolean initiated = false;
    private FolderTable remoteTable;
    private FolderTable localTable;
    private GUIControlChannel channel;
    private String workingDir;
    private boolean canWrite;
    private String userHome;
    private String osName;
    private String freeSpace;
    private String fileSeparator;
    private Vector<FileHandler> fileList;
    private Exception remoteEx = null;
    private String[] roots;
    private boolean isRoot;
    private HashMap<String, String> shortNames;
    private Session localSession;
    private Session remoteSession;
    private JPanel p;
    private RemoteSessionMonitor monitor;
    private RunnableScheduledFuture remoteSessionTask;
    private RunnableScheduledFuture monitorTask;

    public RemoteSessionManager(FDTPropsDialog props, JPanel panel) {
        this.props = props;
        this.p = panel;
    }

    public void setSessions(Session localSession, Session remoteSession) {
        this.localSession = localSession;
        this.remoteSession = remoteSession;
    }

    public String getWorkingDirectory() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileSeparator() {
        Object object = lock;
        synchronized (object) {
            while (!this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        if (this.fileSeparator == null) {
            return System.getProperty("file.separator");
        }
        return this.fileSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWrite() {
        Object object = lock;
        synchronized (object) {
            while (!this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        return this.canWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserHome() {
        Object object = lock;
        synchronized (object) {
            while (!this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        return this.userHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOSName() {
        Object object = lock;
        synchronized (object) {
            while (!this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        return this.osName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String freeSpace() {
        Object object = lock;
        synchronized (object) {
            while (this.fileList == null || !this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        return this.freeSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoot() {
        if (this.channel == null) {
            return false;
        }
        try {
            Object object = lock;
            synchronized (object) {
                while (this.fileList == null || !this.initiated) {
                    try {
                        lock.wait(3000L);
                    }
                    catch (Throwable throwable) {}
                }
            }
            return this.isRoot;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<FileHandler> getFileList() {
        Object object = lock;
        synchronized (object) {
            while (this.fileList == null || !this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        return this.fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFiles(String[] files) throws Exception {
        if (this.channel == null) {
            return;
        }
        this.fileList = null;
        CtrlMsg c = new CtrlMsg(11, new GUIMessage(10, files));
        this.channel.sendCtrlMessage(c);
        Object object = lock;
        synchronized (object) {
            while (this.fileList == null) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        Exception tmpEx = this.remoteEx;
        this.remoteEx = null;
        if (tmpEx != null) {
            throw tmpEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDir(String name) throws Exception {
        if (this.channel == null) {
            return;
        }
        this.fileList = null;
        CtrlMsg c = new CtrlMsg(11, new GUIMessage(11, name));
        this.channel.sendCtrlMessage(c);
        Object object = lock;
        synchronized (object) {
            while (this.fileList == null) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        Exception tmpEx = this.remoteEx;
        this.remoteEx = null;
        if (tmpEx != null) {
            throw tmpEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAbsoluteDir(String dir) throws Exception {
        if (this.channel == null) {
            return;
        }
        this.workingDir = null;
        this.fileList = null;
        CtrlMsg c = new CtrlMsg(11, new GUIMessage(6, dir));
        this.channel.sendCtrlMessage(c);
        Object object = lock;
        synchronized (object) {
            while (this.fileList == null) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        Exception tmpEx = this.remoteEx;
        this.remoteEx = null;
        if (tmpEx != null) {
            throw tmpEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelativeDir(String dir) throws Exception {
        if (this.channel == null) {
            return;
        }
        this.workingDir = null;
        this.fileList = null;
        CtrlMsg c = new CtrlMsg(11, new GUIMessage(7, dir));
        this.channel.sendCtrlMessage(c);
        Object object = lock;
        synchronized (object) {
            while (this.fileList == null) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        Exception tmpEx = this.remoteEx;
        this.remoteEx = null;
        if (tmpEx != null) {
            throw tmpEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpDir() throws Exception {
        if (this.channel == null) {
            return;
        }
        this.workingDir = null;
        this.fileList = null;
        CtrlMsg c = new CtrlMsg(11, new GUIMessage(8, null));
        this.channel.sendCtrlMessage(c);
        Object object = lock;
        synchronized (object) {
            while (this.fileList == null) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        Exception tmpEx = this.remoteEx;
        this.remoteEx = null;
        if (tmpEx != null) {
            throw tmpEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRoots() {
        Object object = lock;
        synchronized (object) {
            while (!this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        if (this.roots == null) {
            this.roots = new String[]{""};
        }
        return this.roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortRootName(String rootFolder) {
        Object object = lock;
        synchronized (object) {
            while (!this.initiated) {
                try {
                    lock.wait(3000L);
                }
                catch (Throwable throwable) {}
            }
        }
        if (rootFolder == null || this.shortNames == null || !this.shortNames.containsKey(rootFolder)) {
            return null;
        }
        return this.shortNames.get(rootFolder);
    }

    public String initiateTransfer(String[] files, boolean push, boolean isRecursive) {
        String destDir = ".";
        if (push) {
            if (!this.remoteSession.canWrite()) {
                return "Can not write to " + this.remoteSession.getWorkingDir();
            }
            destDir = this.remoteSession.getWorkingDir();
        } else {
            if (!this.localSession.canWrite()) {
                return "Can not write to " + this.localSession.getWorkingDir();
            }
            destDir = this.localSession.getWorkingDir();
        }
        return this.clientSessionManager.initTransfer(this.hostname, this.port, !push, files, destDir, this.props, isRecursive);
    }

    public double getTransferPercent() {
        return this.clientSessionManager.transferProgress();
    }

    public String getTransferSpeed() {
        return this.clientSessionManager.currentSpeed();
    }

    public void stopTransfer() {
        this.clientSessionManager.cancelTransfer();
        this.end();
    }

    public void end() {
        this.clientSessionManager.end();
    }

    public void setCorrespondingPanel(FolderTable localTable, FolderTable remoteTable) {
        this.localTable = localTable;
        this.remoteTable = remoteTable;
        if (this.channel != null && remoteTable != null) {
            remoteTable.setConnected(true);
        }
    }

    @Override
    public void run() {
        this.connd.setProgress();
    }

    public void connect(final String hostName, final String user, final int port) {
        if (this.connd == null) {
            this.connd = new ConnectMonitor(this.p);
        }
        this.remoteSessionTask = (RunnableScheduledFuture)Utils.getMonitoringExecService().scheduleWithFixedDelay(this, 1L, 200L, TimeUnit.MILLISECONDS);
        this.connd.setVisible(true);
        final RemoteSessionManager _instance = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean auth = true;
                if (user != null) {
                    try {
                        HashMap<String, Object> confMap = new HashMap<String, Object>();
                        confMap.put("-p", "" + port);
                        confMap.put("SCPSyntaxUsed", Boolean.TRUE);
                        try {
                            Config.initInstance(confMap);
                        }
                        catch (Throwable t1) {
                            t1.printStackTrace();
                        }
                        GUISSHControlStream sshConn = new GUISSHControlStream(hostName, user, RemoteSessionManager.this.connd);
                        sshConn.connect();
                        Config config = Config.getInstance();
                        String localAddresses = config.getLocalAddresses();
                        String remoteCmd = config.getRemoteCommand() + " -p " + config.getPort() + " -silent -S -f " + localAddresses;
                        System.err.println(" [ CONFIG ] Starting FDT server over SSH using [ " + remoteCmd + " ]");
                        sshConn.startProgram(remoteCmd);
                        sshConn.waitForControlMessage("READY");
                        System.err.println(" [ CONFIG ] FDT server successfully started on [ " + config.getHostName() + " ]");
                        auth = true;
                    }
                    catch (Throwable t) {
                        RemoteSessionManager.this.channel = null;
                        RemoteSessionManager.this.initiated = true;
                        auth = false;
                    }
                }
                if (auth) {
                    try {
                        if (RemoteSessionManager.this.channel != null) {
                            RemoteSessionManager.this.channel.close("New connection", null);
                        }
                        RemoteSessionManager.this.channel = new GUIControlChannel(hostName, port, (GUIControlChannelNotifier)_instance);
                        new Thread((Runnable)RemoteSessionManager.this.channel, "GUI Control channel for [ " + hostName + ":" + port + " ]").start();
                        if (RemoteSessionManager.this.remoteTable != null) {
                            RemoteSessionManager.this.remoteTable.setConnected(true);
                        }
                        _instance.hostname = hostName;
                        _instance.port = port;
                        Utils.getMonitoringExecService().remove(RemoteSessionManager.this.remoteSessionTask);
                        Utils.getMonitoringExecService().purge();
                        RemoteSessionManager.this.connd.setVisible(false);
                        RemoteSessionManager.this.monitor = new RemoteSessionMonitor();
                        RemoteSessionManager.this.monitorTask = (RunnableScheduledFuture)Utils.getMonitoringExecService().scheduleWithFixedDelay(RemoteSessionManager.this.monitor, 1L, 500L, TimeUnit.MILLISECONDS);
                        return;
                    }
                    catch (Throwable t) {
                        try {
                            RemoteSessionManager.this.channel.close(t.getLocalizedMessage(), t);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        RemoteSessionManager.this.channel = null;
                        t.printStackTrace();
                        RemoteSessionManager.this.initiated = true;
                    }
                }
                Utils.getMonitoringExecService().remove(RemoteSessionManager.this.remoteSessionTask);
                Utils.getMonitoringExecService().purge();
                RemoteSessionManager.this.connd.setVisible(false);
                if (RemoteSessionManager.this.remoteTable != null) {
                    RemoteSessionManager.this.remoteTable.setConnected(false);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(GUIMessage msg) {
        switch (msg.getMID()) {
            case 0: {
                Object[] o = (Object[])msg.getMsg();
                this.workingDir = (String)o[0];
                this.canWrite = (Boolean)o[1];
                break;
            }
            case 1: {
                this.userHome = (String)msg.getMsg();
                break;
            }
            case 2: {
                this.osName = (String)msg.getMsg();
                break;
            }
            case 3: {
                this.fileList = (Vector)msg.getMsg();
                this.remoteEx = msg.getException();
                break;
            }
            case 4: {
                this.roots = (String[])msg.getMsg();
                break;
            }
            case 5: {
                this.isRoot = (Boolean)msg.getMsg();
                break;
            }
            case 9: {
                this.shortNames = (HashMap)msg.getMsg();
                break;
            }
            case 10: {
                this.fileSeparator = (String)msg.getMsg();
                break;
            }
            case 11: {
                this.initiated = true;
                break;
            }
            case 12: {
                this.freeSpace = (String)msg.getMsg();
            }
        }
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public void sendMessage(GUIMessage msg) throws Exception {
        if (this.channel != null) {
            CtrlMsg c = new CtrlMsg(11, msg);
            this.channel.sendCtrlMessage(c);
        }
    }

    public boolean isConnected() {
        return this.channel != null;
    }

    @Override
    public void notifyCtrlMsg(GUIControlChannel controlChannel, Object o) throws FDTProcolException {
        if (o == null) {
            return;
        }
        if (o instanceof GUIMessage) {
            this.process((GUIMessage)o);
            return;
        }
        if (!(o instanceof CtrlMsg)) {
            return;
        }
        CtrlMsg msg = (CtrlMsg)o;
        if (msg.tag != 11) {
            return;
        }
        this.process((GUIMessage)msg.message);
    }

    @Override
    public void notifyCtrlSessionDown(GUIControlChannel controlChannel, Throwable cause) throws FDTProcolException {
        if (this.remoteTable != null) {
            this.remoteTable.setConnected(false);
        }
    }

    public FolderTable getLocalTable() {
        return this.localTable;
    }

    public FolderTable getRemoteTable() {
        return this.remoteTable;
    }

    private class RemoteSessionMonitor
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (RemoteSessionManager.this.channel == null || RemoteSessionManager.this.channel.isClosed()) {
                System.out.println("Detected connection closed...");
                RemoteSessionManager.this.initiated = true;
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
                try {
                    Utils.getMonitoringExecService().remove(RemoteSessionManager.this.remoteSessionTask);
                    Utils.getMonitoringExecService().purge();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (RemoteSessionManager.this.connd != null) {
                    RemoteSessionManager.this.connd.setVisible(false);
                }
                if (RemoteSessionManager.this.remoteTable != null) {
                    RemoteSessionManager.this.remoteTable.setConnected(false);
                }
                if (RemoteSessionManager.this.monitor != null) {
                    Utils.getMonitoringExecService().remove(RemoteSessionManager.this.monitorTask);
                    Utils.getMonitoringExecService().purge();
                    RemoteSessionManager.this.monitor = null;
                }
                try {
                    RemoteSessionManager.this.channel.close("Closed from the other end", new Exception());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                RemoteSessionManager.this.channel = null;
            }
        }
    }

    public static class ConnectMonitor
    extends JDialog {
        private JProgressBar progress;
        private JLabel label;

        public ConnectMonitor(JPanel component) {
            JDialog.setDefaultLookAndFeelDecorated(true);
            this.setLocation((int)component.getLocationOnScreen().getX() + component.getWidth() / 2 - 160, (int)component.getLocationOnScreen().getY() + component.getHeight() / 2 - 62);
            this.setTitle("Connecting");
            this.setDefaultCloseOperation(0);
            this.setAlwaysOnTop(true);
            ConnectMonitor.setDefaultLookAndFeelDecorated(true);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            this.label = new JLabel("Connecting");
            p1.add((Component)this.label, "Center");
            this.getContentPane().add(p1);
            JPanel p2 = new JPanel();
            p2.setLayout(new BorderLayout());
            this.progress = new JProgressBar();
            this.progress.setIndeterminate(true);
            this.progress.setStringPainted(false);
            p2.add((Component)this.progress, "Center");
            this.getContentPane().add(p2);
            this.setSize(240, 75);
            this.setResizable(false);
        }

        public void setProgress() {
            this.progress.setValue((this.progress.getValue() + 1) % 100);
            this.progress.repaint();
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.progress.setValue(0);
            }
            super.setVisible(visible);
        }
    }
}

