/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import java.util.Date;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import lia.util.net.common.Utils;
import lia.util.net.copy.disk.DiskWriterTask;
import lia.util.net.copy.monitoring.DiskWriterManagerMonitoringTask;

public class DiskWriterMonitoringTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(DiskWriterManagerMonitoringTask.class.getName());
    private final Lock countersRLock;
    long lastDtTake;
    long lastDtWrite;
    long lastDtFinishSession;
    long lastDtTotal;
    boolean initialized = false;
    StringBuilder sb = new StringBuilder();
    DiskWriterTask writerTask;
    Vector<String> paramNames = new Vector();
    Vector<Double> paramValues = new Vector();
    Vector<Integer> valueTypes = new Vector();

    public DiskWriterMonitoringTask(DiskWriterTask writerTask) {
        this.writerTask = writerTask;
        this.countersRLock = writerTask.getCountersRLock();
    }

    String getNiceProcent(double value) {
        int aux = (int)(value * 100.0);
        if (value >= 1.0) {
            if (aux % 100 != 0) {
                return (float)aux / 100.0f + "%";
            }
            return (int)value + "%";
        }
        if (value < 1.0 && value > 0.0) {
            return (float)aux / 100.0f + "%";
        }
        return value + "%";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.sb.setLength(0);
        this.sb.append("\n[ FileWriterMonitorTask Status @ ").append(new Date().toString()).append(" ]\n");
        this.sb.append("\n******************************************************\n");
        long diffDtTotal = 0L;
        long diffDtWrite = 0L;
        long diffDtFinishSession = 0L;
        long diffDtTake = 0L;
        long diffDtOther = 0L;
        double procWrite = 0.0;
        double procFinish = 0.0;
        double procTake = 0.0;
        double procOther = 0.0;
        boolean reportOk = false;
        this.countersRLock.lock();
        try {
            if (this.lastDtTotal != this.writerTask.dtTotal) {
                reportOk = true;
                if (this.initialized) {
                    diffDtTotal = this.writerTask.dtTotal - this.lastDtTotal;
                    diffDtTake = this.writerTask.dtTake - this.lastDtTake;
                    diffDtFinishSession = this.writerTask.dtFinishSession - this.lastDtFinishSession;
                    diffDtWrite = this.writerTask.dtWrite - this.lastDtWrite;
                    diffDtOther = diffDtTotal - (diffDtTake + diffDtFinishSession + diffDtWrite);
                }
                this.lastDtTake = this.writerTask.dtTake;
                this.lastDtTotal = this.writerTask.dtTotal;
                this.lastDtWrite = this.writerTask.dtWrite;
                this.lastDtFinishSession = this.writerTask.dtFinishSession;
            }
        }
        finally {
            this.countersRLock.unlock();
        }
        if (!this.initialized) {
            this.initialized = true;
            this.initParams();
            return;
        }
        this.sb.append("PoolStats:");
        if (reportOk) {
            procWrite = (double)diffDtWrite * 100.0 / (double)diffDtTotal;
            procFinish = (double)diffDtFinishSession * 100.0 / (double)diffDtTotal;
            procTake = (double)diffDtTake * 100.0 / (double)diffDtTotal;
            procOther = 100.0 - (procWrite + procFinish + procTake);
            this.sb.append("\n DT = ").append(diffDtTotal);
            this.sb.append(" DtTake = ").append(diffDtTake).append(" ( ").append(this.getNiceProcent(procTake)).append(" ) ");
            this.sb.append(" DtWrite = ").append(diffDtWrite).append(" ( ").append(this.getNiceProcent(procWrite)).append(" )");
            this.sb.append(" DtFinish = ").append(diffDtFinishSession).append(" ( ").append(this.getNiceProcent(procFinish)).append(" )");
            this.sb.append(" DtOther = ").append(diffDtOther).append(" ( ").append(this.getNiceProcent(procOther)).append(" )");
        }
        this.sb.append("\n******************************************************\n");
        System.out.println(this.sb.toString());
        if (Utils.getApMon() != null) {
            try {
                if (reportOk) {
                    this.paramValues.set(0, new Double(procTake));
                    this.paramValues.set(1, new Double(procWrite));
                    this.paramValues.set(2, new Double(procFinish));
                    this.paramValues.set(3, new Double(procOther));
                    Utils.getApMon().sendParameters(null, null, this.paramNames.size(), this.paramNames, this.valueTypes, this.paramValues);
                }
            }
            catch (Exception ex) {
                logger.warning("Could not send monitoring information to MonALISA.");
                ex.printStackTrace();
            }
        }
    }

    public void initParams() {
        String[] names = new String[]{"Network_GET", "Disk_PUT", "File_CLOSE", "Other"};
        for (int i = 0; i < names.length; ++i) {
            this.paramNames.add(names[i]);
            this.paramValues.add(null);
            this.valueTypes.add(5);
        }
    }
}

