/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa.net.dev;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lia.util.net.copy.monitoring.lisa.cmdExec;
import lia.util.net.copy.monitoring.lisa.net.PatternUtil;
import lia.util.net.copy.monitoring.lisa.net.dev.InterfaceStatistics;
import lia.util.net.copy.monitoring.lisa.net.dev.InterfaceStatisticsStatic;
import lia.util.net.copy.monitoring.lisa.net.dev.MTUSet;
import lia.util.net.copy.monitoring.lisa.net.dev.TXQueueLenSet;

public class InterfaceHandler {
    protected static final String ifNamePattern = "^(\\S+)\\s+";
    protected static final String hwAddrPattern = "HWaddr\\s+(\\S+)";
    protected static final String ipv4Pattern = "inet addr:(\\S+)";
    protected static final String mask4Pattern = "Mask:(\\S+)";
    protected static final String bcast4Pattern = "Bcast:(\\S+)";
    protected static final String mtuPattern = "MTU:(\\S+)";
    protected static final String rxPackets = "RX[\\s\\S]+packets:(\\S+)";
    protected static final String rxErrors = "RX[\\s\\S]+errors:(\\S+)";
    protected static final String rxDropped = "RX[\\s\\S]+dropped:(\\S+)";
    protected static final String rxOverruns = "RX[\\s\\S]+overruns:(\\S+)";
    protected static final String rxFrame = "RX[\\s\\S]+frame:(\\S+)";
    protected static final String rxBytes = "RX\\s+bytes:(\\S+)";
    protected static final String txPackets = "TX[\\s\\S]+packets:(\\S+)";
    protected static final String txErrors = "TX[\\s\\S]+errors:(\\S+)";
    protected static final String txDropped = "TX[\\s\\S]+dropped:(\\S+)";
    protected static final String txOverruns = "TX[\\s\\S]+overruns:(\\S+)";
    protected static final String txCarrier = "TX[\\s\\S]+carrier:(\\S+)";
    protected static final String txBytes = "TX\\s+bytes:(\\S+)";
    protected static final String collisions = "\\s+collisions:(\\S+)";
    protected static final String compressed = "\\s+compressed:(\\S+)";
    protected static final String txqueuelen = "\\s+txqueuelen:(\\S+)";
    protected static final String netDevPattern = "(\\S+):\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+";
    protected static final String supportedPortsPattern = "Supported ports:\\s*\\[(.*)\\]";
    protected static final String supportedLinkModes = "Supported link modes:\\s*(.*?)Supports";
    protected static final String supportsAutoNegotiation = "Supports auto-negotiation:\\s*(\\S+)";
    protected static final String speed = "Speed:\\s*(.*)";
    protected static final String duplex = "Duplex:\\s*(.*)";
    protected static final String port = "Port:\\s*(.*)";
    static final NumberFormat nf = NumberFormat.getInstance();
    protected final cmdExec exec;
    protected final PrintStream out;
    protected final Hashtable<String, String> lastRXPackets = new Hashtable();
    protected final Hashtable<String, String> lastRXErrors = new Hashtable();
    protected final Hashtable<String, String> lastRXDropped = new Hashtable();
    protected final Hashtable<String, String> lastRXOverruns = new Hashtable();
    protected final Hashtable<String, String> lastRXFrame = new Hashtable();
    protected final Hashtable<String, String> lastRXBytes = new Hashtable();
    protected final Hashtable<String, String> lastTXPackets = new Hashtable();
    protected final Hashtable<String, String> lastTXErrors = new Hashtable();
    protected final Hashtable<String, String> lastTXDropped = new Hashtable();
    protected final Hashtable<String, String> lastTXOverruns = new Hashtable();
    protected final Hashtable<String, String> lastTXCarrier = new Hashtable();
    protected final Hashtable<String, String> lastTXBytes = new Hashtable();
    protected final Hashtable<String, String> lastCollisions = new Hashtable();
    protected final Hashtable<String, String> lastCompressed = new Hashtable();
    protected final HashMap<String, InterfaceStatistics> ifs = new HashMap();
    protected final HashMap<String, InterfaceStatisticsStatic> lastGoodStatic = new HashMap();
    protected final HashMap<String, InterfaceStatisticsStatic> staticifs = new HashMap();
    protected final Logger logger;
    final List<String> ifArray = new ArrayList<String>();
    final List<String> toRemove = new ArrayList<String>();
    protected long lastCall = 0L;
    private boolean is64BitArch = false;

    public InterfaceHandler(PrintStream out, Logger logger) {
        this.logger = logger;
        this.out = out;
        this.exec = cmdExec.getInstance();
    }

    public static void main(String[] args) {
        String line = "Speed: Unknown (100000)\nTest\n";
        Pattern pattern = PatternUtil.getPattern("supportedLinkModes", speed);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            System.out.println(matcher.group(1));
        } else {
            System.out.println("no match");
        }
    }

    private final synchronized String getIfconfigPath() {
        String path = System.getProperty("net.ifconfig.path", "/bin,/sbin,/usr/bin,/usr/sbin");
        if (path == null || path.length() == 0) {
            this.logger.warning("[Net - iconfig can not be found in " + path + "]");
            return null;
        }
        return path.replace(',', ':').trim();
    }

    private final boolean checkLinkEncap(InterfaceStatisticsStatic props, String ifOutput) {
        if (ifOutput == null || ifOutput.length() == 0) {
            return false;
        }
        if (ifOutput.contains("Link encap:Ethernet")) {
            if (props != null) {
                props.setEncap((byte)0);
            }
            return true;
        }
        if (ifOutput.contains("Link encap:Fiber Distributed Data Interface")) {
            if (props != null) {
                props.setEncap((byte)1);
            }
            return true;
        }
        return false;
    }

    private final void checkIfConfig() {
        String ifc = this.getIfconfigPath();
        String command = "ifconfig";
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("ifconfig", null, ifc);
        String ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
            return;
        }
        double diff = 0.0;
        long now = System.currentTimeMillis();
        if (this.lastCall != 0L) {
            diff = (double)(now - this.lastCall) / 1000.0;
        }
        this.lastCall = now;
        String[] interfaces = ret.split("\n\n");
        this.ifArray.clear();
        for (int i = 0; i < interfaces.length; ++i) {
            double difRes;
            String res;
            String newVal;
            Pattern pattern = PatternUtil.getPattern("ifname", ifNamePattern);
            Matcher matcher = pattern.matcher(interfaces[i]);
            InterfaceStatistics ifProp = null;
            InterfaceStatisticsStatic ifPropStatic = null;
            String name = null;
            if (!matcher.find()) continue;
            name = matcher.group(1);
            this.ifArray.add(name);
            if (!this.ifs.containsKey(name)) {
                ifProp = new InterfaceStatistics(name);
                this.ifs.put(name, ifProp);
            } else {
                ifProp = this.ifs.get(name);
                ifProp.updateTime();
            }
            if (!this.staticifs.containsKey(name)) {
                ifPropStatic = new InterfaceStatisticsStatic(name);
                this.staticifs.put(name, ifPropStatic);
            } else {
                ifPropStatic = this.staticifs.get(name);
                ifPropStatic.updateTime();
            }
            if (!this.checkLinkEncap(ifPropStatic, interfaces[i])) {
                this.ifArray.remove(name);
                continue;
            }
            pattern = PatternUtil.getPattern("hwaddr", hwAddrPattern);
            matcher = pattern.matcher(interfaces[i]);
            if (matcher.find()) {
                ifPropStatic.setHwAddr(matcher.group(1));
            } else {
                ifPropStatic.setHwAddr("unknown");
            }
            pattern = PatternUtil.getPattern("ipv4", ipv4Pattern);
            matcher = pattern.matcher(interfaces[i]);
            if (matcher.find()) {
                ifProp.setIPv4(matcher.group(1));
            } else {
                ifProp.setIPv4("unknown");
            }
            pattern = PatternUtil.getPattern("mask4", mask4Pattern);
            matcher = pattern.matcher(interfaces[i]);
            if (matcher.find()) {
                ifProp.setMaskv4(matcher.group(1));
            } else {
                ifProp.setMaskv4("unknown");
            }
            pattern = PatternUtil.getPattern("bcast4", bcast4Pattern);
            matcher = pattern.matcher(interfaces[i]);
            if (matcher.find()) {
                ifProp.setBcastv4(matcher.group(1));
            } else {
                ifProp.setBcastv4("unknown");
            }
            pattern = PatternUtil.getPattern("mtu", mtuPattern);
            matcher = pattern.matcher(interfaces[i]);
            if (matcher.find()) {
                try {
                    ifProp.setMTU(Integer.parseInt(matcher.group(1)));
                }
                catch (Exception ex) {
                    ifProp.setMTU(-1);
                }
            } else {
                ifProp.setMTU(-1);
            }
            pattern = PatternUtil.getPattern("rxpackets", rxPackets);
            matcher = pattern.matcher(interfaces[i]);
            if (matcher.find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastRXPackets.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setRXPackets(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setRXPackets(-1.0);
                    }
                }
                this.lastRXPackets.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("rxerrors", rxErrors)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastRXErrors.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setRXErrors(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setRXErrors(-1.0);
                    }
                }
                this.lastRXErrors.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("rxdropped", rxDropped)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastRXDropped.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setRXDropped(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setRXDropped(-1.0);
                    }
                }
                this.lastRXDropped.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("rxoverruns", rxOverruns)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastRXOverruns.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setRXOverruns(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setRXOverruns(-1.0);
                    }
                }
                this.lastRXOverruns.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("rxframe", rxFrame)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastRXFrame.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setRXFrame(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setRXFrame(-1.0);
                    }
                }
                this.lastRXFrame.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("rxBytes", rxBytes)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastRXBytes.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setRX(difRes * 8.0 / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setRX(-1.0);
                    }
                }
                this.lastRXBytes.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("txpackets", txPackets)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastTXPackets.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setTXPackets(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setTXPackets(-1.0);
                    }
                }
                this.lastTXPackets.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("txerrors", txErrors)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastTXErrors.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setTXErrors(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setTXErrors(-1.0);
                    }
                }
                this.lastTXErrors.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("txdropped", txDropped)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastTXDropped.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setTXDropped(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setTXDropped(-1.0);
                    }
                }
                this.lastTXDropped.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("txoverruns", txOverruns)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastTXOverruns.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setTXOverruns(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setTXOverruns(-1.0);
                    }
                }
                this.lastTXOverruns.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("txcarrier", txCarrier)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastTXCarrier.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setTXCarrier(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setTXCarrier(-1.0);
                    }
                }
                this.lastTXCarrier.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("txBytes", txBytes)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastTXBytes.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setTX(difRes * 8.0 / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setTX(-1.0);
                    }
                }
                this.lastTXBytes.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("collisions", collisions)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastCollisions.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setCollisions(difRes / diff);
                    }
                    catch (Throwable t) {
                        ifProp.setCollisions(-1.0);
                    }
                }
                this.lastCollisions.put(name, newVal);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("compressed", compressed)).matcher(interfaces[i])).find()) {
                newVal = matcher.group(1);
                if (diff > 0.0) {
                    res = this.diffWithOverflowCheck(newVal, this.lastCompressed.get(name));
                    try {
                        difRes = Double.parseDouble(res);
                        ifProp.setCompressed(difRes / diff);
                        ifProp.setCanCompress(true);
                    }
                    catch (Throwable t) {
                        ifProp.setCompressed(-1.0);
                    }
                }
                this.lastCompressed.put(name, newVal);
            } else {
                ifProp.setCanCompress(false);
            }
            pattern = PatternUtil.getPattern("txqueuelen", txqueuelen);
            matcher = pattern.matcher(interfaces[i]);
            if (!matcher.find()) continue;
            newVal = matcher.group(1);
            try {
                ifProp.setTXQueueLen(Integer.parseInt(newVal));
                continue;
            }
            catch (Exception e) {
                ifProp.setTXQueueLen(-1);
            }
        }
        this.toRemove.clear();
        for (String ifn : this.ifs.keySet()) {
            if (this.ifArray.contains(ifn)) continue;
            this.toRemove.add(ifn);
        }
        for (String ifn : this.toRemove) {
            this.ifs.remove(ifn);
            this.staticifs.remove(ifn);
        }
    }

    public void modify(TXQueueLenSet set) {
        String ifc = this.getIfconfigPath();
        String previoustx = null;
        String command = "ifconfig " + set.ifName;
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality(command, null, ifc);
        String ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
        } else {
            Pattern pattern = PatternUtil.getPattern("txqueuelen", txqueuelen);
            Matcher matcher = pattern.matcher(ret);
            if (matcher.find()) {
                previoustx = matcher.group(1);
            }
        }
        command = "ifconfig " + set.ifName + " txqueuelen " + set.txqueuelen;
        cmdRes = this.exec.executeCommandReality(command, null, ifc);
        ret = cmdRes.getOutput();
        boolean done = true;
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
            done = false;
        }
        if (done) {
            Pattern pattern;
            Matcher matcher;
            command = "ifconfig " + set.ifName;
            cmdRes = this.exec.executeCommandReality(command, null, ifc);
            ret = cmdRes.getOutput();
            if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
                if (this.out != null) {
                    this.out.println(ret);
                } else {
                    this.logger.info(ret);
                }
                done = false;
            }
            if (done && (matcher = (pattern = PatternUtil.getPattern("txqueuelen", txqueuelen)).matcher(ret)).find()) {
                String newVal = matcher.group(1);
                if (previoustx == null) {
                    return;
                }
                boolean bl = done = !previoustx.equals(newVal);
            }
        }
        if (done) {
            return;
        }
        this.doIfDown(set.ifName);
        command = "ifconfig " + set.ifName + " txqueuelen " + set.txqueuelen;
        cmdRes = this.exec.executeCommandReality(command, null, ifc);
        ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
        }
        this.doIfUp(set.ifName);
    }

    public void modify(MTUSet set) {
        String ifc = this.getIfconfigPath();
        String previousmtu = null;
        String command = "ifconfig " + set.ifName;
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality(command, null, ifc);
        String ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
        } else {
            Pattern pattern = PatternUtil.getPattern("mtu", mtuPattern);
            Matcher matcher = pattern.matcher(ret);
            if (matcher.find()) {
                previousmtu = matcher.group(1);
            }
        }
        command = "ifconfig " + set.ifName + " mtu " + set.mtu;
        cmdRes = this.exec.executeCommandReality(command, null, ifc);
        ret = cmdRes.getOutput();
        boolean done = true;
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
            done = false;
        }
        if (done) {
            Pattern pattern;
            Matcher matcher;
            command = "ifconfig " + set.ifName;
            cmdRes = this.exec.executeCommandReality(command, null, ifc);
            ret = cmdRes.getOutput();
            if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
                if (this.out != null) {
                    this.out.println(ret);
                } else {
                    this.logger.info(ret);
                }
                done = false;
            }
            if (done && (matcher = (pattern = PatternUtil.getPattern("mtu", mtuPattern)).matcher(ret)).find()) {
                String newVal = matcher.group(1);
                if (previousmtu == null) {
                    return;
                }
                boolean bl = done = !previousmtu.equals(newVal);
            }
        }
        if (done) {
            return;
        }
        this.doIfDown(set.ifName);
        command = "ifconfig " + set.ifName + " mtu " + set.mtu;
        cmdRes = this.exec.executeCommandReality(command, null, ifc);
        ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
        }
        this.doIfUp(set.ifName);
    }

    private void doIfDown(String ifName) {
        String ifc = this.getIfconfigPath();
        String command = "ifconfig down";
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("ifconfig down", null, ifc);
        String ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
            return;
        }
    }

    private void doIfUp(String ifName) {
        String ifc = this.getIfconfigPath();
        String command = "ifconfig up";
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("ifconfig up", null, ifc);
        String ret = cmdRes.getOutput();
        if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
            if (this.out != null) {
                this.out.println(ret);
            } else {
                this.logger.info(ret);
            }
            return;
        }
    }

    private final boolean shouldRunEthTool() {
        String prop = System.getProperty("net.ethtool.use", null);
        if (prop == null) {
            return true;
        }
        try {
            return Boolean.getBoolean(prop);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private final synchronized String getEthtoolPath() {
        String path = System.getProperty("net.ethtool.path", "/bin,/sbin,/usr/bin,/usr/sbin");
        if (path == null || path.length() == 0) {
            this.logger.warning("[Net - ethtool can not be found in " + path + "]");
            return null;
        }
        return path.replace(',', ':').trim();
    }

    private final void checkEthtool() {
        String eth = this.getEthtoolPath();
        String command = "ethtool ";
        for (Map.Entry<String, InterfaceStatisticsStatic> entry : this.staticifs.entrySet()) {
            String ss;
            int k;
            String[] sp;
            String mm;
            String ifName = entry.getKey();
            InterfaceStatisticsStatic stat = entry.getValue();
            if (ifName == null || ifName.length() == 0 || stat == null) continue;
            cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("ethtool " + ifName, null, eth);
            String ret = cmdRes.getOutput();
            if (cmdRes.failed() || ret == null || ret.length() == 0 || PatternUtil.getPattern("Unknown command", null).matcher(ret).matches()) {
                if (this.out != null) {
                    this.out.println(ret);
                    continue;
                }
                if (!this.logger.isLoggable(Level.FINER)) continue;
                this.logger.log(Level.FINE, ret);
                continue;
            }
            stat.setSupportedPorts((byte)0);
            Pattern pattern = PatternUtil.getPattern("supportedPorts", supportedPortsPattern);
            Matcher matcher = pattern.matcher(ret);
            if (matcher.find() && (mm = matcher.group(1)).trim().length() != 0) {
                sp = mm.trim().split(" ");
                for (k = 0; k < sp.length; ++k) {
                    if (sp[k].equals("TP")) {
                        stat.setSupportedPorts((byte)1);
                    }
                    if (sp[k].equals("AUI")) {
                        stat.setSupportedPorts((byte)2);
                    }
                    if (sp[k].equals("BNC")) {
                        stat.setSupportedPorts((byte)4);
                    }
                    if (sp[k].equals("MII")) {
                        stat.setSupportedPorts((byte)8);
                    }
                    if (!sp[k].equals("FIBRE")) continue;
                    stat.setSupportedPorts((byte)16);
                }
            }
            if ((matcher = (pattern = PatternUtil.getPattern("supportedLinkModes", supportedLinkModes, true)).matcher(ret)).find() && (mm = matcher.group(1)).trim().length() != 0) {
                sp = mm.trim().split("[ \n]+");
                for (k = 0; k < sp.length; ++k) {
                    if (sp[k].trim().length() == 0) continue;
                    String ss2 = sp[k].trim();
                    if (ss2.equals("10baseT/Half")) {
                        stat.setSupportedLinkModes((byte)1);
                    }
                    if (ss2.equals("10baseT/Full")) {
                        stat.setSupportedLinkModes((byte)2);
                    }
                    if (ss2.equals("100baseT/Half")) {
                        stat.setSupportedLinkModes((byte)4);
                    }
                    if (ss2.equals("100baseT/Full")) {
                        stat.setSupportedLinkModes((byte)8);
                    }
                    if (ss2.equals("1000baseT/Half")) {
                        stat.setSupportedLinkModes((byte)16);
                    }
                    if (!ss2.equals("1000baseT/Full")) continue;
                    stat.setSupportedLinkModes((byte)32);
                }
            }
            if ((matcher = (pattern = PatternUtil.getPattern("supportsAutoNegotiation", supportsAutoNegotiation)).matcher(ret)).find() && (mm = matcher.group(1)).trim().length() != 0 && mm.trim().equals("Yes")) {
                stat.setSupportsAutoNegotiation(true);
            }
            if ((matcher = (pattern = PatternUtil.getPattern("linkSpeed", speed)).matcher(ret)).find() && (mm = matcher.group(1)) != null && mm.trim().length() != 0) {
                ss = mm.trim();
                if (ss.equals("10Mb/s")) {
                    stat.setMaxSpeed(10);
                } else if (ss.equals("100Mb/s")) {
                    stat.setMaxSpeed(100);
                } else if (ss.equals("1000Mb/s")) {
                    stat.setMaxSpeed(1000);
                } else if (ss.equals("10000Mb/s")) {
                    stat.setMaxSpeed(10000);
                } else if (ss.startsWith("Unknown")) {
                    String sp2 = ss.substring(ss.indexOf(40) + 1, ss.lastIndexOf(41));
                    try {
                        stat.setMaxSpeed(Integer.parseInt(sp2));
                    }
                    catch (Exception ex) {
                        this.logger.warning("Can not determine speed " + ss + " for " + ifName);
                    }
                }
            }
            if ((matcher = (pattern = PatternUtil.getPattern("linkDuplex", duplex)).matcher(ret)).find() && (mm = matcher.group(1)) != null && mm.trim().length() != 0) {
                ss = mm.trim();
                if (ss.compareToIgnoreCase("Half") == 0) {
                    stat.setDuplex((byte)0);
                } else if (ss.compareToIgnoreCase("Full") == 0) {
                    stat.setDuplex((byte)1);
                }
            }
            if (!(matcher = (pattern = PatternUtil.getPattern("linkPort", port)).matcher(ret)).find() || (mm = matcher.group(1)) == null || mm.trim().length() == 0) continue;
            ss = mm.trim();
            if (ss.compareTo("Twisted Pair") == 0) {
                stat.setPort((byte)1);
                continue;
            }
            if (ss.compareToIgnoreCase("FIBRE") == 0) {
                stat.setPort((byte)16);
                continue;
            }
            if (ss.compareToIgnoreCase("AUI") == 0) {
                stat.setPort((byte)2);
                continue;
            }
            if (ss.compareToIgnoreCase("BNC") == 0) {
                stat.setPort((byte)4);
                continue;
            }
            if (ss.compareToIgnoreCase("MII") != 0) continue;
            stat.setPort((byte)8);
        }
    }

    private final void getFromProcDev() {
        this.ifArray.clear();
        Pattern pattern = PatternUtil.getPattern("/proc/net/dev", netDevPattern);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/net/dev"));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String ifName = matcher.group(1);
                this.ifArray.add(ifName);
                if (!this.ifs.containsKey(ifName)) {
                    this.ifs.put(ifName, new InterfaceStatistics(ifName));
                    continue;
                }
                this.ifs.get(ifName).updateTime();
            }
            reader.close();
        }
        catch (Exception reader) {
            // empty catch block
        }
        this.toRemove.clear();
        for (String ifn : this.ifs.keySet()) {
            if (this.ifArray.contains(ifn)) continue;
            this.toRemove.add(ifn);
        }
        for (String ifn : this.toRemove) {
            this.ifs.remove(ifn);
        }
    }

    private final boolean compare(InterfaceStatisticsStatic olds, InterfaceStatisticsStatic news) {
        if (olds.getEncap() != news.getEncap()) {
            return false;
        }
        if (olds.getHwAddr() == null && news.getHwAddr() != null) {
            return false;
        }
        if (olds.getHwAddr() != null && news.getHwAddr() == null) {
            return false;
        }
        if (olds.getHwAddr() != null && news.getHwAddr() != null && !olds.getHwAddr().equals(news.getHwAddr())) {
            return false;
        }
        if (olds.getSupportedPorts() != news.getSupportedPorts()) {
            return false;
        }
        if (olds.getSupportedLinkModes() != news.getSupportedLinkModes()) {
            return false;
        }
        if (olds.supportsAutoNegotiation() != news.supportsAutoNegotiation()) {
            return false;
        }
        if (olds.getMaxSpeed() != news.getMaxSpeed()) {
            return false;
        }
        if (olds.getDuplex() != news.getDuplex()) {
            return false;
        }
        return olds.getPort() == news.getPort();
    }

    public final void check() {
        this.checkIfConfig();
        if (this.ifs.size() == 0) {
            this.getFromProcDev();
        }
        if (this.ifs.size() == 0) {
            return;
        }
        if (this.shouldRunEthTool()) {
            this.checkEthtool();
        }
        LinkedList<String> names = new LinkedList<String>();
        for (Map.Entry<String, InterfaceStatisticsStatic> entry : this.lastGoodStatic.entrySet()) {
            names.addLast(entry.getKey());
        }
        for (String name : names) {
            if (this.staticifs.containsKey(name)) continue;
            this.lastGoodStatic.remove(name);
        }
        names.clear();
        for (Map.Entry<String, InterfaceStatisticsStatic> entry : this.staticifs.entrySet()) {
            names.addLast(entry.getKey());
        }
        for (String name : names) {
            InterfaceStatisticsStatic news;
            if (!this.lastGoodStatic.containsKey(name)) {
                this.lastGoodStatic.put(name, this.staticifs.get(name));
                continue;
            }
            InterfaceStatisticsStatic olds = this.lastGoodStatic.get(name);
            if (!this.compare(olds, news = this.staticifs.get(name))) {
                this.lastGoodStatic.put(name, news);
                continue;
            }
            this.staticifs.remove(name);
        }
    }

    public final HashMap<String, InterfaceStatistics> getIfStatistics() {
        return this.ifs;
    }

    public final HashMap<String, InterfaceStatisticsStatic> getOldIfStatisticsStatic() {
        return this.lastGoodStatic;
    }

    public final HashMap<String, InterfaceStatisticsStatic> getIfStatisticsStatic() {
        return this.staticifs;
    }

    public String diffWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            if (newv.compareTo(oldv) >= 0) {
                return newv.subtract(oldv).toString();
            }
            BigInteger overflow = new BigInteger("1").shiftLeft(64);
            BigDecimal d = new BigDecimal(overflow.toString());
            return newv.add(d).subtract(oldv).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.diffWithOverflowCheck(newVal, oldVal);
        }
        if (newv >= oldv) {
            return "" + (newv - oldv);
        }
        long vmax = 0x100000000L;
        return "" + (newv - oldv + (double)vmax);
    }

    public String divideWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            return newv.divide(oldv, 3).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.divideWithOverflowCheck(newVal, oldVal);
        }
        return "" + newv / oldv;
    }

    private final String prepareString(String str) {
        try {
            double d = Double.parseDouble(str);
            if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                String n = nf.format(d);
                n = n.replaceAll(",", "");
                return n;
            }
        }
        catch (Throwable d) {
            // empty catch block
        }
        if (!str.contains(".")) {
            return str + ".0000";
        }
        int nr = str.lastIndexOf(46) + 1;
        for (int i = nr = str.length() - nr; i < 4; ++i) {
            str = str + "0";
        }
        return str;
    }

    public void clear() {
        this.ifs.clear();
        this.staticifs.clear();
    }

    static {
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(4);
    }
}

