/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa.net.dev;

import java.util.LinkedList;
import lia.util.net.copy.monitoring.lisa.net.Statistics;

public class InterfaceStatisticsStatic
extends Statistics {
    public static final byte TYPE_ETHERNET = 0;
    public static final byte TYPE_FIBER = 1;
    public static final byte PORT_TP = 1;
    public static final byte PORT_AUI = 2;
    public static final byte PORT_BNC = 4;
    public static final byte PORT_MII = 8;
    public static final byte PORT_FIBRE = 16;
    public static final byte SUPPORTED_10BaseT_Half = 1;
    public static final byte SUPPORTED_10BaseT_Full = 2;
    public static final byte SUPPORTED_100BaseT_Half = 4;
    public static final byte SUPPORTED_100BaseT_Full = 8;
    public static final byte SUPPORTED_1000BaseT_Half = 16;
    public static final byte SUPPORTED_1000BaseT_Full = 32;
    public static final byte LINK_HALF = 0;
    public static final byte LINK_DUPLEX = 1;
    protected final String name;
    protected byte encap = 0;
    protected String hwAddr;
    protected byte supportedPorts = (byte)-1;
    protected byte supportedLinkModes = (byte)-1;
    protected boolean supportsAutoNegotiation = false;
    protected int maxSpeed = -1;
    protected byte duplex = (byte)-1;
    protected byte port = (byte)-1;

    public InterfaceStatisticsStatic(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final byte getEncap() {
        return this.encap;
    }

    public final void setEncap(byte type) {
        this.encap = type;
    }

    public final String getEncapAsString() {
        switch (this.encap) {
            case 0: {
                return "Ethernet";
            }
            case 1: {
                return "Fiber";
            }
        }
        return "Unknown";
    }

    public final String getHwAddr() {
        return this.hwAddr;
    }

    public final void setHwAddr(String hwAddr) {
        this.hwAddr = hwAddr;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IFNAME [name=").append(this.name);
        buf.append(",encap=").append(this.getEncapAsString());
        buf.append(",hwaddr=").append(this.hwAddr);
        buf.append(",supportedPort=").append(this.supportedPorts);
        buf.append(",supportedLinkModes=").append(this.supportedLinkModes);
        buf.append(",supportsAutoNeg=").append(this.supportsAutoNegotiation);
        buf.append(",maxSpeed=").append(this.maxSpeed);
        buf.append(",duplex=").append(this.duplex);
        buf.append(",port=").append(this.port);
        buf.append("]");
        return buf.toString();
    }

    public byte getSupportedPorts() {
        return this.supportedPorts;
    }

    public void setSupportedPorts(byte supportedPorts) {
        if (this.supportedPorts < 0) {
            this.supportedPorts = 0;
        }
        this.supportedPorts = (byte)(this.supportedPorts | supportedPorts);
    }

    private boolean flagSet(byte b, byte flag) {
        return (b & flag) == flag;
    }

    public String[] getSupportedPortsAsString() {
        if (this.supportedPorts < 0) {
            return new String[]{"UNKNOWN"};
        }
        LinkedList<String> list = new LinkedList<String>();
        if (this.flagSet(this.supportedPorts, (byte)1)) {
            list.addLast("TP");
        }
        if (this.flagSet(this.supportedPorts, (byte)2)) {
            list.addLast("AUI");
        }
        if (this.flagSet(this.supportedPorts, (byte)4)) {
            list.addLast("BNC");
        }
        if (this.flagSet(this.supportedPorts, (byte)8)) {
            list.addLast("MII");
        }
        if (this.flagSet(this.supportedPorts, (byte)16)) {
            list.addLast("FIBRE");
        }
        if (list.size() == 0) {
            return new String[]{"NONE"};
        }
        return list.toArray(new String[0]);
    }

    public byte getSupportedLinkModes() {
        return this.supportedLinkModes;
    }

    public void setSupportedLinkModes(byte supportedLinkModes) {
        if (this.supportedLinkModes < 0) {
            this.supportedLinkModes = 0;
        }
        this.supportedLinkModes = (byte)(this.supportedLinkModes | supportedLinkModes);
    }

    public String[] getSupportedLinkModesAsString() {
        if (this.supportedLinkModes < 0) {
            return new String[]{"UNKNOWN"};
        }
        LinkedList<String> list = new LinkedList<String>();
        if (this.flagSet(this.supportedLinkModes, (byte)1)) {
            list.add("10BaseT_Half");
        }
        if (this.flagSet(this.supportedLinkModes, (byte)2)) {
            list.add("10BaseT_Full");
        }
        if (this.flagSet(this.supportedLinkModes, (byte)4)) {
            list.add("100BaseT_Half");
        }
        if (this.flagSet(this.supportedLinkModes, (byte)8)) {
            list.add("100BaseT_Full");
        }
        if (this.flagSet(this.supportedLinkModes, (byte)16)) {
            list.add("1000BaseT_Half");
        }
        if (this.flagSet(this.supportedLinkModes, (byte)32)) {
            list.add("1000BaseT_Full");
        }
        if (list.size() == 0) {
            return new String[]{"NONE"};
        }
        return list.toArray(new String[0]);
    }

    public boolean supportsAutoNegotiation() {
        return this.supportsAutoNegotiation;
    }

    public void setSupportsAutoNegotiation(boolean supportsAutoNegotiation) {
        this.supportsAutoNegotiation = supportsAutoNegotiation;
    }

    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(int maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public String getMaxSpeedAsString() {
        if (this.maxSpeed < 0) {
            return "UNKNOWN";
        }
        return this.maxSpeed + " Mb/s";
    }

    public byte getDuplex() {
        return this.duplex;
    }

    public void setDuplex(byte duplex) {
        this.duplex = duplex;
    }

    public byte getPort() {
        return this.port;
    }

    public void setPort(byte port) {
        this.port = port;
    }
}

