/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa.xdr;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Logger;
import lia.util.net.copy.monitoring.lisa.xdr.XDRGenericComm;
import lia.util.net.copy.monitoring.lisa.xdr.XDRInputStream;
import lia.util.net.copy.monitoring.lisa.xdr.XDROutputStream;

public abstract class XDRTcpSocket
extends XDRGenericComm {
    private static final transient Logger logger = Logger.getLogger("lisa.comm.XDRTcpSocket");
    protected boolean closed;
    private Socket rawSocket;

    public XDRTcpSocket(Socket s) throws IOException {
        super("XDRTcpSocket for [ " + s.getInetAddress() + ":" + s.getPort() + " ] ", new XDROutputStream(s.getOutputStream()), new XDRInputStream(s.getInputStream()));
        this.rawSocket = s;
        this.closed = false;
    }

    public int getPort() {
        return this.rawSocket.getPort();
    }

    public int getLocalPort() {
        return this.rawSocket.getLocalPort();
    }

    public InetAddress getInetAddress() {
        return this.rawSocket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.rawSocket.getLocalAddress();
    }

    @Override
    public void close() {
        try {
            super.close();
            if (!this.closed) {
                this.closed = true;
                if (this.rawSocket != null) {
                    this.rawSocket.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

