/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.Utils;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.FileBlockConsumer;
import lia.util.net.copy.transport.FDTKeyAttachement;
import lia.util.net.copy.transport.FDTReaderKeyAttachement;
import lia.util.net.copy.transport.SocketTask;
import lia.util.net.copy.transport.TCPSessionReader;
import lia.util.net.copy.transport.internal.FDTSelectionKey;

public class SocketReaderTask
extends SocketTask {
    private static final Logger logger = Logger.getLogger(SocketReaderTask.class.getName());
    private static final int RETRY_IO_COUNT = Config.getInstance().getRetryIOCount();
    final AtomicReference<FDTSelectionKey> fdtSelectionKeyRef = new AtomicReference();
    private final TCPSessionReader master;
    private final FileBlockConsumer fileBlockConsumer;
    private final boolean isNetTest;

    SocketReaderTask(BlockingQueue<FDTSelectionKey> readyChannelsQueue, FileBlockConsumer fileBlockConsumer, TCPSessionReader master) {
        super(readyChannelsQueue);
        this.fileBlockConsumer = fileBlockConsumer;
        this.master = master;
        this.isNetTest = master.isNetTest();
    }

    private boolean setAttachementBuffers(FDTReaderKeyAttachement attach) throws InterruptedException {
        return attach.recycleAndSetBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkForData() throws InterruptedException {
        FDTSelectionKey fdtSelectionKey = this.fdtSelectionKeyRef.get();
        FDTReaderKeyAttachement attach = (FDTReaderKeyAttachement)fdtSelectionKey.attachment();
        if (attach.isHeaderRead() && attach.isPayloadRead()) {
            fdtSelectionKey.opCount = 0;
            this.addAndGetUtilBytes(attach.payloadSize);
            this.master.addAndGetUtilBytes(attach.payloadSize);
            if (this.isNetTest) {
                attach.header().clear();
                return false;
            }
            if (!this.master.localLoop()) {
                FileBlock fileBlock = attach.toFileBlock();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "<SocketReaderTask> read a full FileBlock for: " + Utils.buffToString(fileBlock.buff));
                }
                boolean offered = false;
                try {
                    do {
                        if (!(offered = this.fileBlockConsumer.offer(fileBlock, 5L, TimeUnit.SECONDS))) continue;
                    } while (!this.isClosed() && !Thread.currentThread().isInterrupted());
                }
                finally {
                    if (!offered) {
                        if (!offered && fileBlock != null && fileBlock.buff != null) {
                            DirectByteBufferPool.getInstance().put(fileBlock.buff);
                        }
                        this.recycleBuffers();
                        return false;
                    }
                }
            } else {
                attach.recyclePaylod();
            }
            attach.recycleHeader();
            return true;
        }
        return false;
    }

    private boolean readData() throws Exception {
        FDTSelectionKey fdtSelectionKey = this.fdtSelectionKeyRef.get();
        FDTReaderKeyAttachement attach = (FDTReaderKeyAttachement)fdtSelectionKey.attachment();
        SocketChannel sc = fdtSelectionKey.channel();
        boolean logFinest = logger.isLoggable(Level.FINEST);
        if (logFinest) {
            logger.log(Level.FINEST, " [ SocketReaderTask ] [ readData ] for " + Utils.toStringSelectionKey(fdtSelectionKey));
        }
        long count = -1L;
        if (!attach.hasBuffers()) {
            if (!attach.recycleAndSetBuffers()) {
                return false;
            }
        } else if (this.checkForData()) {
            if (!this.setAttachementBuffers(attach)) {
                return false;
            }
            if (this.isClosed()) {
                attach.recycleBuffers();
            }
        }
        ByteBuffer bpl = attach.payload();
        while (!this.isClosed() && !Thread.currentThread().isInterrupted()) {
            if (this.isNetTest) {
                attach.isHeaderProcessed = true;
                bpl.clear();
                count = sc.read(bpl);
                if (isBlocking) {
                    while (count >= 0L) {
                        this.addAndGetTotalBytes(count);
                        this.master.addAndGetTotalBytes(count);
                        bpl.clear();
                        count = sc.read(bpl);
                    }
                }
            } else if (attach.useFixedSizeBlocks) {
                count = sc.read(attach.asArray());
            } else if (attach.isHeaderRead()) {
                count = sc.read(attach.payload());
            } else {
                count = sc.read(attach.header());
                if (attach.isHeaderRead()) {
                    this.addAndGetTotalBytes(count);
                    if (logFinest) {
                        logger.log(Level.FINEST, " [ SocketReaderTask ] socket: " + sc.socket() + " count: " + count);
                    }
                    this.master.addAndGetTotalBytes(count);
                    count = sc.read(attach.payload());
                }
            }
            if (count > 0L) {
                fdtSelectionKey.opCount = 0;
                if (logFinest) {
                    logger.log(Level.FINEST, " [ SocketReaderTask ] socket: " + sc.socket() + " count: " + count);
                }
                this.addAndGetTotalBytes(count);
                this.master.addAndGetTotalBytes(count);
                if (!this.checkForData()) continue;
                if (!this.setAttachementBuffers(attach)) {
                    return false;
                }
                if (!this.isClosed()) continue;
                attach.recycleBuffers();
                continue;
            }
            if (count == 0L) {
                if (this.checkForData() && this.setAttachementBuffers(attach)) {
                    if (!this.isClosed()) continue;
                    attach.recycleBuffers();
                    continue;
                }
                if (fdtSelectionKey.opCount++ <= RETRY_IO_COUNT) continue;
                if (isBlocking) {
                    if (!attach.hasBuffers()) break;
                    logger.log(Level.WARNING, " reached RETRY_IO_COUNT in blocking mode ... remote peer down?! SC is blocking: " + sc.isBlocking());
                    this.master.workerDown(fdtSelectionKey, null);
                }
                if (!attach.hasBuffers()) break;
                fdtSelectionKey.renewInterest();
                return true;
            }
            this.master.workerDown(fdtSelectionKey, null);
            this.close("EOF", null);
        }
        return false;
    }

    private void recycleBuffers() {
        try {
            FDTKeyAttachement attach;
            FDTSelectionKey fdtSelectionKey = this.fdtSelectionKeyRef.get();
            if (fdtSelectionKey != null && (attach = fdtSelectionKey.attachment()) != null) {
                attach.recycleBuffers();
            }
        }
        catch (Throwable t1) {
            logger.log(Level.WARNING, " Got exception trying to recover the buffers and returning them to pool", t1);
        }
    }

    @Override
    public void internalClose() {
        FDTSelectionKey fdtSelectionKey = this.fdtSelectionKeyRef.getAndSet(null);
        if (fdtSelectionKey != null) {
            FDTKeyAttachement keyAttachement;
            fdtSelectionKey.cancel();
            SocketChannel sc = fdtSelectionKey.channel();
            if (sc != null) {
                try {
                    sc.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((keyAttachement = fdtSelectionKey.attachment()) != null) {
                try {
                    keyAttachement.recycleBuffers();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

