/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport.gui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileSystemView;
import lia.util.net.common.AbstractFDTCloseable;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.FDTProcolException;
import lia.util.net.copy.transport.gui.FileHandler;
import lia.util.net.copy.transport.gui.GUIMessage;

public class ServerSessionManager
extends AbstractFDTCloseable
implements Runnable {
    private static final CtrlMsg versionMsg = new CtrlMsg(1, "0.26.3-2021-03-31");
    private static final Logger logger = Logger.getLogger(ControlChannel.class.getName());
    private static FileSystemView local = FileSystemView.getFileSystemView();
    public final InetAddress remoteAddress;
    public final int remotePort;
    public final int localPort;
    protected final Vector<FileHandler> currentFiles = new Vector();
    private final HashMap<String, File> roots = new HashMap();
    private final HashMap<String, String> h = new HashMap();
    public String currentDir;
    public String osName;
    public String fileSeparator;
    public String userDir;
    private File currentFile;
    private boolean canWrite;
    private Socket controlSocket;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private ConcurrentLinkedQueue<Object> qToSend = new ConcurrentLinkedQueue();

    public ServerSessionManager(Socket s) throws Exception {
        this.currentFile = local.getHomeDirectory();
        this.currentDir = this.currentFile.getAbsolutePath();
        this.osName = System.getProperty("os.name");
        this.userDir = System.getProperty("user.home");
        this.fileSeparator = System.getProperty("file.separator");
        this.update();
        try {
            this.controlSocket = s;
            this.remoteAddress = s.getInetAddress();
            this.remotePort = s.getPort();
            this.localPort = s.getLocalPort();
            this.initStreams();
            this.controlSocket.setSoTimeout(1000);
        }
        catch (Throwable t) {
            this.close("Cannot instantiate ControlChannel", t);
            throw new Exception(t);
        }
    }

    public void setAbsoluteDir(String dir) {
        if (dir == null) {
            return;
        }
        if (this.roots.containsKey(dir = this.getRoot(dir))) {
            this.currentFile = this.roots.get(dir);
            this.currentDir = this.currentFile.getAbsolutePath();
            this.update();
            return;
        }
        try {
            File f = new File(dir);
            if (!(f.exists() && f.isDirectory() && f.canRead())) {
                return;
            }
            this.currentFile = f;
            this.currentDir = this.currentFile.getAbsolutePath();
            this.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String getRoot(String dir) {
        if (this.roots.containsKey(dir)) {
            return dir;
        }
        for (Map.Entry<String, File> entry : this.roots.entrySet()) {
            if (!entry.getValue().getAbsolutePath().equals(dir)) continue;
            return entry.getKey();
        }
        return dir;
    }

    public void setRelativeDir(String dir) {
        File f = local.getChild(this.currentFile, dir);
        if (f == null || !f.exists() || !f.isDirectory()) {
            return;
        }
        this.currentFile = f;
        this.currentDir = f.getAbsolutePath();
        this.update();
    }

    public void setUpDir() {
        File f = local.getParentDirectory(this.currentFile);
        if (f == null || !f.exists() || !f.isDirectory()) {
            return;
        }
        this.currentFile = f;
        this.currentDir = f.getAbsolutePath();
        this.update();
    }

    public String[] getRoots() {
        String p;
        File f;
        String displayName;
        int i;
        this.roots.clear();
        HashSet<String> h = new HashSet<String>();
        File[] roots = local.getRoots();
        if (roots != null) {
            for (i = 0; i < roots.length; ++i) {
                displayName = local.getSystemDisplayName(roots[i]);
                if (h.contains(displayName) || displayName.length() == 0) continue;
                h.add(displayName);
                this.roots.put(displayName, roots[i]);
            }
        }
        if ((roots = File.listRoots()) != null) {
            for (i = 0; i < roots.length; ++i) {
                displayName = local.getSystemDisplayName(roots[i]);
                if (h.contains(displayName) || displayName.length() == 0) continue;
                h.add(displayName);
                this.roots.put(displayName, roots[i]);
            }
        }
        if (System.getProperty("os.name").toLowerCase(Locale.US).contains("linux") && (f = new File(p = System.getProperty("user.home"))).exists()) {
            File pa = null;
            while ((pa = f.getParentFile()) != null && pa.exists()) {
                this.roots.put(f.getAbsolutePath(), f);
                f = pa;
            }
        }
        String[] keys = new String[this.roots.size()];
        Iterator<String> it = this.roots.keySet().iterator();
        for (int i2 = 0; it.hasNext() && i2 < keys.length; ++i2) {
            keys[i2] = it.next();
        }
        return keys;
    }

    public String getShortRootName(String rootFolder) {
        if (rootFolder == null) {
            return null;
        }
        if (this.roots.containsKey(rootFolder = this.getRoot(rootFolder))) {
            return this.roots.get(rootFolder).getAbsolutePath();
        }
        return null;
    }

    public boolean isRoot() {
        if (local.isDrive(this.currentFile)) {
            return true;
        }
        File f = local.getParentDirectory(this.currentFile);
        return f == null;
    }

    protected void update() {
        int i;
        this.currentFiles.clear();
        File[] l = local.getFiles(this.currentFile, false);
        if (l != null) {
            for (i = 0; i < l.length; ++i) {
                String fn = local.getSystemDisplayName(l[i]);
                if (fn.length() == 0) continue;
                if (l[i].isDirectory()) {
                    try {
                        File tmpf = local.getChild(this.currentFile, fn);
                        if (tmpf == null || !local.isTraversable(tmpf).booleanValue()) continue;
                        local.getFiles(tmpf, false);
                    }
                    catch (Throwable t) {
                        continue;
                    }
                    this.currentFiles.add(new FileHandler(fn, l[i].lastModified(), -1L, l[i].canRead(), l[i].canWrite()));
                    continue;
                }
                if (!l[i].isFile()) continue;
                this.currentFiles.add(new FileHandler(fn, l[i].lastModified(), l[i].length(), l[i].canRead(), l[i].canWrite()));
            }
        }
        try {
            File f;
            i = 0;
            while ((f = new File(this.currentDir + System.getProperty("file.separator") + "fdt" + i)).exists()) {
            }
            f.createNewFile();
            this.canWrite = f.exists();
            if (this.canWrite) {
                f.delete();
            }
        }
        catch (Throwable t) {
            this.canWrite = false;
        }
    }

    public void process(Object o) throws Exception {
        if (!(o instanceof CtrlMsg)) {
            return;
        }
        CtrlMsg msg = (CtrlMsg)o;
        if (msg.tag != 11) {
            return;
        }
        GUIMessage m = (GUIMessage)msg.message;
        switch (m.getMID()) {
            case 0: {
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(0, new Object[]{this.getWorkingDirectory(), this.canWrite}));
                this.sendCtrlMessage(c);
                break;
            }
            case 1: {
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(1, this.getUserHome()));
                this.sendCtrlMessage(c);
                break;
            }
            case 2: {
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(2, this.getOSName()));
                this.sendCtrlMessage(c);
                break;
            }
            case 3: {
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(3, this.getFileList()));
                this.sendCtrlMessage(c);
                break;
            }
            case 4: {
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(4, this.getRoots()));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(9, this.formShortNames()));
                this.sendCtrlMessage(c);
                break;
            }
            case 6: {
                String dir = (String)m.getMsg();
                this.setAbsoluteDir(dir);
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(5, this.isRoot()));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(12, this.freeSpace()));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(0, new Object[]{this.getWorkingDirectory(), this.canWrite}));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(3, this.getFileList()));
                this.sendCtrlMessage(c);
                break;
            }
            case 7: {
                String dir = (String)m.getMsg();
                this.setRelativeDir(dir);
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(5, this.isRoot()));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(12, this.freeSpace()));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(0, new Object[]{this.getWorkingDirectory(), this.canWrite}));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(3, this.getFileList()));
                this.sendCtrlMessage(c);
                break;
            }
            case 8: {
                this.setUpDir();
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(5, this.isRoot()));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(12, this.freeSpace()));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(0, new Object[]{this.getWorkingDirectory(), this.canWrite}));
                this.sendCtrlMessage(c);
                c = new CtrlMsg(11, new GUIMessage(3, this.getFileList()));
                this.sendCtrlMessage(c);
                break;
            }
            case 10: {
                String[] files = (String[])m.getMsg();
                this.removeFiles(files);
                CtrlMsg c = new CtrlMsg(11, new GUIMessage(3, this.getFileList()));
                this.sendCtrlMessage(c);
                break;
            }
            case 11: {
                String name = (String)m.getMsg();
                CtrlMsg c = null;
                try {
                    this.createDir(name);
                    c = new CtrlMsg(11, new GUIMessage(3, this.getFileList()));
                }
                catch (Exception e) {
                    c = new CtrlMsg(11, new GUIMessage(3, this.getFileList(), e));
                }
                this.sendCtrlMessage(c);
                break;
            }
        }
    }

    public String getWorkingDirectory() {
        return this.currentDir;
    }

    public String getUserHome() {
        return this.userDir;
    }

    public String getOSName() {
        return this.osName;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public Vector<FileHandler> getFileList() {
        return this.currentFiles;
    }

    public void removeFiles(String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                File[] ff;
                File f = new File(files[i]);
                if (f.isDirectory() && (ff = f.listFiles()) != null) {
                    String[] str = new String[ff.length];
                    for (int j = 0; j < str.length; ++j) {
                        str[j] = ff[j].getAbsolutePath();
                    }
                    this.removeFiles(str);
                }
                f.delete();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.update();
    }

    public void createDir(String name) throws Exception {
        if (name == null) {
            return;
        }
        File f = new File(name);
        f.mkdirs();
        this.update();
    }

    private void initStreams() throws Exception {
        this.oos = new ObjectOutputStream(new BufferedOutputStream(this.controlSocket.getOutputStream()));
        this.sendMsgImpl(versionMsg);
        this.ois = new ObjectInputStream(new BufferedInputStream(this.controlSocket.getInputStream()));
        CtrlMsg ctrlMsg = (CtrlMsg)this.ois.readObject();
        if (ctrlMsg.tag != 1) {
            throw new FDTProcolException("Unexpected remote control message. Expected PROTOCOL_VERSION tag [ 1 ] Received tag: " + ctrlMsg.tag);
        }
        GUIMessage m = new GUIMessage(0, new Object[]{this.getWorkingDirectory(), this.canWrite});
        this.sendMsgImpl(m);
        m = new GUIMessage(1, this.getUserHome());
        this.sendMsgImpl(m);
        m = new GUIMessage(2, this.getOSName());
        this.sendMsgImpl(m);
        m = new GUIMessage(10, this.getFileSeparator());
        this.sendMsgImpl(m);
        m = new GUIMessage(5, this.isRoot());
        this.sendMsgImpl(m);
        m = new GUIMessage(12, this.freeSpace());
        this.sendMsgImpl(m);
        m = new GUIMessage(3, this.getFileList());
        this.sendMsgImpl(m);
        m = new GUIMessage(4, this.getRoots());
        this.sendMsgImpl(m);
        m = new GUIMessage(9, this.formShortNames());
        this.sendMsgImpl(m);
        m = new GUIMessage(11, "Init");
        this.sendMsgImpl(m);
    }

    private final HashMap<String, String> formShortNames() {
        this.h.clear();
        String[] roots = this.getRoots();
        if (roots == null) {
            return this.h;
        }
        for (int i = 0; i < roots.length; ++i) {
            this.h.put(roots[i], this.getShortRootName(roots[i]));
        }
        return this.h;
    }

    private final String freeSpace() {
        if (this.currentFile == null) {
            return null;
        }
        try {
            long space = this.currentFile.getFreeSpace();
            return this.parseSize(space);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private final String parseSize(long space) {
        if (space > 1024L) {
            if ((space /= 1024L) > 1024L) {
                if ((space /= 1024L) > 1024L) {
                    if ((space /= 1024L) > 1024L) {
                        return (space /= 1024L) + " TB";
                    }
                    return space + " GB";
                }
                return space + " MB";
            }
            return space + "KB";
        }
        return space + " B";
    }

    private void cleanup() {
        if (this.ois != null) {
            try {
                this.ois.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.ois = null;
        }
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.oos = null;
        }
        if (this.controlSocket != null) {
            try {
                this.controlSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.controlSocket = null;
        }
    }

    public void sendCtrlMessage(Object ctrlMsg) throws IOException, FDTProcolException {
        if (this.isClosed()) {
            throw new FDTProcolException("Control channel already closed");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "CtrlChannel Queuing for send: " + ctrlMsg.toString());
        }
        this.qToSend.add(ctrlMsg);
    }

    private void sendAllMsgs() throws Exception {
        Object ctrlMsg;
        while ((ctrlMsg = this.qToSend.poll()) != null) {
            this.sendMsgImpl(ctrlMsg);
        }
    }

    private void sendMsgImpl(Object o) throws Exception {
        try {
            this.oos.writeObject(o);
            this.oos.reset();
            this.oos.flush();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Got exception sending ctrl message", t);
            this.close("Exception sending control data", t);
            throw new IOException(" Cannot send ctrl message ( " + t.getCause() + " ) ");
        }
    }

    @Override
    public void run() {
        try {
            while (!this.isClosed()) {
                try {
                    this.sendAllMsgs();
                    Object o = this.ois.readObject();
                    if (o == null) continue;
                    this.process(o);
                }
                catch (SocketTimeoutException o) {
                }
                catch (FDTProcolException fdte) {
                    this.close("FDTProtocolException", fdte);
                }
            }
        }
        catch (Throwable t) {
            this.close(null, t);
        }
        this.close(this.downMessage(), this.downCause());
    }

    @Override
    protected void internalClose() {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

