/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport.internal;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.transport.FDTKeyAttachement;
import lia.util.net.copy.transport.internal.FDTSelectionKey;
import lia.util.net.copy.transport.internal.SelectionHandler;

public class SelectionManager {
    private static final Logger logger = Logger.getLogger(SelectionManager.class.getName());
    private static final SelectionManager _thisInstance;
    final Map<Selector, SelectionTask> selTasksMap = new HashMap<Selector, SelectionTask>();
    private final BlockingQueue<Selector> selectorsQueue;

    private SelectionManager() throws IOException {
        int sNo = Config.getInstance().getNumberOfSelectors();
        this.selectorsQueue = new ArrayBlockingQueue<Selector>(sNo);
        for (int i = 0; i < sNo; ++i) {
            Selector sel = Selector.open();
            this.selectorsQueue.add(sel);
            SelectionTask st = new SelectionTask(sel);
            this.selTasksMap.put(sel, st);
        }
    }

    public static final SelectionManager getInstance() {
        return _thisInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewInterest(FDTSelectionKey fdtSelectionKey) {
        SelectionTask st = fdtSelectionKey.selectionTask;
        boolean bShouldWakeup = false;
        SelectionTask selectionTask = st;
        synchronized (selectionTask) {
            if (st.renewQueue.isEmpty() && st.newQueue.isEmpty()) {
                bShouldWakeup = true;
            }
            st.renewQueue.add(fdtSelectionKey);
        }
        if (bShouldWakeup) {
            st.selector.wakeup();
        }
    }

    public FDTSelectionKey register(SocketChannel channel, int interests, SelectionHandler selectionHandler) throws InterruptedException, IOException {
        return this.register(null, channel, interests, selectionHandler);
    }

    public FDTSelectionKey register(UUID fdtsessionID, SocketChannel channel, int interests, SelectionHandler selectionHandler) throws InterruptedException {
        return this.register(fdtsessionID, channel, interests, selectionHandler, null);
    }

    public FDTSelectionKey register(UUID fdtsessionID, SocketChannel channel, int interests, SelectionHandler selectionHandler, FDTKeyAttachement attach) throws InterruptedException {
        if (channel == null) {
            throw new NullPointerException("SocketChannel cannot be null");
        }
        if (selectionHandler == null) {
            throw new NullPointerException("SelectionHanfler cannot be null");
        }
        Selector sel = this.getAndRotateSelector();
        SelectionTask sTask = this.selTasksMap.get(sel);
        FDTSelectionKey fdtSelectionKey = new FDTSelectionKey(fdtsessionID, channel, interests, selectionHandler, attach, sel, sTask);
        return fdtSelectionKey;
    }

    public void stopIt() {
        try {
            for (Map.Entry<Selector, SelectionTask> entry : this.selTasksMap.entrySet()) {
                entry.getValue().stopIt();
                entry.getValue().selector.wakeup();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialKeyRegister(FDTSelectionKey fdtSelectionKey) {
        Selector sel = fdtSelectionKey.selector;
        SelectionTask st = fdtSelectionKey.selectionTask;
        boolean bShouldWakeup = false;
        SelectionTask selectionTask = st;
        synchronized (selectionTask) {
            if (st.renewQueue.isEmpty() && st.newQueue.isEmpty()) {
                bShouldWakeup = true;
            }
            st.newQueue.add(fdtSelectionKey);
        }
        if (bShouldWakeup) {
            sel.wakeup();
        }
    }

    private Selector getAndRotateSelector() throws InterruptedException {
        Selector sel = this.selectorsQueue.take();
        this.selectorsQueue.put(sel);
        return sel;
    }

    static {
        SelectionManager tmpSMgr = null;
        try {
            tmpSMgr = new SelectionManager();
            int i = 0;
            for (Map.Entry<Selector, SelectionTask> entry : tmpSMgr.selTasksMap.entrySet()) {
                Thread t = new Thread((Runnable)entry.getValue(), " [ SelectionManager ] Selection task ( " + i++ + " )");
                t.setDaemon(true);
                t.start();
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Got exception initializing SelectionManager. Cannot continue. Will stop", t);
            throw new RuntimeException("Cannot instantiate SelectionManager. Do you want to continue ( N/N )? ", t);
        }
        _thisInstance = tmpSMgr;
    }

    static final class SelectionTask
    implements Runnable {
        private final Selector selector;
        private final AtomicBoolean hasToRun;
        private final Deque<FDTSelectionKey> renewQueue = new ArrayDeque<FDTSelectionKey>();
        private final Deque<FDTSelectionKey> newQueue = new ArrayDeque<FDTSelectionKey>();

        SelectionTask(Selector selector) {
            this.hasToRun = new AtomicBoolean(false);
            if (selector == null) {
                throw new NullPointerException("Selector cannot be null in SelectionTask constructor");
            }
            if (!selector.isOpen()) {
                throw new IllegalArgumentException("Selector is not open in SelectionTask constructor");
            }
            this.selector = selector;
            this.hasToRun.set(true);
        }

        private void checkRenew() {
            Deque<FDTSelectionKey> l = this.renewQueue;
            if (l.isEmpty()) {
                return;
            }
            boolean finest = logger.isLoggable(Level.FINEST);
            while (!l.isEmpty()) {
                SelectionKey sk;
                FDTSelectionKey fdtSelectionKey = (FDTSelectionKey)l.remove();
                if (finest) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[ SelectionManager ] [ checkRenew ] for ").append(Utils.toStringSelectionKey(fdtSelectionKey));
                    logger.log(Level.FINEST, sb.toString());
                }
                if (!(sk = fdtSelectionKey.selectionKey).isValid()) {
                    fdtSelectionKey.cancel();
                    continue;
                }
                sk.interestOps(fdtSelectionKey.selectionKey.interestOps() | fdtSelectionKey.interests);
            }
        }

        private void checkNew() {
            Deque<FDTSelectionKey> l = this.newQueue;
            if (l.isEmpty()) {
                return;
            }
            boolean finest = logger.isLoggable(Level.FINEST);
            while (!l.isEmpty()) {
                try {
                    FDTSelectionKey fdtSelectionKey = (FDTSelectionKey)l.remove();
                    fdtSelectionKey.selectionKey = fdtSelectionKey.channel.register(this.selector, fdtSelectionKey.interests, fdtSelectionKey);
                    if (!finest) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("[ SelectionManager ] [ checkNew ] for ").append(Utils.toStringSelectionKey(fdtSelectionKey));
                    logger.log(Level.FINEST, sb.toString());
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, " [ SelectionManager ] [ checkNew ] got exception. Cause", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int count = 0;
            while (this.hasToRun.get()) {
                SelectionTask selectionTask = this;
                synchronized (selectionTask) {
                    this.checkRenew();
                    this.checkNew();
                }
                try {
                    count = this.selector.select();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, " [ SelectionManager ] [ SelectionTask ] IOException in selector.select(). Cause: ", ioe);
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, " [ SelectionManager ] [ SelectionTask ] Generic Exception in selector.select(). Cause: ", t);
                }
                if (count == 0) continue;
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey sk = it.next();
                    try {
                        it.remove();
                        FDTSelectionKey fdtSelectionKey = (FDTSelectionKey)sk.attachment();
                        if (!sk.isValid()) {
                            if (fdtSelectionKey == null) continue;
                            fdtSelectionKey.cancel();
                            continue;
                        }
                        if (fdtSelectionKey != null) {
                            sk.interestOps(sk.interestOps() & ~fdtSelectionKey.interests);
                            fdtSelectionKey.renewed.set(false);
                            fdtSelectionKey.handler.handleSelection(fdtSelectionKey);
                            continue;
                        }
                        logger.log(Level.WARNING, "\n\n fdtSelectionKey is null in selection loop for sk: " + sk + " channel: " + sk.channel() + ". The channle will be closed\n\n");
                        sk.cancel();
                        try {
                            sk.channel().close();
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, " [ SelectionManager ] [ SelectionTask ] Exception in main loop notifying FDTKeys to handlers. Cause: ", t);
                    }
                }
            }
            this.cancelAllKeys();
        }

        private void cancelAllKeys() {
            SelectionKey sk = null;
            FDTSelectionKey fsk = null;
            Iterator<SelectionKey> it = this.selector.keys().iterator();
            while (it.hasNext()) {
                try {
                    sk = it.next();
                    if (sk == null || (fsk = (FDTSelectionKey)sk.attachment()) == null) continue;
                    fsk.cancel();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public void stopIt() {
            if (this.hasToRun.compareAndSet(true, false)) {
                this.selector.wakeup();
            }
        }
    }
}

