/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.globus.ftp.DataSourceStream;
import org.globus.ftp.FTPClient;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;

class FTPPut {
    FTPPut() {
    }

    public static void main(String[] args) {
        FTPClient ftp = null;
        String hostname = "localhost";
        int port = 5555;
        String username = "anonymous";
        String password = "anonymous";
        try {
            ftp = new FTPClient(hostname, port);
        }
        catch (ServerException e) {
            System.out.println("Server exception: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("error instantiating FTP client: " + e.toString());
            System.exit(1);
        }
        File localFile = new File("/etc/passwd");
        String remoteDestination = "mypasswd";
        DataSourceStream source = null;
        try {
            source = new DataSourceStream(new FileInputStream(localFile));
        }
        catch (FileNotFoundException e) {
            System.out.println("could not access client source: " + e.toString());
            System.exit(1);
        }
        try {
            ftp.authorize(username, password);
        }
        catch (ServerException e) {
            System.out.println("Server exception authorizing: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("error authorizing: " + e.toString());
            System.exit(1);
        }
        try {
            ftp.put(remoteDestination, source, null);
        }
        catch (ServerException e) {
            System.out.println("Server exception putting file: " + e.getMessage());
            System.exit(1);
        }
        catch (ClientException e) {
            System.out.println("Client exception putting file: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("error putting file: " + e.toString());
            System.exit(1);
        }
        try {
            ftp.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

