/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.proxy;

import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.provider.simple.SimpleMemoryCertStoreParams;
import org.globus.gsi.provider.simple.SimpleMemoryKeyStoreLoadStoreParameter;
import org.globus.gsi.provider.simple.SimpleMemoryProvider;
import org.globus.gsi.provider.simple.SimpleMemorySigningPolicyStore;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.gsi.trustmanager.X509ProxyCertPathValidator;
import org.globus.gsi.util.CertificateUtil;
import org.globus.util.I18n;

public class ProxyPathValidator {
    private static I18n i18n;
    private static Log logger;
    private X509ProxyCertPathValidator validator = new X509ProxyCertPathValidator();
    private boolean rejectLimitedProxyCheck = false;
    private boolean limited = false;
    private X509Certificate identityCert = null;
    private Hashtable proxyPolicyHandlers = null;

    public boolean isLimited() {
        return this.limited;
    }

    public X509Certificate getIdentityCertificate() {
        return this.identityCert;
    }

    public String getIdentity() {
        return BouncyCastleUtil.getIdentity(this.identityCert);
    }

    public ProxyPolicyHandler removeProxyPolicyHandler(String id) {
        return id != null && this.proxyPolicyHandlers != null ? (ProxyPolicyHandler)this.proxyPolicyHandlers.remove(id) : null;
    }

    public ProxyPolicyHandler setProxyPolicyHandler(String id, ProxyPolicyHandler handler) {
        if (id == null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyPolicyId"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyPolicyHandler"));
        }
        if (this.proxyPolicyHandlers == null) {
            this.proxyPolicyHandlers = new Hashtable();
        }
        return this.proxyPolicyHandlers.put(id, handler);
    }

    public ProxyPolicyHandler getProxyPolicyHandler(String id) {
        return id != null && this.proxyPolicyHandlers != null ? (ProxyPolicyHandler)this.proxyPolicyHandlers.get(id) : null;
    }

    public void reset() {
        this.rejectLimitedProxyCheck = false;
        this.limited = false;
        this.identityCert = null;
    }

    public void setRejectLimitedProxyCheck(boolean rejectLimProxy) {
        this.rejectLimitedProxyCheck = rejectLimProxy;
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, null);
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts, CertificateRevocationLists crls) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, crls, null);
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts, CertificateRevocationLists crls, SigningPolicy[] signingPolicies) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, crls, signingPolicies, null);
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts, CertificateRevocationLists crls, SigningPolicy[] signingPolicies, Boolean enforceSigningPolicy) throws ProxyPathValidatorException {
        if (certPath == null) {
            throw new IllegalArgumentException(i18n.getMessage("certsNull"));
        }
        TrustedCertificates trustedCertificates = null;
        if (trustedCerts != null) {
            trustedCertificates = new TrustedCertificates(trustedCerts, signingPolicies);
        }
        this.validate(certPath, trustedCertificates, crls, enforceSigningPolicy);
    }

    protected void validate(X509Certificate[] certPath) throws ProxyPathValidatorException {
        this.validate(certPath, (TrustedCertificates)null, (CertificateRevocationLists)null);
    }

    protected void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, null);
    }

    protected void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts, CertificateRevocationLists crlsList) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, crlsList, null);
    }

    protected synchronized void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts, CertificateRevocationLists crlsList, Boolean enforceSigningPolicy) throws ProxyPathValidatorException {
        if (certPath == null) {
            throw new IllegalArgumentException(i18n.getMessage("certsNull"));
        }
        if (crlsList == null) {
            crlsList = CertificateRevocationLists.getDefaultCertificateRevocationLists();
        }
        if (trustedCerts == null) {
            trustedCerts = TrustedCertificates.getDefault();
        }
        try {
            SimpleMemoryKeyStoreLoadStoreParameter ksParams = new SimpleMemoryKeyStoreLoadStoreParameter();
            SimpleMemoryCertStoreParams csParams = new SimpleMemoryCertStoreParams(null, crlsList.getCrls());
            ksParams.setCerts(trustedCerts.getCertificates());
            HashMap<String, ProxyPolicyHandler> initHandlers = new HashMap<String, ProxyPolicyHandler>();
            if (this.proxyPolicyHandlers != null) {
                initHandlers.putAll(this.proxyPolicyHandlers);
            }
            KeyStore ks = KeyStore.getInstance("SimpleMemoryKeyStore", "Simple");
            CertStore cs = CertStore.getInstance("SimpleMemoryCertStore", (CertStoreParameters)csParams, "Simple");
            SimpleMemorySigningPolicyStore spStore = new SimpleMemorySigningPolicyStore(trustedCerts.getSigningPolicies());
            ks.load(ksParams);
            X509ProxyCertPathParameters params = new X509ProxyCertPathParameters(ks, cs, spStore, this.rejectLimitedProxyCheck, initHandlers);
            this.validator.engineValidate(CertificateUtil.getCertPath(certPath), params);
            this.identityCert = this.validator.getIdentityCertificate();
            this.limited = this.validator.isLimited();
        }
        catch (Exception e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
    }

    protected synchronized void setValidator(X509ProxyCertPathValidator validator) {
        this.validator = validator;
    }

    static {
        Security.addProvider(new SimpleMemoryProvider());
        i18n = I18n.getI18n("org.globus.gsi.proxy.errors", ProxyPathValidator.class.getClassLoader());
        logger = LogFactory.getLog(ProxyPathValidator.class.getName());
    }
}

