/*
 * Decompiled with CFR 0.152.
 */
package org.lirc.socket;

import java.io.IOException;
import java.io.InputStream;
import org.lirc.socket.UnixSocketImpl;

class UnixSocketInputStream
extends InputStream {
    private UnixSocketImpl impl;

    public UnixSocketInputStream(UnixSocketImpl unixSocketImpl) {
        this.impl = unixSocketImpl;
    }

    public void close() throws IOException {
        this.impl.shutdownInput();
    }

    public int read() throws IOException {
        return UnixSocketInputStream.nativeRead(this.impl.getFd());
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        return UnixSocketInputStream.nativeRead(this.impl.getFd(), byArray, n, n2);
    }

    private static native int nativeRead(int var0) throws IOException;

    private static native int nativeRead(int var0, byte[] var1, int var2, int var3) throws IOException;
}

