/*
 * Decompiled with CFR 0.152.
 */
package org.lirc.socket;

import java.io.IOException;
import java.io.OutputStream;
import org.lirc.socket.UnixSocketImpl;

class UnixSocketOutputStream
extends OutputStream {
    private UnixSocketImpl impl;

    public UnixSocketOutputStream(UnixSocketImpl unixSocketImpl) {
        this.impl = unixSocketImpl;
    }

    public void close() throws IOException {
        this.impl.shutdownOutput();
    }

    public void write(int n) throws IOException {
        UnixSocketOutputStream.nativeWrite(this.impl.getFd(), n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        UnixSocketOutputStream.nativeWrite(this.impl.getFd(), byArray, n, n2);
    }

    private static native void nativeWrite(int var0, int var1) throws IOException;

    private static native void nativeWrite(int var0, byte[] var1, int var2, int var3) throws IOException;
}

