/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.builder;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opentsdb.client.builder.DataFormatException;
import org.opentsdb.client.util.Preconditions;

public class Metric {
    @SerializedName(value="metric")
    private String name;
    private long timestamp;
    private Object value;
    private Map<String, String> tags = new HashMap<String, String>();

    protected Metric(String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name);
    }

    public Metric addTag(String name, String value) {
        Preconditions.checkNotNullOrEmpty(name);
        Preconditions.checkNotNullOrEmpty(value);
        this.tags.put(name, value);
        return this;
    }

    public Metric addTags(Map<String, String> tags) {
        com.google.common.base.Preconditions.checkNotNull(tags);
        this.tags.putAll(tags);
        return this;
    }

    protected Metric innerAddDataPoint(long timestamp, Object value) {
        com.google.common.base.Preconditions.checkArgument(timestamp > 0L);
        this.timestamp = timestamp;
        this.value = com.google.common.base.Preconditions.checkNotNull(value);
        return this;
    }

    public Metric setDataPoint(long value) {
        return this.innerAddDataPoint(System.currentTimeMillis(), value);
    }

    public Metric setDataPoint(long timestamp, long value) {
        return this.innerAddDataPoint(timestamp, value);
    }

    public Metric setDataPoint(long timestamp, double value) {
        return this.innerAddDataPoint(timestamp, value);
    }

    public Metric setDataPoint(double value) {
        return this.innerAddDataPoint(System.currentTimeMillis(), value);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public String stringValue() throws DataFormatException {
        return this.value.toString();
    }

    public long longValue() throws DataFormatException {
        try {
            return ((Number)this.value).longValue();
        }
        catch (Exception e) {
            throw new DataFormatException("Value is not a long");
        }
    }

    public double doubleValue() throws DataFormatException {
        try {
            return ((Number)this.value).doubleValue();
        }
        catch (Exception e) {
            throw new DataFormatException("Value is not a double");
        }
    }

    public boolean isDoubleValue() {
        return ((Number)this.value).doubleValue() != Math.floor(((Number)this.value).doubleValue());
    }

    public boolean isIntegerValue() {
        return ((Number)this.value).doubleValue() == Math.floor(((Number)this.value).doubleValue());
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }
}

