/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.builder;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opentsdb.client.builder.Metric;

public class MetricBuilder {
    private List<Metric> metrics = new ArrayList<Metric>();
    private transient Gson mapper;

    private MetricBuilder() {
        GsonBuilder builder = new GsonBuilder();
        this.mapper = builder.create();
    }

    public static MetricBuilder getInstance() {
        return new MetricBuilder();
    }

    public Metric addMetric(String metricName) {
        Metric metric = new Metric(metricName);
        this.metrics.add(metric);
        return metric;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public String build() throws IOException {
        for (Metric metric : this.metrics) {
            Preconditions.checkState(metric.getTags().size() > 0, metric.getName() + " must contain at least one tag.");
        }
        return this.mapper.toJson(this.metrics);
    }
}

