/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rl.esc.browser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.encoders.Base64;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.util.PEMUtils;

class IECertificateInterface
extends Provider {
    private static boolean loaded = false;

    public static boolean init() {
        if (!loaded) {
            File file;
            block9: {
                try {
                    String tmpdir = System.getProperty("java.io.tmpdir");
                    file = new File(tmpdir, "JavaCertDLL.dll");
                    if (file == null) {
                        // empty if block
                    }
                    if (file == null) {
                        // empty if block
                    }
                    if (file.exists()) {
                        file.delete();
                    }
                    if (!file.exists() && file.createNewFile()) {
                        int ch;
                        String libname = "JavaCertDLL.dll";
                        BufferedInputStream libstream = new BufferedInputStream(IECertificateInterface.class.getResource(libname).openStream());
                        BufferedOutputStream o = new BufferedOutputStream(new FileOutputStream(file));
                        while ((ch = ((InputStream)libstream).read()) != -1) {
                            ((OutputStream)o).write(ch);
                        }
                        ((OutputStream)o).close();
                        ((InputStream)libstream).close();
                    }
                    if (file.exists()) break block9;
                    return false;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
            }
            System.load(file.getAbsolutePath());
            loaded = true;
            return true;
        }
        return true;
    }

    public static native String[] listDNS() throws IOException;

    public static native byte[] signData(String var0, byte[] var1, String var2) throws IOException;

    public static native byte[] getCertificate(String var0) throws IOException;

    public static native byte[] getPKCS12(String var0, char[] var1) throws IOException;

    public static native void importPKCS12(byte[] var0, char[] var1) throws IOException;

    public static native void importX509(byte[] var0) throws IOException;

    public static native void importCA(byte[] var0) throws IOException;

    public static native void importROOT(byte[] var0) throws IOException;

    public static X509Certificate getX509Certificate(String DN) throws IOException, GeneralSecurityException {
        byte[] c = IECertificateInterface.getCertificate(DN);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c), "-----END CERTIFICATE-----");
        return CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
    }

    private IECertificateInterface() {
        super("IE", 0.1, "SigningUsingIECertifcateKeys");
        this.putService(new IEService(this, "Signature", "MD4withRSA", "com.sshtools.j2ssh.authentication.IECertificateInterface.Signature"));
        this.putService(new IEService(this, "Signature", "MD5withRSA", "com.sshtools.j2ssh.authentication.IECertificateInterface.Signature"));
        this.putService(new IEService(this, "Signature", "SHA1withRSA", "com.sshtools.j2ssh.authentication.IECertificateInterface.Signature"));
    }

    public static PrivateKey getKey(String DN) {
        return new IEKey(DN);
    }

    public static Provider getProvider() {
        return new IECertificateInterface();
    }

    private static class IEKey
    implements PrivateKey {
        String DN;

        IEKey(String DN) {
            this.DN = DN;
        }

        @Override
        public byte[] getEncoded() {
            return null;
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public String getAlgorithm() {
            return "RSA";
        }
    }

    private static class IEService
    extends Provider.Service {
        String alg;

        public IEService(Provider p, String name, String alg, String classname) {
            super(p, name, alg, classname, null, null);
            this.alg = alg;
        }

        @Override
        public Object newInstance(Object e) {
            return new Signature(this.alg);
        }
    }

    private static class Signature
    extends SignatureSpi {
        String oid = null;
        String DN = null;
        byte[] buffer = null;
        int size = 0;
        int pointer = 0;
        String algorithm;

        private Signature() {
        }

        public Signature(String algorithm) {
            if (algorithm.equals("MD4withRSA")) {
                this.oid = "MD4";
            } else if (algorithm.equals("MD5withRSA")) {
                this.oid = "MD5";
            } else if (algorithm.equals("SHA1withRSA")) {
                this.oid = "SHA1";
            } else {
                throw new Error("Unknown Algorithm");
            }
            this.algorithm = algorithm;
        }

        @Override
        public void engineInitVerify(PublicKey e) throws InvalidKeyException {
            throw new InvalidKeyException("Verification Not Implemented");
        }

        private void resetBuffer() {
            this.size = 10240;
            this.buffer = new byte[this.size];
            this.pointer = 0;
        }

        @Override
        public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (!(privateKey instanceof IEKey)) {
                throw new InvalidKeyException("Key not stored in IE certificate store.");
            }
            this.DN = ((IEKey)privateKey).DN;
            this.resetBuffer();
        }

        private void check(int bytesToAdd) throws SignatureException {
            if (this.buffer == null) {
                throw new SignatureException("Signature not initialised!");
            }
            int remain = this.size - this.pointer;
            if (bytesToAdd > remain) {
                int newsize = 2 * this.size + bytesToAdd;
                byte[] newBuffer = new byte[newsize];
                if (this.pointer != 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.pointer);
                }
                this.size = newsize;
                this.buffer = newBuffer;
            }
        }

        @Override
        public void engineUpdate(byte b) throws SignatureException {
            this.check(1);
            this.buffer[this.pointer++] = b;
        }

        @Override
        public void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            this.check(len);
            System.arraycopy(b, off, this.buffer, this.pointer, len);
            this.pointer += len;
        }

        @Override
        public void engineUpdate(ByteBuffer input) {
            int remaining = input.remaining();
            try {
                this.check(remaining);
            }
            catch (SignatureException e) {
                throw new Error(e);
            }
            input.get(this.buffer, this.pointer, remaining);
            this.pointer += remaining;
        }

        @Override
        public byte[] engineSign() throws SignatureException {
            this.check(0);
            byte[] in = new byte[this.pointer];
            System.arraycopy(this.buffer, 0, in, 0, this.pointer);
            byte[] sig = null;
            try {
                sig = IECertificateInterface.signData(this.DN, in, this.oid);
            }
            catch (IOException e) {
                throw new SignatureException(e);
            }
            byte[] rev_sig = new byte[sig.length];
            int iii = 0;
            while (iii < sig.length) {
                rev_sig[iii] = sig[sig.length - iii - 1];
                ++iii;
            }
            this.resetBuffer();
            return rev_sig;
        }

        @Override
        public int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
            byte[] res = this.engineSign();
            if (len < res.length) {
                throw new SignatureException("No enough room in array for signature.");
            }
            System.arraycopy(res, 0, outbuf, offset, res.length);
            return res.length;
        }

        @Override
        public boolean engineVerify(byte[] sigBytes) throws SignatureException {
            throw new SignatureException("Verification not implemented.");
        }

        @Override
        public boolean engineVerify(byte[] sigBytes, int offset, int length) throws SignatureException {
            throw new SignatureException("Verification not implemented.");
        }

        @Override
        public void engineSetParameter(String param, Object value) throws InvalidParameterException {
            throw new InvalidParameterException();
        }

        @Override
        public Object engineGetParameter(String param) throws InvalidParameterException {
            throw new InvalidParameterException();
        }
    }
}

