/*
 * Decompiled with CFR 0.152.
 */
package apmon.host;

import apmon.host.Parser;
import apmon.host.cmdExec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MacHostPropertiesMonitor {
    protected static Object lock = new Object();
    protected static int ptnr = 0;
    protected String[] networkInterfaces;
    protected String activeInterface;
    protected String cpuUsage = "0";
    protected String cpuUSR = "0";
    protected String cpuSYS = "0";
    protected String cpuIDLE = "0";
    protected String nbProcesses = "0";
    protected String load1 = "0";
    protected String load5 = "0";
    protected String load15 = "0";
    protected String memUsed = "0";
    protected String memFree = "0";
    protected String memUsage = "0";
    protected String netIn = "0";
    protected String netOut = "0";
    protected String pagesIn = "0";
    protected String pagesOut = "0";
    protected String macAddress = "unknown";
    protected String diskIO = "0";
    protected String diskIn = "0";
    protected String diskOut = "0";
    protected String diskFree = "0";
    protected String diskUsed = "0";
    protected String diskTotal = "0";
    protected String command = "";
    protected cmdExec execute = null;
    protected String sep = null;
    protected Hashtable netSockets = null;
    protected Hashtable netTcpDetails = null;
    private Parser parser = new Parser();

    public MacHostPropertiesMonitor() {
        this.execute = new cmdExec();
        this.execute.setTimeout(3000L);
        this.sep = System.getProperty("file.separator");
        this.command = this.sep + "sbin" + this.sep + "ifconfig -l -u";
        String result = this.execute.executeCommand(this.command, "lo0");
        if (result == null || result.equals("")) {
            System.out.println(this.command + ": No result???");
        } else {
            int where = result.indexOf("lo0");
            this.networkInterfaces = result.substring(where + 3, result.length()).replaceAll("  ", " ").trim().split(" ");
            for (int i = 0; i < this.networkInterfaces.length; ++i) {
                String current = this.networkInterfaces[i];
                this.command = this.sep + "sbin" + this.sep + "ifconfig " + current;
                result = this.execute.executeCommand(this.command, current);
                if (result == null || result.equals("")) {
                    System.out.println(this.command + ": No result???");
                    continue;
                }
                if (result.indexOf("inet ") == -1) continue;
                int pointI = result.indexOf("ether");
                int pointJ = result.indexOf("media", pointI);
                this.macAddress = result.substring(pointI + 5, pointJ).trim();
                this.activeInterface = current;
            }
        }
        this.command = this.sep + "bin" + this.sep + "df -k -h " + this.sep;
        result = this.execute.executeCommand(this.command, "/dev");
        if (result == null || result.equals("")) {
            System.out.println(this.command + ": No result???");
        } else {
            this.parseDf(result);
        }
        this.update();
    }

    public String getMacAddresses() {
        return this.macAddress;
    }

    public void update() {
        if (this.execute == null) {
            this.execute = new cmdExec();
            this.execute.setTimeout(100000L);
        }
        this.command = this.sep + "usr" + this.sep + "bin" + this.sep + "top -d -l2 -n1 -F -R";
        String result = this.execute.executeCommand(this.command, "PID", 2);
        if (result == null || result.equals("")) {
            System.out.println("No result???");
        } else {
            this.parseTop(result);
        }
    }

    private void parseIfConfig(String toParse) {
        if (toParse.indexOf("inet ") != -1) {
            int pointI = toParse.indexOf("ether");
            int pointJ = toParse.indexOf("media", pointI);
            this.macAddress = toParse.substring(pointJ + 5, pointI).trim();
            System.out.println("Mac Address:" + this.macAddress);
        }
    }

    private void parseDf(String toParse) {
        int pointI = toParse.indexOf("/dev/");
        int pointJ = 0;
        int pointK = 0;
        try {
            pointJ = toParse.indexOf(" ", pointI);
            pointK = this.indexOfUnitLetter(toParse, pointJ);
            this.diskTotal = toParse.substring(pointJ, pointK).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointI = toParse.indexOf(" ", pointK);
            pointJ = this.indexOfUnitLetter(toParse, pointI);
            this.diskUsed = toParse.substring(pointI, pointJ).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointK = toParse.indexOf(" ", pointJ);
            pointI = this.indexOfUnitLetter(toParse, pointK);
            this.diskFree = toParse.substring(pointK, pointI).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private int indexOfUnitLetter(String inside, int from) {
        int temp = inside.indexOf(75, from);
        if (!(temp != -1 && temp - from <= 10 || (temp = inside.indexOf(77, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(71, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(66, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(84, from)) != -1 && temp - from <= 10 || (temp = inside.indexOf(98, from)) - from <= 10)) {
            temp = -1;
        }
        return temp;
    }

    private int lastIndexOfUnitLetter(String inside, int from) {
        int temp = inside.lastIndexOf(75, from);
        if (!(temp != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(77, from)) != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(71, from)) != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(66, from)) != -1 && from - temp <= 10 || (temp = inside.lastIndexOf(84, from)) != -1 && from - temp <= 10 || from - (temp = inside.lastIndexOf(98, from)) <= 10)) {
            temp = -1;
        }
        return temp;
    }

    private double howMuchKiloBytes(char a) {
        switch (a) {
            case 'T': {
                return 1.073741824E9;
            }
            case 'G': {
                return 1048576.0;
            }
            case 'M': {
                return 1024.0;
            }
            case 'K': {
                return 1.0;
            }
            case 'B': {
                return 9.765625E-4;
            }
        }
        return 1.0;
    }

    private double howMuchMegaBytes(char a) {
        switch (a) {
            case 'T': {
                return 1048576.0;
            }
            case 'G': {
                return 1024.0;
            }
            case 'M': {
                return 1.0;
            }
            case 'K': {
                return 9.765625E-4;
            }
            case 'B': {
                return 9.537E-7;
            }
        }
        return 1.0;
    }

    private void parseNetstat() {
        String output = this.execute.executeCommandReality("netstat -an", "");
        if (output != null && !output.equals("")) {
            this.parser.parse(output);
            String line = this.parser.nextLine();
            this.netSockets.put("tcp", new Integer(0));
            this.netSockets.put("udp", new Integer(0));
            this.netSockets.put("unix", new Integer(0));
            this.netSockets.put("icm", new Integer(0));
            this.netTcpDetails.put("ESTABLISHED", new Integer(0));
            this.netTcpDetails.put("SYN_SENT", new Integer(0));
            this.netTcpDetails.put("SYN_RECV", new Integer(0));
            this.netTcpDetails.put("FIN_WAIT1", new Integer(0));
            this.netTcpDetails.put("FIN_WAIT2", new Integer(0));
            this.netTcpDetails.put("TIME_WAIT", new Integer(0));
            this.netTcpDetails.put("CLOSED", new Integer(0));
            this.netTcpDetails.put("CLOSE_WAIT", new Integer(0));
            this.netTcpDetails.put("LAST_ACK", new Integer(0));
            this.netTcpDetails.put("LISTEN", new Integer(0));
            this.netTcpDetails.put("CLOSING", new Integer(0));
            this.netTcpDetails.put("UNKNOWN", new Integer(0));
            try {
                String key = null;
                int value = 0;
                while (line != null) {
                    if (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                        line = this.parser.nextLine();
                        continue;
                    }
                    if (line.startsWith("tcp")) {
                        key = "tcp";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                        StringTokenizer st = new StringTokenizer(line, " []");
                        while (st.hasMoreTokens()) {
                            String element;
                            key = element = st.nextToken();
                            if (!this.netTcpDetails.containsKey(element)) continue;
                            value = (Integer)this.netTcpDetails.get(key);
                            this.netTcpDetails.put(key, new Integer(++value));
                        }
                    }
                    if (line.startsWith("udp")) {
                        key = "udp";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                    }
                    if (line.startsWith("unix")) {
                        key = "unix";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                    }
                    if (line.startsWith("icm")) {
                        key = "icm";
                        value = (Integer)this.netSockets.get(key);
                        this.netSockets.put(key, new Integer(++value));
                    }
                    line = this.parser.nextLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void parseTop(String toParse) {
        int pointA = 0;
        int pointB = 0;
        int unitPos = 0;
        double sum = 0.0;
        try {
            pointA = toParse.indexOf("Procs:");
            pointA = toParse.indexOf("Procs:", pointA + 6) + 6;
            pointB = toParse.indexOf(",", pointA + 1);
            this.nbProcesses = toParse.substring(pointA, pointB).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointA = toParse.indexOf("LoadAvg:", pointA);
            pointB = toParse.indexOf(",", pointA += 9);
            this.load1 = toParse.substring(pointA, pointB).trim();
            pointA = toParse.indexOf(",", pointB + 1);
            this.load5 = toParse.substring(pointB + 1, pointA).trim();
            pointB = toParse.indexOf("CPU:", pointA + 1);
            pointB = toParse.lastIndexOf(".", pointB);
            this.load15 = toParse.substring(pointA + 1, pointB).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointB = toParse.indexOf("CPU:", pointB + 1) + 4;
            pointA = toParse.indexOf("% user", pointB);
            this.cpuUSR = toParse.substring(pointB, pointA).trim();
            pointA = toParse.indexOf(",", pointA);
            pointB = toParse.indexOf("% sys", pointA + 1);
            this.cpuSYS = toParse.substring(pointA + 1, pointB).trim();
            pointA = toParse.indexOf(",", pointB);
            pointB = toParse.indexOf("% idle", pointA + 1);
            this.cpuIDLE = toParse.substring(pointA + 1, pointB).trim();
            sum = 100.0 - Double.parseDouble(this.cpuIDLE);
            this.cpuUsage = String.valueOf(sum);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pointA = toParse.indexOf("PhysMem", pointB);
            pointB = toParse.indexOf("M used", pointA += 8);
            pointA = toParse.lastIndexOf(",", pointB);
            this.memUsed = toParse.substring(pointA + 1, pointB).trim();
            pointB = toParse.indexOf("M free", pointB);
            pointA = toParse.lastIndexOf(",", pointB);
            this.memFree = toParse.substring(pointA + 1, pointB).trim();
            sum = Double.parseDouble(this.memUsed) + Double.parseDouble(this.memFree);
            double percentage = (double)Integer.parseInt(this.memUsed) / sum * 100.0;
            this.memUsage = String.valueOf(percentage);
        }
        catch (StringIndexOutOfBoundsException percentage) {
            // empty catch block
        }
        try {
            pointA = toParse.indexOf("VirtMem:", pointB + 6);
            pointB = toParse.indexOf("pagein", pointA);
            pointA = toParse.lastIndexOf(",", pointB);
            this.pagesIn = toParse.substring(pointA + 1, pointB).trim();
            pointA = toParse.indexOf("pageout", pointB);
            pointB = toParse.lastIndexOf(",", pointA);
            this.pagesOut = toParse.substring(pointB + 1, pointA).trim();
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("Can't find pages in :" + toParse);
        }
        try {
            pointA = toParse.indexOf("Networks:", pointB) + 9;
            pointB = toParse.indexOf("data =", pointA) + 6;
            pointA = toParse.indexOf("in", pointB);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointA);
            this.netIn = toParse.substring(pointB, unitPos).trim();
            double factor = this.howMuchMegaBytes(toParse.substring(unitPos, unitPos + 1).toCharArray()[0]);
            this.netIn = String.valueOf(Double.parseDouble(this.netIn) * factor * 4.0);
            pointB = toParse.indexOf("out", pointA);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointB);
            factor = this.howMuchMegaBytes(toParse.substring(unitPos, unitPos + 1).toCharArray()[0]);
            this.netOut = toParse.substring(pointA + 3, unitPos).trim();
            this.netOut = String.valueOf(Double.parseDouble(this.netOut) * factor);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println(e);
        }
        try {
            pointB = toParse.indexOf("Disks:", pointA) + 6;
            pointA = toParse.indexOf("data =", pointB) + 6;
            pointB = toParse.indexOf("in,", pointA);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointB);
            this.diskIn = toParse.substring(pointA, unitPos).trim();
            pointA = toParse.indexOf("out", pointB);
            unitPos = this.lastIndexOfUnitLetter(toParse, pointA);
            this.diskIO = this.diskOut = toParse.substring(pointB + 3, unitPos).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Hashtable getProcessesState() {
        Hashtable<String, Integer> states = null;
        String output = this.execute.executeCommandReality("ps -e -A -o state", "");
        if (output != null && !output.equals("")) {
            this.parser.parse(output);
            String line = this.parser.nextLine();
            boolean nr = false;
            states = new Hashtable<String, Integer>();
            states.put("D", new Integer(0));
            states.put("R", new Integer(0));
            states.put("S", new Integer(0));
            states.put("T", new Integer(0));
            states.put("Z", new Integer(0));
            while (line != null) {
                if (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                    line = this.parser.nextLine();
                    continue;
                }
                Enumeration e = states.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!line.startsWith(key)) continue;
                    int x = (Integer)states.get(key);
                    states.put(key, new Integer(++x));
                }
                line = this.parser.nextLine();
            }
        }
        return states;
    }

    public String getCpuUsage() {
        return this.cpuUsage;
    }

    public String getCpuUSR() {
        return this.cpuUSR;
    }

    public String getCpuSYS() {
        return this.cpuSYS;
    }

    public String getCpuNICE() {
        return "0";
    }

    public String getCpuIDLE() {
        return this.cpuIDLE;
    }

    public String getPagesIn() {
        return this.pagesIn;
    }

    public String getPagesOut() {
        return this.pagesOut;
    }

    public String getMemUsage() {
        return this.memUsage;
    }

    public String getMemUsed() {
        return this.memUsed;
    }

    public String getMemFree() {
        return this.memFree;
    }

    public String getDiskIO() {
        return this.diskIO;
    }

    public String getDiskTotal() {
        return this.diskTotal;
    }

    public String getDiskUsed() {
        return this.diskUsed;
    }

    public String getDiskFree() {
        return this.diskFree;
    }

    public String getNoProcesses() {
        return this.nbProcesses;
    }

    public Hashtable getNetSockets() {
        return this.netSockets;
    }

    public Hashtable getTcpDetails() {
        return this.netTcpDetails;
    }

    public String getLoad1() {
        return this.load1;
    }

    public String getLoad5() {
        return this.load5;
    }

    public String getLoad15() {
        return this.load15;
    }

    public String[] getNetInterfaces() {
        return this.networkInterfaces;
    }

    public String getNetIn(String ifName) {
        if (ifName.equalsIgnoreCase(this.activeInterface)) {
            return this.netIn;
        }
        return "0";
    }

    public String getNetOut(String ifName) {
        if (ifName.equalsIgnoreCase(this.activeInterface)) {
            return this.netOut;
        }
        return "0";
    }
}

