/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.configuration;

import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.util.PropertyUtil;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SshToolsConnectionProfile
extends SshConnectionProperties {
    private static Log log = LogFactory.getLog(SshToolsConnectionProfile.class);
    public static final int DO_NOTHING = 1;
    public static final int START_SHELL = 2;
    public static final int EXECUTE_COMMANDS = 3;
    private Map applicationProperties = new HashMap();
    private Map sftpFavorites = new HashMap();
    private Map authMethods = new HashMap();
    private boolean requestPseudoTerminal = true;
    private boolean disconnectOnSessionClose = true;
    private int onceAuthenticated = 2;
    private String executeCommands = "";
    private boolean allowAgentForwarding = false;
    private String currentElement = null;
    private String currentAuthentication = null;
    private Properties currentProperties = null;
    private String connectionFile;

    public Map getAuthenticationMethods() {
        return this.authMethods;
    }

    public boolean requiresPseudoTerminal() {
        return this.requestPseudoTerminal;
    }

    public boolean disconnectOnSessionClose() {
        return this.disconnectOnSessionClose;
    }

    public void setRequiresPseudoTerminal(boolean requiresPseudoTerminal) {
        this.requestPseudoTerminal = requiresPseudoTerminal;
    }

    public void setDisconnectOnSessionClose(boolean disconnectOnSessionClose) {
        this.disconnectOnSessionClose = disconnectOnSessionClose;
    }

    public void clearAuthenticationCache() {
        for (SshAuthenticationClient auth : this.authMethods.values()) {
            Properties properties = auth.getPersistableProperties();
            auth.reset();
            auth.setPersistableProperties(properties);
        }
    }

    public void setOnceAuthenticatedCommand(int onceAuthenticated) {
        this.onceAuthenticated = onceAuthenticated;
    }

    public int getOnceAuthenticatedCommand() {
        return this.onceAuthenticated;
    }

    public void setCommandsToExecute(String executeCommands) {
        this.executeCommands = executeCommands;
    }

    public String getCommandsToExecute() {
        return this.executeCommands;
    }

    public String getApplicationProperty(String name, String defaultValue) {
        String value = (String)this.applicationProperties.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map getSftpFavorites() {
        return this.sftpFavorites;
    }

    public void setSftpFavorite(String name, String value) {
        this.sftpFavorites.put(name, value);
    }

    public int getApplicationPropertyInt(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.getApplicationProperty(name, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public boolean getApplicationPropertyBoolean(String name, boolean defaultValue) {
        try {
            return new Boolean(this.getApplicationProperty(name, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public Color getApplicationPropertyColor(String name, Color defaultColor) {
        return PropertyUtil.stringToColor(this.getApplicationProperty(name, PropertyUtil.colorToString(defaultColor)));
    }

    public void setApplicationProperty(String name, String value) {
        this.applicationProperties.put(name, value);
    }

    public void setApplicationProperty(String name, int value) {
        this.applicationProperties.put(name, String.valueOf(value));
    }

    public void setApplicationProperty(String name, boolean value) {
        this.applicationProperties.put(name, String.valueOf(value));
    }

    public void setApplicationProperty(String name, Color value) {
        this.applicationProperties.put(name, PropertyUtil.colorToString(value));
    }

    public Set getApplicationPropertyKeys() {
        return this.applicationProperties.keySet();
    }

    public void removeApplicationProperty(String key) {
        this.applicationProperties.remove(key);
    }

    public void addAuthenticationMethod(SshAuthenticationClient method) {
        if (method != null && !this.authMethods.containsKey(method.getMethodName())) {
            this.authMethods.put(method.getMethodName(), method);
        }
    }

    @Override
    public void addLocalForwarding(ForwardingConfiguration config) {
        if (config != null) {
            this.localForwardings.put(config.getName(), config);
        }
    }

    @Override
    public void addRemoteForwarding(ForwardingConfiguration config) {
        if (config != null) {
            this.remoteForwardings.put(config.getName(), config);
        }
    }

    public boolean getAllowAgentForwarding() {
        return this.allowAgentForwarding;
    }

    public void setAllowAgentForwarding(boolean allowAgentForwarding) {
        this.allowAgentForwarding = allowAgentForwarding;
    }

    public void removeLocalForwarding(String name) {
        this.localForwardings.remove(name);
    }

    public void removeRemoteForwarding(String name) {
        this.remoteForwardings.remove(name);
    }

    public void open(String file) throws InvalidProfileFileException {
        this.connectionFile = file;
        this.open(new File(file));
    }

    public void open(File file) throws InvalidProfileFileException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.open(in);
        }
        catch (FileNotFoundException fnfe) {
            try {
                throw new InvalidProfileFileException(file + " was not found!");
            }
            catch (Throwable throwable) {
                IOUtil.closeStream(in);
                throw throwable;
            }
        }
        IOUtil.closeStream(in);
    }

    public void open(InputStream in) throws InvalidProfileFileException {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLHandler handler = new XMLHandler();
            saxParser.parse(in, (DefaultHandler)handler);
            handler = null;
        }
        catch (IOException ioe) {
            throw new InvalidProfileFileException("IO error. " + ioe.getMessage());
        }
        catch (SAXException sax) {
            throw new InvalidProfileFileException("SAX Error: " + sax.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new InvalidProfileFileException("SAX Parser Error: " + pce.getMessage());
        }
    }

    public void removeAuthenticaitonMethod(String method) {
        this.authMethods.remove(method);
    }

    public void removeAuthenticationMethods() {
        this.authMethods.clear();
    }

    public void save(String file) throws InvalidProfileFileException {
        try {
            File f = new File(file);
            FileOutputStream out = new FileOutputStream(f);
            out.write(this.toString().getBytes());
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new InvalidProfileFileException(file + " was not found!");
        }
        catch (IOException ioe) {
            throw new InvalidProfileFileException("io error on " + file);
        }
    }

    public void save() throws InvalidProfileFileException {
        this.save(this.connectionFile);
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = xml + "<SshToolsConnectionProfile Hostname=\"" + this.host + "\" Port=\"" + String.valueOf(this.port) + "\" Username=\"" + this.username + "\"" + " PKCS12_Location=\"" + this.pkcs12_location + "\"" + " Provider=\"" + this.getTransportProviderString() + "\">";
        xml = xml + "   <PreferedCipher Client2Server=\"" + this.prefEncryption + "\" Server2Client=\"" + this.prefDecryption + "\"/>\n";
        xml = xml + "   <PreferedMac Client2Server=\"" + this.prefRecvMac + "\" Server2Client=\"" + this.prefSendMac + "\"/>\n";
        xml = xml + "   <PreferedCompression Client2Server=\"" + this.prefRecvComp + "\" Server2Client=\"" + this.prefSendComp + "\"/>\n";
        xml = xml + "   <PreferedPublicKey Name=\"" + this.prefPK + "\"/>\n";
        xml = xml + "   <PreferedKeyExchange Name=\"" + this.prefKex + "\"/>\n";
        xml = xml + "   <OnceAuthenticated value=\"" + String.valueOf(this.onceAuthenticated) + "\"/>\n";
        if (this.onceAuthenticated == 3) {
            xml = xml + "    <ExecuteCommands>" + this.executeCommands + "</ExecuteCommands>\n";
        }
        for (Map.Entry entry : this.authMethods.entrySet()) {
            xml = xml + "   <AuthenticationMethod Name=\"" + entry.getKey() + "\">\n";
            SshAuthenticationClient auth = (SshAuthenticationClient)entry.getValue();
            Properties properties = auth.getPersistableProperties();
            for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
                xml = xml + "      <AuthenticationProperty Name=\"" + entry2.getKey() + "\" Value=\"" + entry2.getValue() + "\"/>\n";
            }
            xml = xml + "   </AuthenticationMethod>\n";
        }
        for (Map.Entry entry : this.applicationProperties.entrySet()) {
            xml = xml + "   <ApplicationProperty Name=\"" + entry.getKey() + "\" Value=\"" + entry.getValue() + "\"/>\n";
        }
        for (Map.Entry entry : this.sftpFavorites.entrySet()) {
            xml = xml + "   <SftpFavorite Name=\"" + entry.getKey() + "\" Value=\"" + entry.getValue() + "\"/>\n";
        }
        Iterator it = this.localForwardings.values().iterator();
        xml = xml + "   <ForwardingAutoStart value=\"" + String.valueOf(this.forwardingAutoStart) + "\"/>\n";
        while (it.hasNext()) {
            ForwardingConfiguration config = (ForwardingConfiguration)((Object)it.next());
            xml = xml + "   <LocalPortForwarding Name=\"" + config.getName() + "\" AddressToBind=\"" + config.getAddressToBind() + "\" PortToBind=\"" + String.valueOf(config.getPortToBind()) + "\" AddressToConnect=\"" + config.getHostToConnect() + "\" PortToConnect=\"" + String.valueOf(config.getPortToConnect()) + "\"/>\n";
        }
        for (ForwardingConfiguration config : this.remoteForwardings.values()) {
            xml = xml + "   <RemotePortForwarding Name=\"" + config.getName() + "\" AddressToBind=\"" + config.getAddressToBind() + "\" PortToBind=\"" + String.valueOf(config.getPortToBind()) + "\" AddressToConnect=\"" + config.getHostToConnect() + "\" PortToConnect=\"" + String.valueOf(config.getPortToConnect()) + "\"/>\n";
        }
        xml = xml + "</SshToolsConnectionProfile>";
        return xml;
    }

    private class XMLHandler
    extends DefaultHandler {
        boolean commandsToExecute = false;

        private XMLHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
            if (SshToolsConnectionProfile.this.currentElement == null) {
                if (!qname.equals("SshToolsConnectionProfile")) {
                    throw new SAXException("Unexpected root element " + qname);
                }
                SshToolsConnectionProfile.this.host = attrs.getValue("Hostname");
                SshToolsConnectionProfile.this.username = attrs.getValue("Username");
                String p = attrs.getValue("Port");
                if (p == null) {
                    SshToolsConnectionProfile.this.port = 2222;
                } else {
                    SshToolsConnectionProfile.this.port = Integer.parseInt(p);
                }
                SshToolsConnectionProfile.this.pkcs12_location = attrs.getValue("PKCS12_Location");
                SshToolsConnectionProfile.this.setTransportProviderString(attrs.getValue("Provider"));
                if (SshToolsConnectionProfile.this.host == null || SshToolsConnectionProfile.this.username == null) {
                    throw new SAXException("Required attribute for element <SshToolsConnectionProfile> missing");
                }
            } else if (SshToolsConnectionProfile.this.currentElement.equals("SshToolsConnectionProfile")) {
                if (qname.equals("PreferedCipher")) {
                    String c2s = attrs.getValue("Client2Server");
                    String s2c = attrs.getValue("Server2Client");
                    if (c2s == null || s2c == null) {
                        throw new SAXException("Required attribute missing for <PreferedCipher> element");
                    }
                    SshToolsConnectionProfile.this.prefEncryption = c2s;
                    SshToolsConnectionProfile.this.prefDecryption = s2c;
                } else if (qname.equals("OnceAuthenticated")) {
                    if (attrs.getValue("value") != null) {
                        try {
                            SshToolsConnectionProfile.this.onceAuthenticated = Integer.parseInt(attrs.getValue("value"));
                        }
                        catch (NumberFormatException ex) {
                            SshToolsConnectionProfile.this.onceAuthenticated = 2;
                        }
                    }
                } else if (qname.equals("ExecuteCommands")) {
                    this.commandsToExecute = true;
                    SshToolsConnectionProfile.this.executeCommands = "";
                } else if (qname.equals("PreferedCompression")) {
                    String c2s = attrs.getValue("Client2Server");
                    String s2c = attrs.getValue("Server2Client");
                    if (c2s == null || s2c == null) {
                        throw new SAXException("Required attribute missing for <PreferedCompression> element");
                    }
                    SshToolsConnectionProfile.this.prefRecvComp = c2s;
                    SshToolsConnectionProfile.this.prefSendComp = s2c;
                } else if (qname.equals("PreferedMac")) {
                    String c2s = attrs.getValue("Client2Server");
                    String s2c = attrs.getValue("Server2Client");
                    if (c2s == null || s2c == null) {
                        throw new SAXException("Required attribute missing for <PreferedMac> element");
                    }
                    SshToolsConnectionProfile.this.prefRecvMac = c2s;
                    SshToolsConnectionProfile.this.prefSendMac = s2c;
                } else if (qname.equals("PreferedPublicKey")) {
                    String name = attrs.getValue("Name");
                    if (name == null) {
                        throw new SAXException("Required attribute missing for <PreferedPublickey> element");
                    }
                    SshToolsConnectionProfile.this.prefPK = name;
                } else if (qname.equals("PreferedKeyExchange")) {
                    String name = attrs.getValue("Name");
                    if (name == null) {
                        throw new SAXException("Required attribute missing for <PreferedKeyExchange> element");
                    }
                    SshToolsConnectionProfile.this.prefPK = name;
                } else if (qname.equals("ApplicationProperty")) {
                    String name = attrs.getValue("Name");
                    String value = attrs.getValue("Value");
                    if (name == null || value == null) {
                        throw new SAXException("Required attributes missing for <ApplicationProperty> element");
                    }
                    SshToolsConnectionProfile.this.applicationProperties.put(name, value);
                } else if (qname.equals("SftpFavorite")) {
                    String name = attrs.getValue("Name");
                    String value = attrs.getValue("Value");
                    if (name == null || value == null) {
                        throw new SAXException("Required attributes missing for <SftpFavorite> element");
                    }
                    SshToolsConnectionProfile.this.sftpFavorites.put(name, value);
                } else if (qname.equals("AuthenticationMethod")) {
                    SshToolsConnectionProfile.this.currentAuthentication = attrs.getValue("Name");
                    SshToolsConnectionProfile.this.currentProperties = new Properties();
                    if (SshToolsConnectionProfile.this.currentAuthentication == null) {
                        throw new SAXException("Required attribute missing for <AuthenticationMethod> element");
                    }
                } else if (qname.equals("LocalPortForwarding") || qname.equals("RemotePortForwarding")) {
                    String name = attrs.getValue("Name");
                    String addressToBind = attrs.getValue("AddressToBind");
                    String portToBind = attrs.getValue("PortToBind");
                    String addressToConnect = attrs.getValue("AddressToConnect");
                    String portToConnect = attrs.getValue("PortToConnect");
                    if (name == null || addressToBind == null || portToBind == null || addressToConnect == null || portToConnect == null) {
                        throw new SAXException("Required attribute missing for <" + qname + "> element");
                    }
                    ForwardingConfiguration config = new ForwardingConfiguration(name, addressToBind, Integer.parseInt(portToBind), addressToConnect, Integer.parseInt(portToConnect));
                    if (qname.equals("LocalPortForwarding")) {
                        SshToolsConnectionProfile.this.localForwardings.put(name, config);
                    } else {
                        SshToolsConnectionProfile.this.remoteForwardings.put(name, config);
                    }
                } else {
                    if (!qname.equals("ForwardingAutoStart")) throw new SAXException("Unexpected element <" + qname + "> after SshToolsConnectionProfile");
                    try {
                        SshToolsConnectionProfile.this.forwardingAutoStart = Boolean.valueOf(attrs.getValue("value"));
                    }
                    catch (Throwable ex1) {}
                }
            } else if (SshToolsConnectionProfile.this.currentElement.equals("AuthenticationMethod")) {
                if (!qname.equals("AuthenticationProperty")) throw new SAXException("Unexpected element <" + qname + "> found after AuthenticationMethod");
                String name = attrs.getValue("Name");
                String value = attrs.getValue("Value");
                if (name == null || value == null) {
                    throw new SAXException("Required attribute missing for <AuthenticationProperty> element");
                }
                SshToolsConnectionProfile.this.currentProperties.setProperty(name, value);
            }
            SshToolsConnectionProfile.this.currentElement = qname;
        }

        @Override
        public void characters(char[] ch, int pos, int len) {
            SshToolsConnectionProfile.this.executeCommands = SshToolsConnectionProfile.this.executeCommands + new String(ch, pos, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            if (SshToolsConnectionProfile.this.currentElement != null) {
                if (!SshToolsConnectionProfile.this.currentElement.equals(qname)) {
                    throw new SAXException("Unexpected end element found " + qname);
                }
                if (qname.equals("SshToolsConnectionProfile")) {
                    SshToolsConnectionProfile.this.currentElement = null;
                } else if (qname.startsWith("Prefered")) {
                    SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                } else if (qname.equals("OnceAuthenticated")) {
                    SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                } else if (qname.equals("ExecuteCommands")) {
                    SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                } else if (qname.equals("ApplicationProperty")) {
                    SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                } else if (qname.equals("SftpFavorite")) {
                    SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                } else if (qname.equals("AuthenticationProperty")) {
                    SshToolsConnectionProfile.this.currentElement = "AuthenticationMethod";
                } else if (qname.equals("LocalPortForwarding") || qname.equals("RemotePortForwarding") || qname.equals("ForwardingAutoStart")) {
                    SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                } else if (qname.equals("AuthenticationMethod")) {
                    SshToolsConnectionProfile.this.currentElement = "SshToolsConnectionProfile";
                    try {
                        SshAuthenticationClient auth = SshAuthenticationClientFactory.newInstance(SshToolsConnectionProfile.this.currentAuthentication, SshToolsConnectionProfile.this);
                        auth.setPersistableProperties(SshToolsConnectionProfile.this.currentProperties);
                        SshToolsConnectionProfile.this.authMethods.put(SshToolsConnectionProfile.this.currentAuthentication, auth);
                    }
                    catch (AlgorithmNotSupportedException anse) {
                        log.warn("AuthenticationMethod element ignored because '" + SshToolsConnectionProfile.this.currentAuthentication + "' authentication is not supported");
                    }
                    finally {
                        SshToolsConnectionProfile.this.currentAuthentication = null;
                    }
                } else {
                    throw new SAXException("Unexpected end element <" + qname + "> found");
                }
            }
        }
    }
}

