/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.globusonlinetool;

import com.sshtools.common.globusonlinetool.GOHelper;
import com.sshtools.common.globusonlinetool.myswingutils.TextAreaRenderer;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GOTaskPanel
extends JPanel
implements DocumentListener,
ActionListener {
    public JTable taskTable;
    private JScrollPane taskListScrollPane;
    private DefaultTableModel tableModel;
    private TableColumnModel colTableModel;
    private String[] columnNames = new String[]{"Task Id", "Description", "Creation", "Last Check", "Status"};

    public GOTaskPanel() {
        String val = ConfigurationLoader.checkAndGetProperty("user.home", null);
        File userPrefDir = null;
        if (val != null) {
            userPrefDir = new File(val + File.separator + ".sshterm");
        }
        if (userPrefDir != null) {
            PreferencesStore.init(new File(userPrefDir, "GSI-SSHTerm_for_PRACE_EGI_LRZ.properties"));
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        Insets normalInsets = new Insets(0, 2, 4, 2);
        Insets indentedInsets = new Insets(0, 26, 4, 2);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        this.setLayout(new BorderLayout());
        JPanel taskListPanel = new JPanel(new GridBagLayout());
        taskListPanel.setBorder(BorderFactory.createTitledBorder("Task Management"));
        gbc.insets = normalInsets;
        Object[][] data = GOHelper.getGOLogRecords();
        if (data != null) {
            this.tableModel = new DefaultTableModel();
            this.tableModel.setDataVector(data, this.columnNames);
            this.taskTable = new JTable(this.tableModel);
            this.taskTable.setModel(this.tableModel);
        } else {
            this.tableModel = new DefaultTableModel(0, this.columnNames.length);
            this.tableModel.setColumnIdentifiers(this.columnNames);
            this.taskTable = new JTable(this.tableModel);
            this.taskTable.setModel(this.tableModel);
        }
        this.taskTable.setAutoCreateRowSorter(true);
        this.taskTable.setRowHeight(20);
        this.taskTable.setAlignmentY(0.0f);
        this.colTableModel = this.taskTable.getColumnModel();
        TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
        TableColumn column = null;
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.colTableModel.getColumn(i).setCellRenderer(textAreaRenderer);
            column = this.taskTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(300);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(380);
                continue;
            }
            if (i == 2) {
                column.setPreferredWidth(160);
                continue;
            }
            if (i == 3) {
                column.setPreferredWidth(160);
                continue;
            }
            if (i != 4) continue;
            column.setPreferredWidth(100);
        }
        this.taskListScrollPane = new JScrollPane(this.taskTable);
        this.taskListScrollPane.setWheelScrollingEnabled(true);
        this.taskListScrollPane.setPreferredSize(new Dimension(1100, 200));
        UIUtil.jGridBagAdd(taskListPanel, this.taskListScrollPane, gbc, -1);
        this.add((Component)taskListPanel, "Center");
        Timer timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (GOHelper.updateTasksStatus() || GOHelper.isGOTaskTableToBeUpdated()) {
                        Object[][] data = GOHelper.getTasksObject();
                        if (data != null) {
                            GOTaskPanel.this.tableModel.setDataVector(data, GOTaskPanel.this.columnNames);
                            GOTaskPanel.this.colTableModel = GOTaskPanel.this.taskTable.getColumnModel();
                            TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
                            TableColumn column = null;
                            for (int i = 0; i < GOTaskPanel.this.columnNames.length; ++i) {
                                GOTaskPanel.this.colTableModel.getColumn(i).setCellRenderer(textAreaRenderer);
                                column = GOTaskPanel.this.taskTable.getColumnModel().getColumn(i);
                                if (i == 0) {
                                    column.setPreferredWidth(300);
                                    continue;
                                }
                                if (i == 1) {
                                    column.setPreferredWidth(380);
                                    continue;
                                }
                                if (i == 2) {
                                    column.setPreferredWidth(160);
                                    continue;
                                }
                                if (i == 3) {
                                    column.setPreferredWidth(160);
                                    continue;
                                }
                                if (i != 4) continue;
                                column.setPreferredWidth(100);
                            }
                        } else {
                            GOTaskPanel.this.tableModel.setColumnIdentifiers(GOTaskPanel.this.columnNames);
                            GOTaskPanel.this.taskTable = new JTable(GOTaskPanel.this.tableModel);
                            GOTaskPanel.this.taskTable.setColumnModel(GOTaskPanel.this.colTableModel);
                        }
                        if (GOHelper.isGOTaskTableToBeUpdated()) {
                            GOHelper.setGOTaskTableToBeUpdated(false);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        timer.setDelay(5000);
        timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }
}

