/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.globusonlinetool;

import com.sshtools.common.globusonlinetool.CredentialHelper;
import com.sshtools.common.globusonlinetool.GOHelper;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.ExampleFileFilter;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.globus.gsi.X509Credential;

public class SetupPanel {

    public static class GOSetupPanel
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JPanel createProxyCertPanel;
        private JButton browsePKCS12Cert;
        private JButton browseExistingProxyCert;
        private XTextField pkcs12cert;
        private XTextField existingProxyCert;
        private XTextField goUsername;
        private JComboBox certType;
        private JLabel certInfoLabel;
        private JLabel pkcs12CertLabel;
        private JLabel existingProxyCertLabel;
        private JLabel localPassphraseLabel;
        private JLabel certTypeLabel;
        private JLabel vomsLabel;
        private JCheckBox vomsSupport;
        private JPasswordField localPassphrase;
        private JPasswordField passphrase;
        private JPasswordField confirmPassphrase;
        private JPasswordField myproxyUploadedPassphrase;
        private JPanel myproxyPanel;
        private JLabel myproxyServerLabel;
        private JLabel myproxyServerPortLabel;
        private JLabel myproxyServerLifetimeLabel;
        private JLabel myproxyUsernameLabel;
        private JLabel myproxyPassphraseLabel;
        private XTextField myproxyUsername;
        private JComboBox myproxyServer;
        private NumericTextField myproxyPort;
        private NumericTextField myproxyLifetime;
        private JPanel optionalPanel;
        private JLabel autoProxyUploadLabel;
        private JCheckBox autoProxyUpload;
        private static int defaultLifetime = 168;
        private static Map myProxyInfoMap = null;
        private String[] infoText = new String[]{"Assumes the PEM certficates 'usercert.pem' and 'userkey.pem' are in {home.directory}/.globus directory.", "Assumes the lifetime of uploaded proxy is the same as the life of the existing local proxy certificate."};

        public GOSetupPanel() {
            String existingProxyCertStr = "";
            boolean proxyValid = false;
            if (CredentialHelper.getExistingProxyLocation() != null && (existingProxyCertStr = CredentialHelper.getExistingProxyLocation()) != null && !existingProxyCertStr.equals("")) {
                proxyValid = true;
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 17;
            Insets normalInsets = new Insets(0, 2, 4, 2);
            Insets indentedInsets = new Insets(0, 26, 4, 2);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            this.setLayout(new BorderLayout());
            this.createProxyCertPanel = new JPanel(new GridBagLayout());
            this.createProxyCertPanel.setBorder(BorderFactory.createTitledBorder("Login to Globus Online"));
            gbc.insets = indentedInsets;
            UIUtil.jGridBagAdd(this.createProxyCertPanel, new JLabel("GO Username:"), gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            String goUsernameStr = PreferencesStore.get("sshterm.go.username", "");
            this.goUsername = goUsernameStr != null ? new XTextField(goUsernameStr, 20) : new XTextField(20);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.goUsername, gbc, -1);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            this.certTypeLabel = new JLabel("Certificate");
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.certTypeLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.certType = new JComboBox<String>(new String[]{"Local PEM", "Local PKCS12", "Existing proxy", "Retrieve from MyProxy Server"});
            this.certType.addActionListener(this);
            this.certType.setFont(this.certType.getFont());
            this.certTypeLabel.setLabelFor(this.certType);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.certType, gbc, -1);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            gbc.weightx = 0.0;
            this.certInfoLabel = new JLabel(this.infoText[0]);
            this.certInfoLabel.setFont(new Font("Serif", 2, 14));
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.certInfoLabel, gbc, 0);
            String recordedPKCS12File = PreferencesStore.get("sshterm.pkcs12.defaults.file", "").trim().toLowerCase();
            String typicalPKCS12FIle = ConfigurationLoader.checkAndGetProperty("user.home", null) + File.separator + ".globus" + File.separator + "usercred.p12";
            gbc.insets = indentedInsets;
            this.pkcs12CertLabel = new JLabel("PKCS12 certificate location");
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.pkcs12CertLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            this.pkcs12cert = recordedPKCS12File != null && !recordedPKCS12File.equals("") ? new XTextField(recordedPKCS12File, 25) : (new File(typicalPKCS12FIle).exists() ? new XTextField(typicalPKCS12FIle, 25) : new XTextField(25));
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.pkcs12cert, gbc, -1);
            this.pkcs12CertLabel.setLabelFor(this.pkcs12cert);
            gbc.weightx = 0.0;
            this.browsePKCS12Cert = new JButton("Browse");
            this.browsePKCS12Cert.setMnemonic('b');
            this.browsePKCS12Cert.addActionListener(this);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.browsePKCS12Cert, gbc, 0);
            gbc.insets = indentedInsets;
            this.existingProxyCertLabel = new JLabel("Existing proxy location");
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.existingProxyCertLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            existingProxyCertStr = "";
            if (CredentialHelper.getExistingProxyLocation() != null) {
                existingProxyCertStr = CredentialHelper.getExistingProxyLocation();
            }
            this.existingProxyCert = new XTextField(existingProxyCertStr, 25);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.existingProxyCert, gbc, -1);
            this.existingProxyCertLabel.setLabelFor(this.existingProxyCert);
            gbc.weightx = 0.0;
            this.browseExistingProxyCert = new JButton("Browse");
            this.browseExistingProxyCert.setMnemonic('b');
            this.browseExistingProxyCert.addActionListener(this);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.browseExistingProxyCert, gbc, 0);
            gbc.insets = indentedInsets;
            this.localPassphraseLabel = new JLabel("Passphrase");
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.localPassphraseLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.localPassphrase = new JPasswordField(20);
            this.localPassphrase.setBackground(Color.white);
            this.localPassphrase.getDocument().addDocumentListener(this);
            this.localPassphraseLabel.setLabelFor(this.localPassphrase);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, this.localPassphrase, gbc, -1);
            UIUtil.jGridBagAdd(this.createProxyCertPanel, new JLabel(), gbc, 0);
            this.add((Component)this.createProxyCertPanel, "North");
            this.myproxyPanel = new JPanel(new GridBagLayout());
            this.myproxyPanel.setBorder(BorderFactory.createTitledBorder("MyProxy Server"));
            gbc.insets = indentedInsets;
            UIUtil.jGridBagAdd(this.myproxyPanel, new JLabel("MyProxy Server"), gbc, 1);
            String recordedMyproxyHostname = PreferencesStore.get("sshterm.myproxy.defaults.hostname", "").trim().toLowerCase();
            String[] myProxyHostNames = GOHelper.getMyProxyHostNames(recordedMyproxyHostname);
            this.myproxyServer = new JComboBox<String>(myProxyHostNames);
            this.myproxyServer.setEditable(true);
            this.myproxyServer.addActionListener(this);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyServer, gbc, -1);
            UIUtil.jGridBagAdd(this.myproxyPanel, new JLabel(), gbc, 0);
            int recordedMyproxyPort = 0;
            try {
                recordedMyproxyPort = Integer.getInteger(PreferencesStore.get("sshterm.myproxy.defaults.port", ""));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (recordedMyproxyPort == 0) {
                recordedMyproxyPort = 7512;
            }
            gbc.insets = indentedInsets;
            this.myproxyServerPortLabel = new JLabel("Port");
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyServerPortLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.myproxyPort = new NumericTextField(new Integer(1), new Integer(50000), (Number)recordedMyproxyPort);
            this.myproxyServerPortLabel.setLabelFor(this.myproxyPort);
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyPort, gbc, -1);
            UIUtil.jGridBagAdd(this.myproxyPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            this.myproxyServerLifetimeLabel = new JLabel("Lifetime (hours)");
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyServerLifetimeLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.myproxyLifetime = new NumericTextField(new Integer(0), new Integer(8760), new Integer(defaultLifetime));
            this.myproxyServerLifetimeLabel.setLabelFor(this.myproxyLifetime);
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyLifetime, gbc, -1);
            UIUtil.jGridBagAdd(this.myproxyPanel, new JLabel(""), gbc, 0);
            gbc.insets = indentedInsets;
            this.myproxyUsernameLabel = new JLabel("Username");
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyUsernameLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            String usernameStr = PreferencesStore.get("sshterm.myproxy.defaults.username", "");
            if (usernameStr == null || usernameStr.equals("")) {
                usernameStr = System.getProperty("user.name");
            }
            this.myproxyUsername = usernameStr != null ? new XTextField(usernameStr, 20) : new XTextField(20);
            this.myproxyUsernameLabel.setLabelFor(this.myproxyUsername);
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyUsername, gbc, -1);
            UIUtil.jGridBagAdd(this.myproxyPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            this.myproxyPassphraseLabel = new JLabel("Passphrase");
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyPassphraseLabel, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.myproxyUploadedPassphrase = new JPasswordField(20);
            this.myproxyUploadedPassphrase.setBackground(Color.white);
            this.myproxyUploadedPassphrase.getDocument().addDocumentListener(this);
            this.myproxyPassphraseLabel.setLabelFor(this.myproxyUploadedPassphrase);
            UIUtil.jGridBagAdd(this.myproxyPanel, this.myproxyUploadedPassphrase, gbc, -1);
            UIUtil.jGridBagAdd(this.myproxyPanel, new JLabel(), gbc, 0);
            this.add((Component)this.myproxyPanel, "Center");
            this.optionalPanel = new JPanel(new GridBagLayout());
            this.optionalPanel.setBorder(BorderFactory.createTitledBorder("Optional"));
            gbc.insets = indentedInsets;
            this.vomsSupport = new JCheckBox("  VOMS Enabled Proxy");
            UIUtil.jGridBagAdd(this.optionalPanel, this.vomsSupport, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            this.vomsLabel = new JLabel("");
            UIUtil.jGridBagAdd(this.optionalPanel, this.vomsLabel, gbc, 0);
            gbc.insets = indentedInsets;
            this.autoProxyUpload = new JCheckBox("  Upload credential to MyProxy server for Globus Online Endpoint activation");
            UIUtil.jGridBagAdd(this.optionalPanel, this.autoProxyUpload, gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            this.add((Component)this.optionalPanel, "South");
            this.triggerCertificateFormat("Local PEM");
        }

        public void triggerCertificateFormat(String certFormat) {
            this.localPassphrase.setText("");
            if (certFormat.equals("Local PEM")) {
                this.pkcs12CertLabel.setVisible(false);
                this.pkcs12cert.setVisible(false);
                this.browsePKCS12Cert.setVisible(false);
                this.existingProxyCertLabel.setVisible(false);
                this.existingProxyCert.setVisible(false);
                this.browseExistingProxyCert.setVisible(false);
                this.certInfoLabel.setVisible(true);
                this.certInfoLabel.setText(this.infoText[0]);
                this.localPassphraseLabel.setVisible(true);
                this.localPassphrase.setVisible(true);
                this.optionalPanel.setVisible(true);
                this.myproxyPanel.setVisible(false);
            } else if (certFormat.equals("Local PKCS12")) {
                this.pkcs12CertLabel.setVisible(true);
                this.pkcs12cert.setVisible(true);
                this.browsePKCS12Cert.setVisible(true);
                this.existingProxyCertLabel.setVisible(false);
                this.existingProxyCert.setVisible(false);
                this.browseExistingProxyCert.setVisible(false);
                this.certInfoLabel.setVisible(false);
                this.localPassphraseLabel.setVisible(true);
                this.localPassphrase.setVisible(true);
                this.optionalPanel.setVisible(true);
                this.myproxyPanel.setVisible(false);
            } else if (certFormat.equals("Existing proxy")) {
                this.pkcs12CertLabel.setVisible(false);
                this.pkcs12cert.setVisible(false);
                this.browsePKCS12Cert.setVisible(false);
                this.existingProxyCertLabel.setVisible(true);
                this.existingProxyCert.setVisible(true);
                this.browseExistingProxyCert.setVisible(true);
                this.certInfoLabel.setVisible(true);
                this.certInfoLabel.setText(this.infoText[1]);
                this.localPassphraseLabel.setVisible(false);
                this.localPassphrase.setVisible(false);
                this.optionalPanel.setVisible(true);
                this.myproxyPanel.setVisible(false);
                if (this.existingProxyCert.getText().trim().equals("") && CredentialHelper.getExistingProxyLocation() != null) {
                    this.existingProxyCert.setText(CredentialHelper.getExistingProxyLocation());
                }
            } else if (certFormat.equals("Retrieve from MyProxy Server")) {
                this.pkcs12CertLabel.setVisible(false);
                this.pkcs12cert.setVisible(false);
                this.browsePKCS12Cert.setVisible(false);
                this.existingProxyCertLabel.setVisible(false);
                this.existingProxyCert.setVisible(false);
                this.browseExistingProxyCert.setVisible(false);
                this.certInfoLabel.setVisible(false);
                this.localPassphraseLabel.setVisible(false);
                this.localPassphrase.setVisible(false);
                this.optionalPanel.setVisible(false);
                this.myproxyPanel.setVisible(true);
            }
        }

        public void triggerLocalCertificatePanel(boolean isEnabled) {
            this.createProxyCertPanel.setVisible(isEnabled);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser chooser;
            if (evt.getSource() == this.certType) {
                this.triggerCertificateFormat(this.getCertType());
            }
            if (evt.getSource() == this.browsePKCS12Cert) {
                chooser = new JFileChooser();
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("pfx");
                filter.addExtension("p12");
                filter.setDescription("pfx and p12 files");
                if (this.getPKCS12Cert() != null && !this.getPKCS12Cert().equals("")) {
                    chooser.setSelectedFile(new File(this.getPKCS12Cert()));
                }
                chooser.setFileFilter(filter);
                chooser.setFileHidingEnabled(false);
                chooser.setDialogTitle("Select PKCS12 Certificate File");
                if (chooser.showOpenDialog(this) == 0) {
                    this.pkcs12cert.setText(chooser.getSelectedFile().getPath());
                }
            }
            if (evt.getSource() == this.browseExistingProxyCert) {
                chooser = new JFileChooser();
                chooser.setFileHidingEnabled(false);
                if (this.getExistingProxyCert() != null && !this.getExistingProxyCert().equals("")) {
                    chooser.setSelectedFile(new File(this.getExistingProxyCert()));
                }
                chooser.setDialogTitle("Select Existing Proxy File");
                if (chooser.showOpenDialog(this) == 0) {
                    this.existingProxyCert.setText(chooser.getSelectedFile().getPath());
                    try {
                        X509Credential proxy = CredentialHelper.retrieveExistingProxy(this.getExistingProxyCert());
                        if (proxy != null) {
                            int timeleft = (int)proxy.getTimeLeft() / 3600;
                            this.myproxyLifetime.setValue(timeleft);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Globus Online Tool Error", 0);
                    }
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
        }

        public String getGOUsername() {
            return this.goUsername.getText().trim();
        }

        public int getMyProxyPort() {
            return (Integer)this.myproxyPort.getValue();
        }

        public String getMyProxyServer() {
            return (String)this.myproxyServer.getSelectedItem();
        }

        public int getMyProxyLifetime() {
            return (Integer)this.myproxyLifetime.getValue();
        }

        public String getMyProxyUsername() {
            return this.myproxyUsername.getText().trim();
        }

        public String getCertType() {
            return (String)this.certType.getSelectedItem();
        }

        public String getPKCS12Cert() {
            return this.pkcs12cert.getText();
        }

        public String getExistingProxyCert() {
            return this.existingProxyCert.getText();
        }

        public boolean getVOMSSupport() {
            return this.vomsSupport.isSelected();
        }

        public boolean getAutoProxyUpload() {
            return this.autoProxyUpload.isSelected();
        }

        public char[] getLocalPassphrase() {
            return this.localPassphrase.getPassword();
        }

        public char[] getUploadedMyProxyPassphrase() {
            return this.myproxyUploadedPassphrase.getPassword();
        }
    }
}

