/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.SshToolsApplicationApplet;
import com.sshtools.common.ui.SshToolsApplicationClientPanel;
import com.sshtools.common.util.PropertyUtil;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationClientApplet
extends SshToolsApplicationApplet {
    public static final String[][] CLIENT_PARAMETER_INFO = new String[][]{{"sshapps.connection.url", "string", "The URL of a connection profile to open"}, {"sshapps.connection.host", "string", "The host to connect to"}, {"sshapps.connection.userName", "string", "The user to connect as"}, {"sshapps.connection.authenticationMethod", "string", "Authentication method. password,publickey etc."}, {"sshapps.connection.connectImmediately", "boolean", "Connect immediately."}, {"sshapps.connection.showConnectionDialog", "boolean", "Show connection dialog."}, {"sshapps.connection.disableHostKeyVerification", "boolean", "Disable the host key verification dialog."}};
    protected Log log = LogFactory.getLog(SshToolsApplicationClientApplet.class);
    private String connectionProfileLocation;
    protected String authenticationMethod;
    protected String host;
    protected int port;
    protected String user;
    protected boolean connectImmediately;
    protected boolean showConnectionDialog;
    protected boolean disableHostKeyVerification;
    protected SshToolsConnectionProfile profile;

    @Override
    public void initApplet() throws IOException {
        super.initApplet();
        this.connectionProfileLocation = this.getParameter("sshapps.connectionProfile.url", "");
        this.host = this.getParameter("sshapps.connection.host", "");
        this.port = PropertyUtil.stringToInt(this.getParameter("sshapps.connection.port", ""), 2222);
        this.user = this.getParameter("sshapps.connection.userName", ConfigurationLoader.checkAndGetProperty("user.home", ""));
        this.authenticationMethod = this.getParameter("sshapps.connection.authenticationMethod", "");
        this.connectImmediately = this.getParameter("sshapps.connection.connectImmediately", "false").equalsIgnoreCase("true");
        this.showConnectionDialog = this.getParameter("sshapps.connection.showConnectionDialog", "false").equalsIgnoreCase("true");
        this.disableHostKeyVerification = this.getParameter("sshapps.connection.disableHostKeyVerification", "false").equalsIgnoreCase("true");
        this.buildProfile();
    }

    @Override
    public void startApplet() {
        if (this.disableHostKeyVerification) {
            ((SshToolsApplicationClientPanel)this.applicationPanel).setHostHostVerification(null);
            ((SshToolsApplicationClientPanel)this.applicationPanel).application.removeAdditionalOptionsTab("Hosts");
            this.log.debug("Host key verification disabled");
        } else {
            this.log.debug("Host key verification enabled");
        }
        if (this.connectImmediately) {
            this.loadingPanel.setStatus("Connecting");
            if (this.showConnectionDialog) {
                SshToolsConnectionProfile newProfile = ((SshToolsApplicationClientPanel)this.applicationPanel).newConnectionProfile(this.profile);
                if (newProfile != null) {
                    this.profile = newProfile;
                    ((SshToolsApplicationClientPanel)this.applicationPanel).connect(this.profile, true);
                }
            } else {
                ((SshToolsApplicationClientPanel)this.applicationPanel).connect(this.profile, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildProfile() throws IOException {
        this.profile = new SshToolsConnectionProfile();
        if (!this.connectionProfileLocation.equals("")) {
            this.log.info("Loading connection profile " + this.connectionProfileLocation);
            this.loadingPanel.setStatus("Loading connection profile");
            InputStream in = null;
            try {
                URL u = null;
                try {
                    u = new URL(this.connectionProfileLocation);
                }
                catch (MalformedURLException murle) {
                    u = new URL(this.getCodeBase() + "/" + this.connectionProfileLocation);
                }
                this.log.info("Full URL of connection profile is " + u);
                in = u.openStream();
                this.profile.open(in);
            }
            catch (Throwable throwable) {
                IOUtil.closeStream(in);
                throw throwable;
            }
            IOUtil.closeStream(in);
        }
        if (!this.host.equals("")) {
            this.log.info("Building connection profile from parameters ");
            this.log.debug("Setting host to " + this.host);
            this.profile.setHost(this.host);
            this.log.debug("Setting port to " + this.port);
            this.profile.setPort(this.port);
            this.log.debug("Setting username to " + this.user);
            this.profile.setUsername(this.user);
            if (!this.authenticationMethod.equals("")) {
                try {
                    this.log.debug("Adding authentication method " + this.authenticationMethod);
                    SshAuthenticationClient authClient = SshAuthenticationClientFactory.newInstance(this.authenticationMethod, this.profile);
                    this.profile.addAuthenticationMethod(authClient);
                }
                catch (Exception e) {
                    this.log.error("Could not add authentication method.", e);
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.applicationPanel.isConnected()) {
            ((SshToolsApplicationClientPanel)this.applicationPanel).closeConnection(true);
        }
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] s = super.getParameterInfo();
        String[][] p = new String[s.length + CLIENT_PARAMETER_INFO.length][];
        System.arraycopy(s, 0, p, 0, s.length);
        System.arraycopy(CLIENT_PARAMETER_INFO, 0, p, s.length, CLIENT_PARAMETER_INFO.length);
        return p;
    }

    public Component getWindow() {
        return this;
    }
}

