/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.vomanagementtool;

import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.common.vomanagementtool.common.VOHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExtraPanel {

    public static class NewVOPanel
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JPanel voPanel;
        private XTextField voName;
        private XTextField server;
        private NumericTextField port;
        private XTextField serverDN;
        private XTextField serverIssuerDN;
        private JButton ok;
        private JButton cancel;
        private boolean status = false;

        public NewVOPanel() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 17;
            Insets normalInsets = new Insets(0, 2, 4, 2);
            Insets indentedInsets = new Insets(0, 26, 4, 2);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            this.setLayout(new BorderLayout());
            this.voPanel = new JPanel(new GridBagLayout());
            this.voPanel.setBorder(BorderFactory.createTitledBorder("New VO"));
            gbc.insets = indentedInsets;
            UIUtil.jGridBagAdd(this.voPanel, new JLabel("VO name:"), gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.voName = new XTextField(20);
            UIUtil.jGridBagAdd(this.voPanel, this.voName, gbc, -1);
            UIUtil.jGridBagAdd(this.voPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            UIUtil.jGridBagAdd(this.voPanel, new JLabel("Server:"), gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            this.server = new XTextField(20);
            UIUtil.jGridBagAdd(this.voPanel, this.server, gbc, -1);
            UIUtil.jGridBagAdd(this.voPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            UIUtil.jGridBagAdd(this.voPanel, new JLabel("Port:"), gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.port = new NumericTextField(new Integer(0), new Integer(100000));
            UIUtil.jGridBagAdd(this.voPanel, this.port, gbc, -1);
            UIUtil.jGridBagAdd(this.voPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            UIUtil.jGridBagAdd(this.voPanel, new JLabel("Server DN:"), gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            this.serverDN = new XTextField(20);
            UIUtil.jGridBagAdd(this.voPanel, this.serverDN, gbc, -1);
            UIUtil.jGridBagAdd(this.voPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            gbc.weightx = 2.0;
            UIUtil.jGridBagAdd(this.voPanel, new JLabel("Server Certificate Issuer DN:"), gbc, 1);
            gbc.insets = normalInsets;
            this.serverIssuerDN = new XTextField(20);
            UIUtil.jGridBagAdd(this.voPanel, this.serverIssuerDN, gbc, -1);
            UIUtil.jGridBagAdd(this.voPanel, new JLabel(), gbc, 0);
            gbc.insets = indentedInsets;
            JLabel infoLabel = new JLabel("Please refer to your respective VO configuration webpage or contact your VO administrator for the above information.");
            infoLabel.setFont(new Font("Serif", 2, 14));
            UIUtil.jGridBagAdd(this.voPanel, infoLabel, gbc, 0);
            this.add((Component)this.voPanel, "South");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }

        public String getServerIssuerDN() {
            return this.serverIssuerDN.getText().trim();
        }

        public String getServerDN() {
            return this.serverDN.getText().trim();
        }

        public int getPort() {
            return (Integer)this.port.getValue();
        }

        public String getServer() {
            return this.server.getText().trim();
        }

        public String getVOName() {
            return this.voName.getText().trim();
        }

        public boolean isStatus() {
            return this.status;
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
        }
    }

    public static class VOMSLocationPanel
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JPanel vomsSetupPanel;
        private JButton browse;
        private XTextField vomslocation;

        public VOMSLocationPanel() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 17;
            Insets normalInsets = new Insets(0, 2, 4, 2);
            Insets indentedInsets = new Insets(0, 26, 4, 2);
            gbc.insets = normalInsets;
            gbc.weightx = 1.0;
            this.setLayout(new BorderLayout());
            this.vomsSetupPanel = new JPanel(new GridBagLayout());
            this.vomsSetupPanel.setBorder(BorderFactory.createTitledBorder("Preferred VOMS Location"));
            gbc.insets = indentedInsets;
            UIUtil.jGridBagAdd(this.vomsSetupPanel, new JLabel("VOMS Location:"), gbc, 1);
            gbc.insets = normalInsets;
            gbc.weightx = 2.0;
            String vomsDir = VOHelper.getVomslocation();
            this.vomslocation = new XTextField(vomsDir, 25);
            UIUtil.jGridBagAdd(this.vomsSetupPanel, this.vomslocation, gbc, -1);
            gbc.weightx = 0.0;
            this.browse = new JButton("Browse");
            this.browse.addActionListener(this);
            UIUtil.jGridBagAdd(this.vomsSetupPanel, this.browse, gbc, 0);
            gbc.insets = indentedInsets;
            gbc.weightx = 0.0;
            JLabel infoLabel = new JLabel("'vomsdir' dirctory will be at {VOMS Location}" + File.separator + "voms. 'vomses' directory will be at {VOMS Location}" + File.separator + "vomses.");
            infoLabel.setFont(new Font("Serif", 2, 14));
            UIUtil.jGridBagAdd(this.vomsSetupPanel, infoLabel, gbc, 0);
            this.add((Component)this.vomsSetupPanel, "South");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.browse) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileHidingEnabled(false);
                chooser.setFileSelectionMode(1);
                if (this.getVOMSLocation() != null && !this.getVOMSLocation().equals("")) {
                    chooser.setSelectedFile(new File(this.getVOMSLocation()));
                }
                chooser.setDialogTitle("Select VOMS location:");
                if (chooser.showOpenDialog(this) == 0) {
                    this.vomslocation.setText(chooser.getSelectedFile().getPath());
                }
            }
        }

        public String getVOMSLocation() {
            return this.vomslocation.getText().trim();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
        }
    }
}

