/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;

class SshAgentDeleteKey
extends SubsystemMessage {
    public static final int SSH_AGENT_DELETE_KEY = 207;
    SshPublicKey pubkey;
    String description;

    public SshAgentDeleteKey() {
        super(207);
    }

    public SshAgentDeleteKey(SshPublicKey pubkey, String description) {
        super(207);
        this.pubkey = pubkey;
        this.description = description;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENT_DELETE_KEY";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeBinaryString(this.pubkey.getEncoded());
            baw.writeString(this.description);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.pubkey = SshKeyPairFactory.decodePublicKey(bar.readBinaryString());
            this.description = bar.readString();
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }
}

