/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.GSSAPIKeyexAuthenticationClient;
import com.sshtools.j2ssh.authentication.GSSAuthenticationClient;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.io.FilePermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationClientFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    public static final String AUTH_HOSTBASED = "hostbased";
    public static final String AUTH_GSS = "gssapi-with-mic";
    public static final String AUTH_GSSAPIKEYEX = "gssapi-keyex";

    protected SshAuthenticationClientFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList list = new ArrayList(auths.keySet());
        return list;
    }

    public static SshAuthenticationClient newInstance(String methodName, SshConnectionProperties properties) throws AlgorithmNotSupportedException {
        try {
            SshAuthenticationClient n = (SshAuthenticationClient)((Class)auths.get(methodName)).newInstance();
            n.setProperties(properties);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlgorithmNotSupportedException(methodName + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog(SshAuthenticationClientFactory.class);
        auths = new HashMap();
        log.info("Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, PasswordAuthenticationClient.class);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            auths.put(AUTH_PK, PublicKeyAuthenticationClient.class);
        }
        catch (AccessControlException ace) {
            log.info("The security manager prevents use of Public Key Authentication on the client");
        }
        auths.put(AUTH_KBI, KBIAuthenticationClient.class);
        auths.put(AUTH_GSS, GSSAuthenticationClient.class);
        auths.put(AUTH_GSSAPIKEYEX, GSSAPIKeyexAuthenticationClient.class);
    }
}

