/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.IOException;
import java.io.OutputStream;

public class SftpFileOutputStream
extends OutputStream {
    SftpFile file;
    UnsignedInteger64 position = new UnsignedInteger64("0");

    public SftpFileOutputStream(SftpFile file) throws IOException {
        if (file.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (file.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.file = file;
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws IOException {
        int count;
        int max = (int)this.file.getSFTPSubsystem().maximumPacketSize();
        for (int pos = 0; pos < len; pos += count) {
            int available = (int)this.file.getSFTPSubsystem().availableWindowSpace() < max ? (int)this.file.getSFTPSubsystem().availableWindowSpace() : max;
            count = available < len - pos ? available : len - pos;
            this.file.getSFTPSubsystem().writeFile(this.file.getHandle(), this.position, buffer, offset + pos, count);
            this.position = UnsignedInteger64.add(this.position, count);
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.file.getSFTPSubsystem().writeFile(this.file.getHandle(), this.position, buffer, 0, 1);
        this.position = UnsignedInteger64.add(this.position, 1);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    protected void finalize() throws IOException {
        if (this.file.getHandle() != null) {
            this.close();
        }
    }
}

