/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.j2ssh.authentication.UserGridCredential;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshMsgKexGssComplete;
import com.sshtools.j2ssh.transport.kex.SshMsgKexGssContinue;
import com.sshtools.j2ssh.transport.kex.SshMsgKexGssError;
import com.sshtools.j2ssh.transport.kex.SshMsgKexGssHostKey;
import com.sshtools.j2ssh.transport.kex.SshMsgKexGssInit;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.util.Hash;
import edu.illinois.ncsa.BCGSS.BCGSSContextImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class GssGroup1Sha1
extends SshKeyExchange {
    private static Log log = LogFactory.getLog(GssGroup1Sha1.class);
    private static BigInteger g = new BigInteger("2");
    private static BigInteger p = new BigInteger(new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1});
    private BigInteger e = null;
    private BigInteger f = null;
    private BigInteger x = null;
    private BigInteger y = null;
    private String clientId;
    private String serverId;
    private byte[] clientKexInit;
    private byte[] serverKexInit;
    private KeyPairGenerator dhKeyPairGen;
    private KeyAgreement dhKeyAgreement;
    private GSSCredential theCredential = null;

    @Override
    protected void onInit() throws IOException {
        try {
            this.dhKeyPairGen = KeyPairGenerator.getInstance("DH");
            this.dhKeyAgreement = KeyAgreement.getInstance("DH");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AlgorithmNotSupportedException(ex.getMessage());
        }
    }

    @Override
    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, boolean firstPacketFollows, boolean useFirstPacket, boolean firstExch) throws IOException {
        try {
            SshMsgKexGssComplete reply;
            log.info("Starting client side key exchange.");
            this.transport.getMessageStore().registerMessage(30, SshMsgKexGssInit.class);
            this.transport.getMessageStore().registerMessage(31, SshMsgKexGssContinue.class);
            this.transport.getMessageStore().registerMessage(32, SshMsgKexGssComplete.class);
            this.transport.getMessageStore().registerMessage(33, SshMsgKexGssHostKey.class);
            this.transport.getMessageStore().registerMessage(34, SshMsgKexGssError.class);
            this.clientId = clientId;
            this.serverId = serverId;
            this.clientKexInit = clientKexInit;
            this.serverKexInit = serverKexInit;
            try {
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, g);
                this.dhKeyPairGen.initialize(dhSkipParamSpec);
                KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                this.x = ((DHPrivateKey)dhKeyPair.getPrivate()).getX();
                this.e = ((DHPublicKey)dhKeyPair.getPublic()).getY();
            }
            catch (InvalidKeyException ex) {
                throw new AlgorithmOperationException("Failed to generate DH value");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new AlgorithmOperationException("Failed to generate DH value");
            }
            log.info("Generating shared context with server...");
            GSSCredential gsscredential = null;
            HostAuthorization gssAuth = new HostAuthorization(null);
            GSSName targetName = gssAuth.getExpectedName(null, this.hostname);
            BCGSSContextImpl gsscontext = null;
            if (this.theCredential == null) {
                this.theCredential = gsscredential = UserGridCredential.getUserCredential(this.properties);
            } else {
                gsscredential = this.theCredential;
                try {
                    ((GlobusGSSCredentialImpl)gsscredential).getX509Credential().verify();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                catch (CredentialException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.properties.getWindow(), "The credentials that you authenticated with have expired, please re-authenticate.", "GSI-SSH Terminal", 2);
                    this.theCredential = gsscredential = UserGridCredential.getUserCredential(this.properties);
                }
            }
            gsscontext = new BCGSSContextImpl(targetName, (GlobusGSSCredentialImpl)gsscredential);
            gsscontext.requestLifetime(0);
            gsscontext.requestCredDeleg(true);
            gsscontext.requestMutualAuth(true);
            gsscontext.requestInteg(true);
            Integer type = GSIConstants.DELEGATION_TYPE_LIMITED;
            String cur = "None";
            if (this.properties instanceof SshToolsConnectionProfile) {
                cur = ((SshToolsConnectionProfile)this.properties).getApplicationProperty("sshterm.delegationType", "Full");
                if (cur.equals("full")) {
                    type = GSIConstants.DELEGATION_TYPE_FULL;
                } else if (cur.equals("limited")) {
                    type = GSIConstants.DELEGATION_TYPE_LIMITED;
                } else if (cur.equals("none")) {
                    type = GSIConstants.DELEGATION_TYPE_LIMITED;
                    gsscontext.requestCredDeleg(false);
                }
            }
            log.debug("Enabling delegation setting: " + cur);
            ((ExtendedGSSContext)gsscontext).setOption(GSSConstants.DELEGATION_TYPE, type);
            log.debug("Starting GSS token exchange.");
            byte[] abyte2 = new byte[]{};
            Object obj = null;
            boolean firsttime = true;
            this.hostKey = null;
            while (!gsscontext.isEstablished()) {
                byte[] abyte3 = gsscontext.initSecContext(abyte2, 0, abyte2.length);
                int count = 0;
                while (abyte3 == null && count < 2) {
                    try {
                        Thread.sleep(3000L);
                        abyte3 = gsscontext.initSecContext(abyte2, 0, abyte2.length);
                        ++count;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (gsscontext.isEstablished() && !gsscontext.getMutualAuthState()) {
                    throw new KeyExchangeException("Context established without mutual authentication in gss-group1-sha1-* key exchange.");
                }
                if (gsscontext.isEstablished() && !gsscontext.getIntegState()) {
                    throw new KeyExchangeException("Context established without integrety protection in gss-group1-sha1-* key exchange.");
                }
                if (abyte3 != null) {
                    SshMessage msg;
                    if (firsttime) {
                        msg = new SshMsgKexGssInit(this.e, abyte3);
                        this.transport.sendMessage(msg, this);
                    } else {
                        msg = new SshMsgKexGssContinue(abyte3);
                        this.transport.sendMessage(msg, this);
                    }
                } else {
                    throw new KeyExchangeException("Expecting a non-zero length token from GSS_Init_sec_context.");
                }
                if (!gsscontext.isEstablished()) {
                    SshMessage reply2;
                    int[] messageId = new int[]{33, 31, 34};
                    SshMessage msg = this.transport.readMessage(messageId);
                    if (msg.getMessageId() == 33) {
                        if (!firsttime) {
                            throw new KeyExchangeException("Not expecting a SSH_MSG_KEXGS_HOSTKEY message at this time.");
                        }
                        reply2 = (SshMsgKexGssHostKey)msg;
                        this.hostKey = ((SshMsgKexGssHostKey)reply2).getHostKey();
                        messageId = new int[]{31, 34};
                        msg = this.transport.readMessage(messageId);
                        if (msg.getMessageId() == 34) {
                            this.errormsg(msg);
                        }
                    } else if (msg.getMessageId() == 34) {
                        this.errormsg(msg);
                    }
                    reply2 = (SshMsgKexGssContinue)msg;
                    abyte2 = ((SshMsgKexGssContinue)reply2).getToken();
                }
                firsttime = false;
            }
            log.debug("Sending gssapi exchange complete.");
            int[] messageId = new int[]{32, 34};
            SshMessage msg = this.transport.readMessage(messageId);
            if (msg.getMessageId() == 34) {
                this.errormsg(msg);
            }
            if ((reply = (SshMsgKexGssComplete)msg).hasToken()) {
                ByteArrayReader bytearrayreader1 = new ByteArrayReader(reply.getToken());
                abyte2 = bytearrayreader1.readBinaryString();
                byte[] abyte3 = gsscontext.initSecContext(abyte2, 0, abyte2.length);
                if (abyte3 != null) {
                    throw new KeyExchangeException("Expecting zero length token.");
                }
                if (gsscontext.isEstablished() && !gsscontext.getMutualAuthState()) {
                    throw new KeyExchangeException("Context established without mutual authentication in gss-group1-sha1-* key exchange.");
                }
                if (gsscontext.isEstablished() && !gsscontext.getIntegState()) {
                    throw new KeyExchangeException("Context established without integrety protection in gss-group1-sha1-* key exchange.");
                }
            }
            byte[] per_msg_token = reply.getMIC();
            this.f = reply.getF();
            this.secret = this.f.modPow(this.x, p);
            this.calculateExchangeHash();
            gsscontext.verifyMIC(per_msg_token, 0, per_msg_token.length, this.exchangeHash, 0, this.exchangeHash.length, null);
            this.gssContext = gsscontext;
        }
        catch (GSSException g) {
            String desc = g.toString();
            if (desc.startsWith("GSSException: Failure unspecified at GSS-API level (Mechanism level: GSS Major Status: Authentication Failed") && desc.indexOf("an unknown error occurred") >= 0) {
                throw new KeyExchangeException("Error from GSS layer: \n Probably due to your proxy credential being expired or signed by a CA unknown by the server or your clock being set wrong.", g);
            }
            if (desc.indexOf("From Server") >= 0) {
                throw new KeyExchangeException("GSS Error from server", g);
            }
            throw new KeyExchangeException("Error from GSS layer", g);
        }
        catch (IOException e) {
            if (!e.getMessage().equals("Canceled by user.")) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void errormsg(SshMessage msg) throws GSSException {
        SshMsgKexGssError m = (SshMsgKexGssError)msg;
        log.error("GSSAPI Error:");
        log.error("Major status: " + m.getMajor());
        log.error("Minor status: " + m.getMinor());
        log.error("Message: " + m.getMessage());
        throw new GSSException(m.getMajor(), m.getMinor(), "\nFrom Server:\n" + m.getMessage());
    }

    @Override
    public void performServerExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvKey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        throw new KeyExchangeException("gss-group1-sha1-* not yet implemented on server side.");
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        Hash hash;
        try {
            hash = new Hash("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        if (this.hostKey == null) {
            hash.putInt(0);
        } else {
            hash.putInt(this.hostKey.length);
            hash.putBytes(this.hostKey);
        }
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }
}

