/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssKeyPair;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaKeyPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyPairFactory {
    private static Map pks;
    private static String defaultAlgorithm;
    private static Log log;

    protected SshKeyPairFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeys() {
        return new ArrayList(pks.keySet());
    }

    public static SshKeyPair newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)pks.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!");
        }
    }

    public static boolean supportsKey(String algorithm) {
        return pks.containsKey(algorithm);
    }

    public static SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader bar = new ByteArrayReader(encoded);
            String algorithm = bar.readString();
            if (SshKeyPairFactory.supportsKey(algorithm)) {
                SshKeyPair pair = SshKeyPairFactory.newInstance(algorithm);
                return pair.decodePrivateKey(encoded);
            }
            throw new AlgorithmNotSupportedException(algorithm + " is not supported");
        }
        catch (IOException ioe) {
            throw new InvalidSshKeyException(ioe.getMessage());
        }
    }

    public static SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader bar = new ByteArrayReader(encoded);
            String algorithm = bar.readString();
            if (SshKeyPairFactory.supportsKey(algorithm)) {
                SshKeyPair pair = SshKeyPairFactory.newInstance(algorithm);
                return pair.decodePublicKey(encoded);
            }
            throw new AlgorithmNotSupportedException(algorithm + " is not supported");
        }
        catch (IOException ioe) {
            throw new InvalidSshKeyException(ioe.getMessage());
        }
    }

    static {
        log = LogFactory.getLog(SshKeyPairFactory.class);
        pks = new HashMap();
        log.info("Loading public key algorithms");
        pks.put("ssh-dss", SshDssKeyPair.class);
        pks.put("ssh-rsa", SshRsaKeyPair.class);
        defaultAlgorithm = "ssh-dss";
    }
}

