/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.sshterm.SshTerminalPanel;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FullScreenAction
extends StandardAction {
    protected static Log log = LogFactory.getLog(FullScreenAction.class);
    private static final String ACTION_COMMAND_KEY_FULL_SCREEN = "full-screen-command";
    private static final String NAME_FULL_SCREEN = "Full Screen";
    private static final String SMALL_ICON_FULL_SCREEN = "fullscreen.png";
    private static final String LARGE_ICON_FULL_SCREEN = "";
    private static final String SHORT_DESCRIPTION_FULL_SCREEN = "Toggle full screen";
    private static final String LONG_DESCRIPTION_FULL_SCREEN = "Toggle full screen mode";
    private static final int MNEMONIC_KEY_FULL_SCREEN = 102;
    private SshToolsApplication application;
    private SshToolsApplicationContainer container;

    public FullScreenAction(SshToolsApplication application, SshToolsApplicationContainer container) {
        this.application = application;
        this.container = container;
        this.putValue("Name", NAME_FULL_SCREEN);
        this.putValue("SmallIcon", this.getIcon(SMALL_ICON_FULL_SCREEN));
        this.putValue("LargeIcon", this.getIcon(LARGE_ICON_FULL_SCREEN));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Keyboard_Modifier));
        this.putValue("ShortDescription", SHORT_DESCRIPTION_FULL_SCREEN);
        this.putValue("LongDescription", LONG_DESCRIPTION_FULL_SCREEN);
        this.putValue("MnemonicKey", new Integer(102));
        this.putValue("ActionCommandKey", ACTION_COMMAND_KEY_FULL_SCREEN);
        this.putValue("onMenuBar", new Boolean(true));
        this.putValue("menuName", "View");
        this.putValue("menuItemGroup", new Integer(20));
        this.putValue("menuItemWeight", new Integer(20));
        this.putValue("onToolBar", new Boolean(true));
        this.putValue("toolBarGroup", new Integer(5));
        this.putValue("toolBarWeight", new Integer(30));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        SshTerminalPanel p;
        p.setFullScreenMode(!(p = (SshTerminalPanel)this.container.getApplicationPanel()).isFullScreenMode());
    }
}

