/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.sshvnc.SshVNCViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ClipboardFrame
extends JDialog
implements WindowListener,
ActionListener,
DocumentListener {
    JTextArea textArea;
    JButton clearButton;
    JButton closeButton;
    String selection;
    SshVNCViewer viewer;

    ClipboardFrame(Frame parent, SshVNCViewer v) {
        super(parent, "VNC Clipboard", false);
        this.init(v);
    }

    ClipboardFrame(Dialog parent, SshVNCViewer v) {
        super(parent, "VNC Clipboard", false);
        this.init(v);
    }

    ClipboardFrame(SshVNCViewer v) {
        super((Frame)null, "VNC Clipboard", false);
        this.init(v);
    }

    private void init(SshVNCViewer v) {
        this.viewer = v;
        JPanel b = new JPanel(new FlowLayout(2, 2, 2));
        b.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic('c');
        this.closeButton.addActionListener(this);
        this.closeButton.setDefaultCapable(true);
        b.add(this.closeButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.setMnemonic('l');
        this.clearButton.addActionListener(this);
        b.add(this.clearButton);
        JPanel t = new JPanel(new BorderLayout());
        this.textArea = new JTextArea(8, 30);
        this.textArea.getDocument().addDocumentListener(this);
        t.add((Component)new JScrollPane(this.textArea), "Center");
        IconWrapperPanel w = new IconWrapperPanel(new ResourceIcon("/com/sshtools/sshvnc/largeclipboard.png"), t);
        w.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)w, "Center");
        this.getContentPane().add((Component)b, "South");
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateClipboard();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateClipboard();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateClipboard();
    }

    private void updateClipboard() {
        if (this.selection != null && !this.selection.equals(this.textArea.getText())) {
            this.selection = this.textArea.getText();
            this.viewer.setCutText(this.selection);
        }
    }

    public void setCutText(String text) {
        this.selection = text;
        this.textArea.setText(text);
        if (this.isVisible()) {
            this.textArea.selectAll();
        }
    }

    public JButton getDefaultButton() {
        return this.closeButton;
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.clearButton) {
            this.textArea.setText("");
        } else if (evt.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }
}

