/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.authentication.KBIRequestHandlerDialog;
import com.sshtools.common.authentication.PasswordAuthenticationDialog;
import com.sshtools.common.authentication.PasswordChange;
import com.sshtools.common.authentication.PublicKeyAuthenticationPrompt;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.mru.MRUAction;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.mru.MRUMenu;
import com.sshtools.common.ui.CloseAction;
import com.sshtools.common.ui.ConnectionPropertiesAction;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.EditAction;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NewAction;
import com.sshtools.common.ui.OpenAction;
import com.sshtools.common.ui.RecordAction;
import com.sshtools.common.ui.RefreshAction;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SaveAction;
import com.sshtools.common.ui.SaveAsAction;
import com.sshtools.common.ui.SessionProvider;
import com.sshtools.common.ui.SessionProviderAction;
import com.sshtools.common.ui.SessionProviderFactory;
import com.sshtools.common.ui.SessionProviderFrame;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationClientPanel;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.StopAction;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingIOChannel;
import com.sshtools.j2ssh.forwarding.VNCDisplay;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import com.sshtools.sshterm.emulation.TerminalPanel;
import com.sshtools.sshvnc.ClipboardAction;
import com.sshtools.sshvnc.CtrlAltDelAction;
import com.sshtools.sshvnc.HexASCII;
import com.sshtools.sshvnc.SshVNC;
import com.sshtools.sshvnc.SshVNCOptions;
import com.sshtools.sshvnc.SshVNCViewer;
import com.sshtools.sshvnc.VNCAdvancedTab;
import com.sshtools.sshvnc.VNCTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshVNCPanel
extends SshToolsApplicationClientPanel
implements ActionListener {
    public static final String PROFILE_PROPERTY_VNC_HOST = "VNC_HOST";
    public static final String PROFILE_PROPERTY_VNC_DISPLAY = "VNC_DISPLAY";
    public static final String PROFILE_PRE_VNC_COMMAND = "PRE_VNC_COMMAND";
    public static final String PROFILE_POST_VNC_COMMAND = "POST_VNC_COMMAND";
    public static final String PROFILE_PROPERTY_PREFERRED_ENCODING = "PREFERRED_ENCODING";
    public static final String PROFILE_PROPERTY_USE_COPY_RECT = "USE_COPY_RECT";
    public static final String PROFILE_PROPERTY_COMPRESS_LEVEL = "COMPRESS_LEVEL";
    public static final String PROFILE_PROPERTY_JPEG_QUALITY = "JPEG_QUALITY";
    public static final String PROFILE_PROPERTY_CURSOR_UPDATES = "CURSOR_UPDATES";
    public static final String PROFILE_PROPERTY_EIGHT_BIT_COLORS = "EIGHT_BIT_COLORS";
    public static final String PROFILE_PROPERTY_REVERSE_MOUSE_BUTTONS_2_AND_3 = "REVERSE_MOUSE_BUTTONS_2_AND_3";
    public static final String PROFILE_PROPERTY_SHARE_DESKTOP = "SHARE_DESKTOP";
    public static final String PROFILE_PROPERTY_VIEW_ONLY = "VIEW_ONLY";
    public static final String PROFILE_PROPERTY_ENCRYPTED_VNC_PASSWORD = "ENCRYPTED_VNC_PASSWORD";
    public static final String PROFILE_PROPERTY_SSH_PASSWORD = "SSH_PASSWORD";
    public static final String PROFILE_PROPERTY_SCREEN_SIZE_POLICY = "VNC_SCREEN_SIZE";
    public static final String PROFILE_PROPERTY_VNC_SERVER_OS = "VNC_SERVER_OS";
    public static final int PROFILE_SCREEN_NO_CHANGE = 0;
    public static final int PROFILE_SCREEN_REMOTE_DESKTOP = 1;
    public static final int PROFILE_VNC_SERVER_OS_WINDOWSMAC = 0;
    public static final int PROFILE_VNC_SERVER_OS_LINUX = 1;
    private TerminalPanel terminal;
    protected TerminalEmulation emulation;
    private Vector sessionFrames = new Vector();
    private HashMap sessionActions = new HashMap();
    protected static Log log = LogFactory.getLog(SshVNC.class);
    private SshVNCViewer vnc;
    private StandardAction newAction;
    private StandardAction closeAction;
    private StandardAction refreshAction;
    private StandardAction clipboardAction;
    private StandardAction ctrlAltDelAction;
    private StandardAction recordAction;
    private StandardAction stopAction;
    private Thread rfbThread;
    private JFileChooser recordingFileChooser;
    private VNCTab vncTab;
    private StatusBar statusBar;
    private Timer sendTimer;
    private Timer receiveTimer;
    private ForwardingClient.ClientForwardingListener forwardingConfig;
    private SshToolsConnectionTab[] additionalTabs;
    private OpenAction openAction;
    private EditAction editAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private MRUActionImpl mruAction;
    private ConnectionPropertiesAction connectionPropertiesAction;
    private boolean closing = false;
    ForwardingIOChannel channel;
    private boolean fullScreenMode;
    public static final ResourceIcon SSHVNC_ICON = new ResourceIcon(SshVNCPanel.class, "sshvncframeicon.gif");
    private static boolean debug = true;

    @Override
    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        super.init(application);
        this.setLayout(new BorderLayout());
        this.sendTimer = new Timer(500, this);
        this.sendTimer.setRepeats(false);
        this.receiveTimer = new Timer(500, this);
        this.receiveTimer.setRepeats(false);
        this.statusBar = new StatusBar();
        this.statusBar.setUser("");
        this.statusBar.setHost("");
        this.statusBar.setStatusText("Disconnected");
        this.statusBar.setConnected(false);
        this.setLayout(new BorderLayout());
        try {
            this.emulation = this.createEmulation();
        }
        catch (IOException ioe) {
            throw new SshToolsApplicationException(ioe);
        }
        this.emulation.setBufferSize(1000);
        this.terminal = new TerminalPanel(this.emulation);
        this.terminal.requestFocus();
        try {
            this.vnc = new SshVNCViewer();
            this.additionalTabs = new SshToolsConnectionTab[]{new VNCTab(), new VNCAdvancedTab()};
            this.add((Component)this.vnc, "Center");
            this.initActions();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            IconWrapperPanel p = new IconWrapperPanel(UIManager.getIcon("OptionPane.errorIcon"), new ErrorTextBox((t.getMessage() == null ? "<no message supplied>" : t.getMessage()) + (debug ? "\n\n" + sw.getBuffer().toString() : "")));
            p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.add((Component)p, "Center");
            throw new SshToolsApplicationException("Failed to start SshVNC. ", t);
        }
    }

    @Override
    public ResourceIcon getIcon() {
        return SSHVNC_ICON;
    }

    @Override
    public boolean postConnection() {
        return true;
    }

    @Override
    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.additionalTabs;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.receiveTimer) {
            this.statusBar.setReceiving(false);
        } else if (evt.getSource() == this.sendTimer) {
            this.statusBar.setSending(false);
        }
        if (this.sessionActions.containsKey(evt.getActionCommand())) {
            SessionProviderAction action = (SessionProviderAction)this.sessionActions.get(evt.getActionCommand());
            for (SessionProviderFrame frame : this.sessionFrames) {
                if (!action.getProvider().getProviderClass().isInstance(frame)) continue;
                frame.show();
                return;
            }
            try {
                SessionProviderFrame frame;
                frame = new SessionProviderFrame(this.getCurrentConnectionProfile(), this.ssh, action.getProvider());
                if (frame.initFrame(this.getApplication())) {
                    frame.show();
                    this.sessionFrames.add(frame);
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    public void setFrameResizeable(boolean frameResizeable) {
        this.vnc.setFrameResizeable(frameResizeable);
    }

    @Override
    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public JToolBar getToolBar() {
        return this.toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVNC(InputStream in, OutputStream out, SshVNCOptions options) {
        log.info("Initialising VNC");
        try {
            this.vnc.init(in, out, this, options);
        }
        catch (EOFException e) {
            if (this.isConnected() && !this.closing) {
                SshVNCPanel.showErrorMessage(this, "The server closed the connection.", "Error", null);
            }
        }
        catch (Exception e) {
            if (this.isConnected() && !this.closing) {
                SshVNCPanel.showErrorMessage(this, "Error", e);
            }
        }
    }

    public void closeVNC() {
        this.vnc.closeConnection();
        this.setAvailableActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeConnection(boolean doDisconnect) {
        this.statusBar.setStatusText("Closing VNC");
        Iterator it = this.sessionFrames.iterator();
        while (it.hasNext()) {
            try {
                SessionProviderFrame browserFrame = (SessionProviderFrame)it.next();
                browserFrame.exit();
                browserFrame.dispose();
            }
            catch (Throwable ex) {}
        }
        this.sessionFrames.clear();
        if (this.ssh != null && this.ssh.isConnected()) {
            block16: {
                super.closeConnection(doDisconnect);
                if (doDisconnect) {
                    this.closeVNC();
                }
                try {
                    String command = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_POST_VNC_COMMAND, null);
                    if (command == null || command.trim().length() <= 0) break block16;
                    this.statusBar.setStatusText("Executing command: " + command);
                    this.remove(this.vnc);
                    this.add((Component)this.terminal, "Center");
                    this.emulation.reset();
                    this.emulation.clearScreen();
                    this.emulation.setCursorPosition(0, 0);
                    this.terminal.refresh();
                    log.debug("Executing post VNC command " + command);
                    SessionChannelClient session = this.ssh.openSessionChannel();
                    session.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                    if (session.executeCommand(command)) {
                        session.bindInputStream(this.emulation.getTerminalInputStream());
                        session.bindOutputStream(this.emulation.getTerminalOutputStream());
                    }
                    try {
                        session.getState().waitForState(3);
                    }
                    catch (InterruptedException ex) {
                    }
                    finally {
                        this.remove(this.terminal);
                        this.add((Component)this.vnc, "Center");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.statusBar.setUser("");
            this.statusBar.setHost("");
            this.statusBar.setStatusText("Disconnected");
            this.statusBar.setConnected(false);
            this.setAvailableActions();
            this.ssh = null;
            this.forwardingConfig = null;
            this.setNeedSave(false);
            this.setContainerTitle(null);
            this.setAvailableActions();
        }
    }

    @Override
    protected int showAuthenticationPrompt(SshAuthenticationClient instance) throws IOException {
        String profPw = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_SSH_PASSWORD, "");
        if (!profPw.equals("")) {
            ((PasswordAuthenticationClient)instance).setPassword(HexASCII.ToString(profPw));
        }
        instance.setUsername(this.getCurrentConnectionProfile().getUsername());
        if (instance instanceof PasswordAuthenticationClient) {
            PasswordAuthenticationDialog dialog = new PasswordAuthenticationDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this));
            instance.setAuthenticationPrompt(dialog);
            ((PasswordAuthenticationClient)instance).setPasswordChangePrompt(PasswordChange.getInstance());
            PasswordChange.getInstance().setParentComponent(this);
        } else if (instance instanceof PublicKeyAuthenticationClient) {
            PublicKeyAuthenticationPrompt prompt = new PublicKeyAuthenticationPrompt(this);
            instance.setAuthenticationPrompt(prompt);
        } else if (instance instanceof KBIAuthenticationClient) {
            KBIAuthenticationClient kbi = new KBIAuthenticationClient();
            ((KBIAuthenticationClient)instance).setKBIRequestHandler(new KBIRequestHandlerDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this)));
        }
        return this.ssh.authenticate(instance, this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_HOST, "localhost"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticationComplete(boolean newProfile) throws SshException, IOException {
        this.statusBar.setStatusText("User authenticated");
        this.setContainerTitle(this.getCurrentConnectionProfile().getHost());
        int localPort = 0;
        String host = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_HOST, "localhost");
        String port = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_DISPLAY, "5900");
        final VNCDisplay display = new VNCDisplay(host + ":" + port, 5900);
        String addr = "0.0.0.0";
        String command = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PRE_VNC_COMMAND, null);
        if (command != null && command.trim().length() > 0) {
            this.statusBar.setStatusText("Executing command: " + command);
            this.remove(this.vnc);
            this.add((Component)this.terminal, "Center");
            this.emulation.reset();
            this.emulation.clearScreen();
            this.emulation.setCursorPosition(0, 0);
            this.terminal.refresh();
            log.debug("Executing pre VNC command" + command);
            SessionChannelClient session = this.ssh.openSessionChannel();
            session.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
            if (session.executeCommand(command)) {
                session.bindInputStream(this.emulation.getTerminalInputStream());
                session.bindOutputStream(this.emulation.getTerminalOutputStream());
            }
            try {
                session.getState().waitForState(3);
            }
            catch (InterruptedException ex) {
            }
            finally {
                this.remove(this.terminal);
                this.add((Component)this.vnc, "Center");
            }
        }
        this.statusBar.setStatusText("Setting up VNC forwarding");
        if (log.isDebugEnabled()) {
            log.debug("Setting up forwarding on 0.0.0.0 (" + localPort + ") to " + display.getHost() + ":" + display.getPort());
        }
        final SshVNCOptions options = new SshVNCOptions(this.getCurrentConnectionProfile());
        this.statusBar.setStatusText("Initialising VNC");
        ForwardingConfiguration config = new ForwardingConfiguration("VNC", "forwarded-channel", 0, display.getHost(), display.getPort());
        this.channel = new ForwardingIOChannel("direct-tcpip", "VNC", config.getHostToConnect(), config.getPortToConnect(), "0.0.0.0", display.getPort());
        if (this.ssh.openChannel(this.channel)) {
            this.channel.addEventListener(new DataNotificationListener(this.statusBar));
            if (newProfile) {
                this.setNeedSave(true);
            }
            new SshThread(new Runnable(){

                @Override
                public void run() {
                    SshVNCPanel.this.initVNC(SshVNCPanel.this.channel.getInputStream(), SshVNCPanel.this.channel.getOutputStream(), options);
                }
            }, "VNC", true).start();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(SshVNCPanel.this, "SSHVnc failed to open a forwarding channel to " + display.toString(), "SSHVnc", 0);
                    }
                });
            }
            catch (Exception ex) {
                this.statusBar.setStatusText("Could not connect to local forwarding server");
            }
            finally {
                this.closeConnection(true);
            }
        }
    }

    private void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("View", "View", 118, 20));
        this.vncTab = new VNCTab();
        this.newAction = new NewAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SshToolsConnectionProfile newProfile = SshVNCPanel.this.newConnectionProfile(null);
                if (newProfile != null) {
                    SshVNCPanel.this.connect(newProfile, true);
                } else {
                    log.info("New connection cancelled");
                }
            }
        };
        this.registerAction(this.newAction);
        this.closeAction = new CloseAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SshVNCPanel.this.closing = true;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        SshVNCPanel.this.closeConnection(true);
                    }
                };
                thread.start();
            }
        };
        this.registerAction(this.closeAction);
        this.refreshAction = new RefreshAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SshVNCPanel.this.refresh();
            }
        };
        this.registerAction(this.refreshAction);
        this.ctrlAltDelAction = new CtrlAltDelAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    SshVNCPanel.this.vnc.sendCtrlAltDel();
                }
                catch (IOException ioe) {
                    SshVNCPanel.this.closeConnection(true);
                    SshToolsApplicationPanel.showErrorMessage(SshVNCPanel.this, "Error", ioe);
                }
            }
        };
        this.registerAction(this.ctrlAltDelAction);
        this.clipboardAction = new ClipboardAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SshVNCPanel.this.vnc.setClipboardVisible(!SshVNCPanel.this.vnc.isClipboardVisible());
            }
        };
        this.registerAction(this.clipboardAction);
        if (this.getApplication().getMRUModel() != null) {
            this.mruAction = new MRUActionImpl(this.getApplication().getMRUModel());
            this.registerAction(this.mruAction);
        }
        this.connectionPropertiesAction = new ConnectionPropertiesAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SshVNCPanel.this.editConnection(SshVNCPanel.this.getCurrentConnectionProfile());
            }
        };
        this.registerAction(this.connectionPropertiesAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.openAction = new OpenAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SshVNCPanel.this.open();
                }
            };
            this.registerAction(this.openAction);
        }
        catch (AccessControlException ace) {
            ace.printStackTrace();
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            this.saveAction = new SaveAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SshVNCPanel.this.saveConnection(false, SshVNCPanel.this.getCurrentConnectionFile(), SshVNCPanel.this.getCurrentConnectionProfile());
                }
            };
            this.registerAction(this.saveAction);
            this.saveAsAction = new SaveAsAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SshVNCPanel.this.saveConnection(true, SshVNCPanel.this.getCurrentConnectionFile(), SshVNCPanel.this.getCurrentConnectionProfile());
                }
            };
            this.registerAction(this.saveAsAction);
            this.recordAction = new RecordAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SshVNCPanel.this.startRecording();
                }
            };
            this.registerAction(this.recordAction);
            this.stopAction = new StopAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SshVNCPanel.this.stopRecording();
                }
            };
            this.registerAction(this.stopAction);
        }
        catch (AccessControlException ace) {
            ace.printStackTrace();
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.editAction = new EditAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SshVNCPanel.this.editConnection();
                }
            };
            this.registerAction(this.editAction);
        }
        catch (AccessControlException ace) {
            ace.printStackTrace();
        }
        List providers = SessionProviderFactory.getInstance().getSessionProviders();
        for (SessionProvider provider : providers) {
            SessionProviderAction action = new SessionProviderAction(provider);
            this.sessionActions.put(action.getActionCommand(), action);
            action.addActionListener(this);
            this.registerAction(action);
        }
    }

    private void startRecording() {
        if (this.recordingFileChooser == null) {
            this.recordingFileChooser = new JFileChooser(System.getProperty("user.home"));
        }
        int ret = this.recordingFileChooser.showSaveDialog(this);
        int i = 1;
        File file = null;
        while (file == null) {
            File f = new File(this.recordingFileChooser.getCurrentDirectory(), "vncsession.fbs." + i);
            if (!f.exists()) {
                file = f;
            }
            ++i;
        }
        this.recordingFileChooser.setSelectedFile(file);
        if (ret == 0) {
            file = this.recordingFileChooser.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "File " + file.getName() + " already exists. Are you sure?", "File exists", 0, 2) == 1) {
                return;
            }
            this.vnc.setRecordingStatus(file.getAbsolutePath());
            this.setAvailableActions();
        }
    }

    private void stopRecording() {
        this.vnc.setRecordingStatus(null);
        this.setAvailableActions();
    }

    public void refresh() {
        try {
            this.vnc.refresh();
        }
        catch (IOException ioe) {
            this.closeConnection(true);
            SshVNCPanel.showErrorMessage(this, "Error", ioe);
        }
    }

    @Override
    public void setAvailableActions() {
        boolean connected = this.isConnected();
        this.newAction.setEnabled(!connected);
        this.closeAction.setEnabled(connected);
        this.refreshAction.setEnabled(connected);
        this.ctrlAltDelAction.setEnabled(connected);
        this.clipboardAction.setEnabled(connected);
        String sessionFile = this.vnc.getRecordingStatus();
        for (SessionProviderAction action : this.sessionActions.values()) {
            action.setEnabled(connected);
        }
        if (this.stopAction != null) {
            this.stopAction.setEnabled(connected && sessionFile != null);
        }
        if (this.recordAction != null) {
            this.recordAction.setEnabled(connected && sessionFile == null);
        }
        if (this.openAction != null) {
            this.openAction.setEnabled(true);
        }
        this.connectionPropertiesAction.setEnabled(connected);
        this.closeAction.setEnabled(connected);
        if (this.saveAction != null) {
            this.saveAction.setEnabled(connected && this.isNeedSave());
        }
        if (this.saveAsAction != null) {
            this.saveAsAction.setEnabled(connected);
        }
    }

    @Override
    public void close() {
        this.closeConnection(true);
    }

    private TerminalEmulation createEmulation() throws IOException {
        return new TerminalEmulation("vt320");
    }

    @Override
    public boolean canClose() {
        return !this.isConnected() || JOptionPane.showConfirmDialog(this, "Close the current session and exit?", "Exit Application", 0, 3) != 1;
    }

    class MRUActionImpl
    extends MRUAction {
        public MRUActionImpl(MRUListModel model) {
            super(model);
        }

        public void cleanUp() {
            ((MRUMenu)this.getValue("menu")).cleanUp();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SshVNCPanel.this.open(new File(evt.getActionCommand()));
        }
    }

    class IOConnector
    extends Thread {
        InputStream in;
        OutputStream out;

        IOConnector(InputStream in, OutputStream out) {
            super("IOConnector");
            this.in = in;
            this.out = out;
            this.start();
        }

        @Override
        public void run() {
            IOStreamConnector con = new IOStreamConnector(this.in, this.out);
        }
    }

    class ErrorTextBox
    extends JTextArea {
        ErrorTextBox(String text) {
            super(text);
            this.setOpaque(false);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            this.setEditable(false);
        }
    }
}

