/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.Admissions;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralName;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Name;
import java.io.IOException;

public class AdmissionsUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "Admissions";
    }

    public void performTest() throws Exception {
        GeneralName generalName = new GeneralName(new X509Name("CN=hello world"));
        NamingAuthority namingAuthority = new NamingAuthority(new DERObjectIdentifier("1.2.3"), "url", new DirectoryString("fred"));
        Admissions admissions = new Admissions(generalName, namingAuthority, new ProfessionInfo[0]);
        this.checkConstruction(admissions, generalName, namingAuthority);
        admissions = Admissions.getInstance(null);
        if (admissions != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            Admissions.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(Admissions admissions, GeneralName generalName, NamingAuthority namingAuthority) throws IOException {
        this.checkValues(admissions, generalName, namingAuthority);
        admissions = Admissions.getInstance(admissions);
        this.checkValues(admissions, generalName, namingAuthority);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(admissions.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        admissions = Admissions.getInstance(aSN1Sequence);
        this.checkValues(admissions, generalName, namingAuthority);
    }

    private void checkValues(Admissions admissions, GeneralName generalName, NamingAuthority namingAuthority) {
        this.checkMandatoryField("admissionAuthority", generalName, admissions.getAdmissionAuthority());
        this.checkMandatoryField("namingAuthority", namingAuthority, admissions.getNamingAuthority());
    }

    public static void main(String[] stringArray) {
        AdmissionsUnitTest.runTest(new AdmissionsUnitTest());
    }
}

